/*
 * Decompiled with CFR 0.152.
 */
package medusa.applet;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.ToolTipManager;
import medusa.MedusaSettings;
import medusa.applet.ClickLinker;
import medusa.applet.MedusaLite;
import medusa.display.BasicGraphPanel;
import medusa.graph.Graph;
import medusa.graph.Node;

public class MedusaAppletPanel
extends BasicGraphPanel {
    MedusaLite parent;
    private ClickLinker clickLinker;
    private Color basicEdgeColor = Color.gray;
    private Color fontColor = Color.black;

    @Override
    public void setBackgroundColor(Color c) {
        this.setBackground(c);
    }

    @Override
    public void setBasicEdgeColor(Color color) {
        this.basicEdgeColor = color;
    }

    @Override
    public void setFontColor(Color color) {
        this.fontColor = color;
    }

    @Override
    public Color getFontColor() {
        return this.fontColor;
    }

    public MedusaAppletPanel(MedusaSettings stringSettings, MedusaLite parent, String linkStart, String linkEnd) {
        this.stop();
        this.graph = new Graph();
        this.parent = parent;
        this.clickLinker = new ClickLinker(linkStart, linkEnd, parent);
        this.setBackground(Color.white);
        this.setOpaque(true);
        this.setEdgeLen(100.0);
        this.setStringSettings(stringSettings);
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(1000000);
        this.setToolTipText("");
    }

    public MedusaAppletPanel(MedusaSettings stringSettings, MedusaLite parent) {
        this(stringSettings, parent, null, null);
    }

    public MedusaAppletPanel() {
        this.setPreferredSize(new Dimension(600, 600));
        this.setOpaque(true);
        this.setStringSettings(new MedusaSettings());
    }

    @Override
    public void start() {
        if (this.relaxThread == null) {
            this.relaxThread = new Thread(this);
        }
        this.relaxThread.start();
    }

    @Override
    public void stop() {
        if (this.relaxThread != null) {
            this.relaxThread = null;
        }
    }

    @Override
    public void handlePressLeftButton(MouseEvent e) {
        if (e.isShiftDown() & this.clickLinker.isActive()) {
            Node n = this.getClosest(e);
            if (n != null) {
                this.clickLinker.linkOut(n.getLabel());
            }
            e.consume();
            return;
        }
        super.handlePressLeftButton(e);
    }
}

