/*
 * Decompiled with CFR 0.152.
 */
package medusa;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import medusa.ColorJDialog;
import medusa.DataFileFilter;
import medusa.DataFormatException;
import medusa.MedusaSettings;
import medusa.ShowEdgeMultiPanel;
import medusa.SliderZooming;
import medusa.dataio.DataLoader;
import medusa.display.EditableGraphPanel;
import medusa.georgios.Layouts.Layouts;
import medusa.graph.Graph;
import medusa.graph.Node;
import medusa.graphedit.EditGraphDialog;

public class MedusaSimplerFrame
extends JFrame {
    MedusaSettings stringSettings;
    public static EditableGraphPanel stringletPanel;
    static final Color darkBackground;
    static final Color foreground;
    static double oldScale;
    static double scale;
    JLabel startinglabel;
    public static final String version = "1.";
    public static final Color STRINGCOLOR;
    Color background = STRINGCOLOR;
    String lastDir = null;
    String lastFile = null;
    String lastInter = null;
    private boolean hideInteractions = false;
    public static JScrollPane jScrollPane;
    ProgressMonitor loader;
    Timer timer;
    DataLoader dl;
    Frame f = new Frame();
    EditGraphDialog egd;
    ShowEdgeMultiPanel multiedgepanel = new ShowEdgeMultiPanel();
    Border graphBorder = BorderFactory.createRaisedBevelBorder();
    private ActionListener runLoad = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (MedusaSimplerFrame.this.dl.isDone()) {
                MedusaSimplerFrame.this.timer.stop();
                MedusaSimplerFrame.this.dl.stop();
                MedusaSimplerFrame.this.setCursor(null);
                stringletPanel.setGraph(MedusaSimplerFrame.this.dl.getGraph());
                MedusaSimplerFrame.this.updateInfo();
                String[] result = stringletPanel.getGraphData();
                String display = "<html><b>nodes: " + result[0] + "<br>edges: " + result[1] + "<br>" + MedusaSimplerFrame.this.lastFile + "</b></html>";
                JOptionPane.showMessageDialog(stringletPanel, display);
                stringletPanel.repaint();
            }
        }
    };
    private JMenuItem aboutMenuItem;
    private JMenuItem addMenuItem;
    private JMenu addSubractMenu;
    private JMenuItem affinityMenuItem;
    private JMenuItem alignBottom;
    private JMenuItem alignLeft;
    private JMenu alignNodesMenu;
    private JMenuItem alignRight;
    private JMenuItem alignTop;
    private JCheckBoxMenuItem alphaCBMItem;
    private JMenuItem changeColorMenuItem;
    private JMenuItem changeFontSizeMenuItem;
    private JMenuItem changeNodeShapeMenuItem;
    private JMenuItem changeNodeSizeMenuItem;
    public static JRadioButtonMenuItem channel1MenuItem;
    public static JRadioButtonMenuItem channel2MenuItem;
    public static JRadioButtonMenuItem channel3MenuItem;
    private JMenuItem circularMenuItem;
    private JMenuItem clearGraphMenuItem;
    private JMenuItem clearImageMenuItem;
    private JMenu clusteringMenu;
    private JMenu colorMenu;
    private JCheckBoxMenuItem confidenceCBMItem;
    private JMenuItem copyColorMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem cropMenuItem;
    private JMenuItem deleteNodeMenuItem;
    private JCheckBoxMenuItem directedCBMItem;
    private JMenu displayMenu;
    private JMenuItem distanceGeometryMenuItem;
    private JMenuItem editGraphMenuItem;
    private JMenuItem exportEPSMenuItem;
    private JMenu exportImageMenu;
    private JMenuItem exportJPGMenuItem;
    private JMenu exportMenu;
    private JMenuItem exportPNGMenuItem;
    private JMenuItem exportPSMenuItem;
    private JMenuItem exportPajekMenuItem;
    private JMenu exportPostscriptMenu;
    private JMenu fileMenu;
    private JMenu flipMenu;
    private JMenuItem flipXItem;
    private JMenuItem flipYItem;
    private JMenu fontMenu;
    private JMenuItem fruchtermanMenuItem;
    private JMenuItem gridMenuItem;
    private JMenu helpMenu;
    private JCheckBoxMenuItem hideWhenMoveCBMItem;
    private JMenuItem hierarchicalMenuItem;
    private JMenu imageMenu;
    private JMenu importMenu;
    private JMenuItem importTabbedMenuItem;
    public static JMenu interactionMenu;
    private JMenuItem invertFixMenuItem;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    public static JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem50;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JMenuItem jMenuItem8;
    public static JRadioButtonMenuItem jRadioButtonMenuItem1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator10;
    private JSeparator jSeparator11;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator7;
    private JSeparator jSeparator8;
    private JSeparator jSeparator9;
    private JMenuItem kmeansMenuItem;
    private JMenu layoutMenu;
    private JMenuItem loadImageMenuItem;
    private JMenuItem loadInteractionMenuItem;
    private JMenu manipulateMenu;
    private JMenuItem mclMenuItem;
    private JCheckBoxMenuItem namesCBMItem;
    private JMenu nodeColorDisplayMenu;
    private JMenuItem openMenuItem;
    private JMenu optionMenu;
    private JCheckBoxMenuItem prettyCBMItem;
    private JMenuItem quitMenuItem;
    private JMenuItem randomGraphMenuItem;
    private JMenuItem randomMenuItem;
    private JMenuItem recalcButton;
    private JMenu relaxMenu;
    private JMenuItem rotateLeftMenuItem;
    private JMenu rotateMenu;
    private JMenuItem rotateRightMenuItem;
    private JMenuItem saveHTMLParametersMenuItem;
    private JMenuItem saveMenuItem;
    private JMenuItem selectAllMenuItem;
    private JMenuItem selectGrowMenuItem;
    private JMenu selectMenu;
    private JMenuItem selectNodeAnnotationByRegExpMenuItem;
    private JMenuItem selectNodeFromFileMenuItem;
    private JMenuItem selectNodeLabelByRegExpMenuItem;
    private JMenuItem selectNoneMenuItem;
    private JMenuItem setBackgroundColorMenuItem;
    private JMenuItem setBasicEdgeColorMenuItem;
    private JMenuItem setEdgeLenMenuItem;
    private JMenuItem setLabelColorMenuItem;
    private JCheckBoxMenuItem showNamesCBMItem;
    private JMenuItem startRelaxMenuItem;
    private JMenuItem stopRelaxMenuItem;
    private JMenuItem stringButton;
    private JMenu stringCOGInteractionMenuItem;
    private JMenuItem stringProteinInteractionMenuItem;
    private JMenuItem subtractMenuItem;
    private JMenuItem switchColorMenuItem;
    private JCheckBoxMenuItem temperatureButton;
    private JMenu zoomMenu;

    public MedusaSimplerFrame() {
        this.setPreferredSize(new Dimension(700, 700));
        MedusaSimplerFrame.setLnF();
        this.stringSettings = new MedusaSettings();
        stringletPanel = new EditableGraphPanel(this.stringSettings);
        stringletPanel.setBasicEdgeColor(Color.black);
        stringletPanel.setTimeFrameXY(600, 600);
        stringletPanel.setBorder(this.graphBorder);
        stringletPanel.setShowBorder(false);
        stringletPanel.setArrows(false);
        stringletPanel.setCool(true);
        jScrollPane = new JScrollPane(stringletPanel);
        this.egd = new EditGraphDialog((Frame)this, true);
        this.show_starting_background();
        this.initComponents();
        this.add(jScrollPane);
        jMenuItem4.setPreferredSize(new Dimension(200, 180));
        jMenuItem4.add(this.multiedgepanel);
        jMenuItem4.repaint();
        SliderZooming slider = new SliderZooming();
        this.jMenuItem1.setPreferredSize(new Dimension(slider.getPreferredSize().width + 25, slider.getPreferredSize().height + 5));
        this.jMenuItem1.setLayout(new BorderLayout());
        this.jMenuItem1.add(slider);
        this.jMenuItem1.repaint();
    }

    public EditableGraphPanel getPanel() {
        return stringletPanel;
    }

    public MedusaSettings getSettings() {
        return this.stringSettings;
    }

    private void stringConnection() {
        JOptionPane.showConfirmDialog(this, "STRING requires a license and is not\navailable to open source", "Disabled", -1, 1);
    }

    private void show_starting_background() {
        ImageIcon startingIcon = new ImageIcon(this.getClass().getResource("/medusa/images/welcome.jpg"));
        this.startinglabel = new JLabel();
        this.startinglabel.setIcon(startingIcon);
        stringletPanel.add(this.startinglabel);
        stringletPanel.repaint();
    }

    public void hide_starting_background() {
        this.startinglabel.setVisible(false);
        stringletPanel.repaint();
    }

    public static void setLnF() {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception e) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setShapeEvent() {
        Object[] shapes = new Object[]{"circle", "rectangle", "triangle", "diamond"};
        int s = JOptionPane.showOptionDialog(this, "Choose a node shape", "Shape", 1, 3, null, shapes, "circle");
        stringletPanel.setShape(s);
    }

    public void loadImageEvent() {
        stringletPanel.stop();
        FileDialog fdLoad = new FileDialog((Frame)this, "Load image", 0);
        fdLoad.setVisible(true);
        String loadFile = fdLoad.getFile();
        String dir = fdLoad.getDirectory();
        if (loadFile != null) {
            try {
                stringletPanel.setImage(dir + loadFile);
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(this, "The image could not be found or opened", "Load Error", 0);
            }
        }
        stringletPanel.repaint();
    }

    private void stopAllRelax() {
        stringletPanel.stop();
    }

    public void clearImageEvent() {
        this.stopAllRelax();
        stringletPanel.clearImage();
        stringletPanel.repaint();
    }

    public void quitApplication() {
        this.stopAllRelax();
        System.out.println("Closing application");
        try {
            this.saveSettings();
            System.out.println("Current settings saved");
        }
        catch (IOException ie) {
            System.out.println("...settings not saved due to file problems");
        }
        this.remove(stringletPanel);
        this.dispose();
    }

    public void scaleOut() {
        double scale = 1.0;
        stringletPanel.setScale(scale / oldScale);
        Dimension d = stringletPanel.getSize();
        stringletPanel.setTimeFrameXY(d);
        oldScale = scale;
        stringletPanel.repaint();
        stringletPanel.revalidate();
        jScrollPane.revalidate();
    }

    public static void setScale(JSlider src) {
        Dimension d = stringletPanel.getSize();
        double scale = (double)src.getValue() / 100.0;
        stringletPanel.setScale(scale / oldScale);
        stringletPanel.setTimeFrameXY(d);
        oldScale = scale;
        stringletPanel.repaint();
        stringletPanel.revalidate();
        jScrollPane.revalidate();
    }

    public void setScale(int scaleValue) {
        Dimension d = stringletPanel.getSize();
        double scale = (double)scaleValue / 100.0;
        stringletPanel.setScale(scale / oldScale);
        stringletPanel.setTimeFrameXY(d);
        oldScale = scale;
        stringletPanel.repaint();
        stringletPanel.revalidate();
        jScrollPane.revalidate();
    }

    public void saveSettings() throws IOException {
        if (this.lastDir != null) {
            File saveFile = new File("NetViewSettings.ini");
            FileWriter out = new FileWriter(saveFile);
            out.write("LASTDIR=");
            out.write(this.lastDir + "\n");
            if (this.lastInter != null) {
                out.write("INTERACT=");
                out.write(this.lastInter + "\n");
            }
            out.close();
        }
    }

    private boolean loadSettings() throws IOException {
        Pattern interPattern;
        File loadFile = new File("NetViewSettings.ini");
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(loadFile)));
        String inLine = in.readLine();
        if (inLine == null) {
            System.out.println("Error in NetViewSettings.ini");
            return false;
        }
        Pattern dirPattern = Pattern.compile("LASTDIR=(.+)");
        Matcher matcher = dirPattern.matcher(inLine);
        if (!matcher.find()) {
            return false;
        }
        this.lastDir = matcher.group(1);
        inLine = in.readLine();
        if (inLine != null && (matcher = (interPattern = Pattern.compile("INTERACT=(\\w+)")).matcher(inLine)).find()) {
            this.lastInter = matcher.group(1);
        }
        in.close();
        return true;
    }

    private String getFixedNodesAsString() {
        StringBuffer sb = new StringBuffer();
        sb.append("");
        ArrayList nodeArray = stringletPanel.getFixed();
        for (Node n : nodeArray) {
            sb.append(n.getLabel());
            sb.append("\n");
        }
        return sb.toString();
    }

    private void proteinInteractionEvent() {
        this.stringSettings.clear();
        this.stringSettings.init();
        stringletPanel.updateStringSettings(this.stringSettings);
    }

    private void cogInteractionEvent() {
        this.stringSettings.clear();
        this.stringSettings.initCOGS();
        stringletPanel.updateStringSettings(this.stringSettings);
    }

    private void setEdgeLenEvent() {
        int len = (int)stringletPanel.getEdgeLen();
        String s = JOptionPane.showInputDialog("Enter desired edge length in pixels:\nSet to 0 for default length", (Object)String.valueOf(len));
        if (s != null && s.length() > 0) {
            try {
                int newSize = Integer.parseInt(s);
                stringletPanel.setEdgeLen(newSize);
            }
            catch (NumberFormatException ne) {
                JOptionPane.showMessageDialog(this, "Incorrect input", "An integer is required for this action", 0);
            }
        }
    }

    public void updateInfo() {
        String[] result = stringletPanel.getGraphData();
    }

    public void waitForLoad(String fileName, int loadType) throws IOException, DataFormatException {
        this.dl = new DataLoader(600, 600, fileName);
        this.dl.setLoadType(loadType);
        this.timer = new Timer(500, this.runLoad);
        this.dl.start();
        this.timer.start();
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void setNodeColorSet(int i) {
        stringletPanel.setNodeColorSet(i);
        stringletPanel.repaint();
    }

    private void loadEvent(int loadType) {
        this.stopAllRelax();
        this.scaleOut();
        FileDialog fdLoad = new FileDialog((Frame)this, "Load graph", 0);
        if (this.lastDir != null) {
            fdLoad.setDirectory(this.lastDir);
        }
        fdLoad.setFilenameFilter(new DataFileFilter());
        fdLoad.setVisible(true);
        String loadFile = fdLoad.getFile();
        String dir = fdLoad.getDirectory();
        if (loadFile != null) {
            try {
                this.waitForLoad(dir + loadFile, loadType);
                this.lastDir = dir;
                this.lastFile = loadFile;
            }
            catch (IOException ie) {
                ie.printStackTrace();
                JOptionPane.showMessageDialog(this, "The file could not be found or opened", "Load Error", 0);
            }
            catch (DataFormatException dfe) {
                JOptionPane.showMessageDialog(this, dfe.getMessage(), "Data Error", 0);
            }
        }
    }

    private void addGraphEvent() {
        this.stopAllRelax();
        this.scaleOut();
        FileDialog fdLoad = new FileDialog((Frame)this, "Add graph", 0);
        if (this.lastDir != null) {
            fdLoad.setFile(this.lastDir + this.lastFile);
        }
        fdLoad.setFilenameFilter(new DataFileFilter());
        fdLoad.setVisible(true);
        String loadFile = fdLoad.getFile();
        String dir = fdLoad.getDirectory();
        if (loadFile != null) {
            try {
                stringletPanel.appendGraph(dir + loadFile);
                this.lastDir = dir + loadFile;
                this.lastFile = loadFile;
                this.updateInfo();
                stringletPanel.repaint();
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(this, "The file could not be found or opened", "Load Error", 0);
            }
            catch (DataFormatException dfe) {
                JOptionPane.showMessageDialog(this, dfe.getMessage(), "Data Error", 0);
            }
        }
    }

    private void subtractGraphEvent() {
        this.stopAllRelax();
        this.scaleOut();
        FileDialog fdLoad = new FileDialog((Frame)this, "Add graph", 0);
        if (this.lastDir != null) {
            fdLoad.setFile(this.lastDir + this.lastFile);
        }
        fdLoad.setFilenameFilter(new DataFileFilter());
        fdLoad.setVisible(true);
        String loadFile = fdLoad.getFile();
        String dir = fdLoad.getDirectory();
        if (loadFile != null) {
            try {
                stringletPanel.subtractGraph(dir + loadFile);
                this.lastDir = dir + loadFile;
                this.lastFile = loadFile;
                this.updateInfo();
                stringletPanel.repaint();
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(this, "The file could not be found or opened", "Load Error", 0);
            }
            catch (DataFormatException dfe) {
                JOptionPane.showMessageDialog(this, dfe.getMessage(), "Data Error", 0);
            }
        }
    }

    private void saveEvent() {
        FileDialog fdSave = new FileDialog((Frame)this, "Save as", 1);
        fdSave.setFilenameFilter(new DataFileFilter());
        fdSave.setVisible(true);
        String saveFile = fdSave.getFile();
        String dir = fdSave.getDirectory();
        if (saveFile != null) {
            this.lastDir = dir;
            this.lastFile = saveFile;
            try {
                stringletPanel.saveGraph(dir + saveFile);
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(this, "Error saving file.", "Save error", 0);
            }
        }
    }

    private void copyGraphEvent() {
        this.stopAllRelax();
        this.scaleOut();
        FileDialog fdLoad = new FileDialog((Frame)this, "Add graph", 0);
        if (this.lastDir != null) {
            fdLoad.setFile(this.lastDir + this.lastFile);
        }
        fdLoad.setFilenameFilter(new DataFileFilter());
        fdLoad.setVisible(true);
        String loadFile = fdLoad.getFile();
        String dir = fdLoad.getDirectory();
        if (loadFile != null) {
            try {
                stringletPanel.copyGraphSettings(dir + loadFile);
                this.lastDir = dir + loadFile;
                this.lastFile = loadFile;
                this.updateInfo();
                stringletPanel.repaint();
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(this, "The file could not be found or opened", "Load Error", 0);
            }
            catch (DataFormatException dfe) {
                JOptionPane.showMessageDialog(this, dfe.getMessage(), "Data Error", 0);
            }
        }
    }

    private void exportImageEvent(boolean png) {
        String name = "network." + (png ? "png" : "jpg");
        FileDialog fdSave = new FileDialog((Frame)this, "Save as " + (png ? "png" : "jpg"), 1);
        fdSave.setFile(name);
        fdSave.setVisible(true);
        String saveFile = fdSave.getFile();
        if (saveFile == null) {
            return;
        }
        String dir = fdSave.getDirectory();
        int type = png ? 1 : 0;
        stringletPanel.saveImage(dir + saveFile, type);
        JOptionPane.showMessageDialog(this, "Panel exported to " + saveFile, "Image saved", 1);
    }

    private void exportPajekEvent() {
        FileDialog fdSave = new FileDialog((Frame)this, "Save as pajek", 1);
        fdSave.setVisible(true);
        String saveFile = fdSave.getFile();
        String dir = fdSave.getDirectory();
        if (saveFile != null) {
            try {
                stringletPanel.writePajek(dir + saveFile + ".pajek");
                JOptionPane.showMessageDialog(this, "Exported to pajek format " + saveFile + ".pajek", "Pajek", 1);
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(this, "Error saving file.", "Save error", 0);
            }
        }
    }

    private void exportArena3DEvent() {
        FileDialog fdSave = new FileDialog((Frame)this, "Save as Arena3d", 1);
        fdSave.setVisible(true);
        String saveFile = fdSave.getFile();
        String dir = fdSave.getDirectory();
        if (saveFile != null) {
            try {
                stringletPanel.writeArena3D(dir + saveFile + ".a3d");
                JOptionPane.showMessageDialog(this, "Exported to Arena3D format " + saveFile + ".a3d", "Arena3D", 1);
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(this, "Error saving file.", "Save error", 0);
            }
        }
    }

    private void exportCytoscapeEvent() {
        FileDialog fdSave = new FileDialog((Frame)this, "Save as Cytoscape", 1);
        fdSave.setVisible(true);
        String saveFile = fdSave.getFile();
        String dir = fdSave.getDirectory();
        if (saveFile != null) {
            try {
                stringletPanel.writeCytoscape(dir + saveFile + ".sif");
                JOptionPane.showMessageDialog(this, "Exported to Cytoscape format " + saveFile + ".sif", "Cytoscape", 1);
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(this, "Error saving file.", "Save error", 0);
            }
        }
    }

    private void exportGraphVizEvent() {
        FileDialog fdSave = new FileDialog((Frame)this, "Save as GraphViz", 1);
        fdSave.setVisible(true);
        String saveFile = fdSave.getFile();
        String dir = fdSave.getDirectory();
        if (saveFile != null) {
            try {
                stringletPanel.writeGraphViz(dir + saveFile + ".dot");
                JOptionPane.showMessageDialog(this, "Exported to GraphViz format " + saveFile + ".dot", "GraphViz", 1);
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(this, "Error saving file.", "Save error", 0);
            }
        }
    }

    private void exportBiolayoutEvent() {
        FileDialog fdSave = new FileDialog((Frame)this, "Save as Biolayout Express 3D", 1);
        fdSave.setVisible(true);
        String saveFile = fdSave.getFile();
        String dir = fdSave.getDirectory();
        if (saveFile != null) {
            try {
                stringletPanel.writeBiolayout(dir + saveFile + ".layout");
                JOptionPane.showMessageDialog(this, "Exported to Biolayout Express 3D format " + saveFile + ".layout", "Biolayout Express 3D", 1);
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(this, "Error saving file.", "Save error", 0);
            }
        }
    }

    private void saveHTMLParametersEvent() {
        FileDialog fdSave = new FileDialog((Frame)this, "Save applet parameters to", 1);
        fdSave.setVisible(true);
        String saveFile = fdSave.getFile();
        this.dl = new DataLoader();
        if (saveFile != null) {
            try {
                this.dl.saveHTMLParameters(stringletPanel.getGraph(), saveFile);
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(this, "Error saving file.", "Save error", 0);
            }
        }
    }

    public void stopRelax() {
        stringletPanel.stop();
    }

    private void searchNodeEvent(boolean label) {
        String s = JOptionPane.showInputDialog("Mark node matching regular expression:\ne.g. \"mito.*\"", (Object)"");
        if (s != null && stringletPanel.selectNodeByRegExp(s, label) == 0) {
            JOptionPane.showMessageDialog(this, "No match found", "No nodes matching your pattern were found", 0);
        }
        stringletPanel.repaint();
    }

    private void selectNodeFromFileEvent() {
        FileDialog fdSelect = new FileDialog((Frame)this, "Load node list", 0);
        if (this.lastDir != null) {
            fdSelect.setDirectory(this.lastDir);
        }
        fdSelect.setVisible(true);
        String loadFile = fdSelect.getFile();
        String dir = fdSelect.getDirectory();
        try {
            int c = stringletPanel.selectNodeFromFile(dir + loadFile);
            stringletPanel.repaint();
        }
        catch (IOException sNFFe) {
            JOptionPane.showMessageDialog(this, sNFFe.getMessage(), "Load Error", 0);
        }
    }

    private void changeNodeSizeEvent() {
        String s = JOptionPane.showInputDialog("Enter node size in pixels:\nDefault value is 10", (Object)"");
        int newSize = -1;
        if (s != null && s.length() > 0) {
            try {
                newSize = Integer.parseInt(s);
                stringletPanel.setNodeSize(newSize);
            }
            catch (NumberFormatException ne) {
                JOptionPane.showMessageDialog(this, "Incorrect input", "An integer is required for this action", 0);
            }
        }
        stringletPanel.repaint();
    }

    private void changeColorEvent() {
        Color newColor = JColorChooser.showDialog(this.getRootPane(), "Choose node color", Color.red);
        if (newColor != null) {
            stringletPanel.changeNodeColor(newColor);
            stringletPanel.repaint();
        }
    }

    private void setLabelColorEvent() {
        Color newColor = JColorChooser.showDialog(this.getRootPane(), "Choose label color", Color.black);
        if (newColor != null) {
            stringletPanel.setFontColor(newColor);
            stringletPanel.repaint();
        }
    }

    private void setBackgroundColorEvent() {
        Color newColor = JColorChooser.showDialog(this.getRootPane(), "Choose label color", Color.white);
        if (newColor != null) {
            stringletPanel.setBackgroundColor(newColor);
            stringletPanel.repaint();
        }
    }

    private void setBasicEdgeColorEvent() {
        Color newColor = JColorChooser.showDialog(this.getRootPane(), "Choose label color", Color.gray);
        if (newColor != null) {
            stringletPanel.setBasicEdgeColor(newColor);
            stringletPanel.repaint();
        }
    }

    private void changeFontSizeEvent() {
        String s = JOptionPane.showInputDialog("Enter font size:\nDefault value is 10", (Object)"");
        if (s != null && s.length() > 0) {
            try {
                int newSize = Integer.parseInt(s);
                stringletPanel.changeFont(newSize);
            }
            catch (NumberFormatException ne) {
                JOptionPane.showMessageDialog(this, "Incorrect input", "An integer is required for this action", 0);
            }
        }
        stringletPanel.repaint();
    }

    private void switchColorEvent() {
        int[] colors = ColorJDialog.showDialog(this.f, null, "switch with");
        stringletPanel.manipulateColor(colors[0], colors[1], true);
        stringletPanel.repaint();
    }

    private void copyColorEvent() {
        int[] colors = ColorJDialog.showDialog(this.f, null, "copy to");
        stringletPanel.manipulateColor(colors[0], colors[1], false);
        stringletPanel.repaint();
    }

    private void interactionEvent() {
        FileDialog fdInter = new FileDialog((Frame)this, "Load interaction file", 0);
        fdInter.setVisible(true);
        String loadFile = fdInter.getFile();
        String dir = fdInter.getDirectory();
        if (loadFile != null) {
            try {
                this.lastInter = dir + loadFile;
                this.stringSettings.load(dir + loadFile);
                stringletPanel.updateStringSettings(this.stringSettings);
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(this, "Interaction settings could not be loaded.\nCheck if the file is valid.", "Load error", 0);
            }
        }
    }

    private void editGraph() {
        this.stopAllRelax();
        this.egd = new EditGraphDialog((Frame)this, true);
        this.egd.setGraph(stringletPanel.getGraph());
        this.egd.setVisible(true);
        Graph g = this.egd.getGraph();
        if (g != null) {
            stringletPanel.setGraph(g);
            stringletPanel.repaint();
        }
    }

    public void clearGraphEvent() {
        this.stopAllRelax();
        if (this.yes_no("Your data will be lost. Are you sure?") == 0) {
            stringletPanel.clearGraph();
            stringletPanel.repaint();
            this.updateInfo();
        }
    }

    private int yes_no(String message) {
        int s = JOptionPane.showConfirmDialog(this, message, "Confirm", 0);
        return s;
    }

    private void rotateEvent(double degrees) {
        this.stopAllRelax();
        stringletPanel.rotate(degrees);
        stringletPanel.repaint();
    }

    private void getRandomGraphEvent() {
        int s = this.yes_no("This will generate a random graph. Are you sure?");
        if (s == 0) {
            this.stopAllRelax();
            stringletPanel.randomGraph(30, 60);
            this.updateInfo();
            stringletPanel.repaint();
        }
    }

    private void recalcEvent() {
        this.stopAllRelax();
        if (this.yes_no("This will return edge length \nand orientation to default values\n Are you sure you want to do this?") == 0) {
            stringletPanel.autoFixOrientation();
            stringletPanel.calculateEdgeLength();
            stringletPanel.repaint();
        }
    }

    public static void handleEdgeEvent(int number, boolean selected) {
        stringletPanel.setShowEdge(number - 1, selected);
        stringletPanel.repaint();
    }

    private void exportEPSEvent() {
        FileDialog fdSave = new FileDialog((Frame)this, "Save as EPS", 1);
        fdSave.setVisible(true);
        String saveFile = fdSave.getFile();
        String dir = fdSave.getDirectory();
        if (saveFile != null) {
            try {
                stringletPanel.writeEPS(dir + saveFile);
                JOptionPane.showMessageDialog(this, "Panel exported to " + saveFile, "EPS saved", 1);
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(this, "Error saving file.", "Save error", 0);
            }
        }
    }

    private void exportPSEvent() {
        FileDialog fdSave = new FileDialog((Frame)this, "Save as PS", 1);
        fdSave.setVisible(true);
        String saveFile = fdSave.getFile();
        String dir = fdSave.getDirectory();
        if (saveFile != null) {
            try {
                stringletPanel.writePS(dir + saveFile);
                JOptionPane.showMessageDialog(this, "Panel exported to " + saveFile, "PS saved", 1);
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(this, "Error saving file.", "Save error", 0);
            }
        }
    }

    public void alignNodes(int align) {
        if (stringletPanel.getFixed().size() < 2) {
            JOptionPane.showMessageDialog(this, "You must select at least two nodes", "Error", 0);
            return;
        }
        stringletPanel.alignNodes(align);
        stringletPanel.repaint();
    }

    private void initComponents() {
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.addSubractMenu = new JMenu();
        this.addMenuItem = new JMenuItem();
        this.subtractMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.importMenu = new JMenu();
        this.importTabbedMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.exportMenu = new JMenu();
        this.exportImageMenu = new JMenu();
        this.exportJPGMenuItem = new JMenuItem();
        this.exportPNGMenuItem = new JMenuItem();
        this.exportPostscriptMenu = new JMenu();
        this.exportPSMenuItem = new JMenuItem();
        this.exportEPSMenuItem = new JMenuItem();
        this.saveHTMLParametersMenuItem = new JMenuItem();
        this.exportPajekMenuItem = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        this.jMenuItem6 = new JMenuItem();
        this.jMenuItem7 = new JMenuItem();
        this.jMenuItem8 = new JMenuItem();
        this.stringButton = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.quitMenuItem = new JMenuItem();
        this.layoutMenu = new JMenu();
        this.randomMenuItem = new JMenuItem();
        this.circularMenuItem = new JMenuItem();
        this.gridMenuItem = new JMenuItem();
        this.jSeparator9 = new JSeparator();
        this.relaxMenu = new JMenu();
        this.startRelaxMenuItem = new JMenuItem();
        this.stopRelaxMenuItem = new JMenuItem();
        this.temperatureButton = new JCheckBoxMenuItem();
        this.jSeparator10 = new JSeparator();
        this.fruchtermanMenuItem = new JMenuItem();
        this.hierarchicalMenuItem = new JMenuItem();
        this.distanceGeometryMenuItem = new JMenuItem();
        this.clusteringMenu = new JMenu();
        this.kmeansMenuItem = new JMenuItem();
        this.affinityMenuItem = new JMenuItem();
        this.mclMenuItem = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.zoomMenu = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.selectMenu = new JMenu();
        this.selectAllMenuItem = new JMenuItem();
        this.selectNoneMenuItem = new JMenuItem();
        this.selectNodeLabelByRegExpMenuItem = new JMenuItem();
        this.selectNodeAnnotationByRegExpMenuItem = new JMenuItem();
        this.selectNodeFromFileMenuItem = new JMenuItem();
        this.invertFixMenuItem = new JMenuItem();
        this.selectGrowMenuItem = new JMenuItem();
        this.optionMenu = new JMenu();
        this.jMenuItem3 = new JMenuItem();
        this.changeNodeSizeMenuItem = new JMenuItem();
        this.setEdgeLenMenuItem = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.colorMenu = new JMenu();
        this.changeColorMenuItem = new JMenuItem();
        this.switchColorMenuItem = new JMenuItem();
        this.copyColorMenuItem = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.setBasicEdgeColorMenuItem = new JMenuItem();
        this.setBackgroundColorMenuItem = new JMenuItem();
        this.fontMenu = new JMenu();
        this.setLabelColorMenuItem = new JMenuItem();
        this.changeFontSizeMenuItem = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.imageMenu = new JMenu();
        this.loadImageMenuItem = new JMenuItem();
        this.clearImageMenuItem = new JMenuItem();
        this.manipulateMenu = new JMenu();
        this.clearGraphMenuItem = new JMenuItem();
        this.changeNodeShapeMenuItem = new JMenuItem();
        this.deleteNodeMenuItem = new JMenuItem();
        this.cropMenuItem = new JMenuItem();
        this.randomGraphMenuItem = new JMenuItem();
        this.rotateMenu = new JMenu();
        this.rotateRightMenuItem = new JMenuItem();
        this.rotateLeftMenuItem = new JMenuItem();
        this.flipMenu = new JMenu();
        this.flipXItem = new JMenuItem();
        this.flipYItem = new JMenuItem();
        this.alignNodesMenu = new JMenu();
        this.alignTop = new JMenuItem();
        this.alignBottom = new JMenuItem();
        this.alignLeft = new JMenuItem();
        this.alignRight = new JMenuItem();
        this.jSeparator5 = new JSeparator();
        this.editGraphMenuItem = new JMenuItem();
        this.recalcButton = new JMenuItem();
        interactionMenu = new JMenu();
        this.loadInteractionMenuItem = new JMenuItem();
        this.jSeparator6 = new JSeparator();
        jMenuItem4 = new JMenuItem();
        this.jSeparator11 = new JSeparator();
        this.stringCOGInteractionMenuItem = new JMenu();
        this.stringProteinInteractionMenuItem = new JMenuItem();
        this.jMenuItem50 = new JMenuItem();
        this.displayMenu = new JMenu();
        this.prettyCBMItem = new JCheckBoxMenuItem();
        this.namesCBMItem = new JCheckBoxMenuItem();
        this.showNamesCBMItem = new JCheckBoxMenuItem();
        this.directedCBMItem = new JCheckBoxMenuItem();
        this.confidenceCBMItem = new JCheckBoxMenuItem();
        this.alphaCBMItem = new JCheckBoxMenuItem();
        this.jSeparator7 = new JSeparator();
        this.hideWhenMoveCBMItem = new JCheckBoxMenuItem();
        this.jSeparator8 = new JSeparator();
        this.nodeColorDisplayMenu = new JMenu();
        channel1MenuItem = new JRadioButtonMenuItem();
        channel2MenuItem = new JRadioButtonMenuItem();
        channel3MenuItem = new JRadioButtonMenuItem();
        jRadioButtonMenuItem1 = new JRadioButtonMenuItem();
        this.helpMenu = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Medusa 1.5");
        this.setBackground(new Color(255, 255, 255));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                MedusaSimplerFrame.this.formKeyTyped(evt);
            }
        });
        this.fileMenu.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/medusa_logo_smaller.png")));
        this.fileMenu.setText("File");
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Folder-Open.gif")));
        this.openMenuItem.setText("Open");
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.addSubractMenu.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Add.gif")));
        this.addSubractMenu.setText("Add/Subtract");
        this.addSubractMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.addSubractMenuActionPerformed(evt);
            }
        });
        this.addMenuItem.setText("Add Graph");
        this.addMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.addMenuItemActionPerformed(evt);
            }
        });
        this.addSubractMenu.add(this.addMenuItem);
        this.subtractMenuItem.setText("Subtract Graph");
        this.subtractMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.subtractMenuItemActionPerformed(evt);
            }
        });
        this.addSubractMenu.add(this.subtractMenuItem);
        this.copyMenuItem.setText("Copy Settings");
        this.copyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.copyMenuItemActionPerformed(evt);
            }
        });
        this.addSubractMenu.add(this.copyMenuItem);
        this.fileMenu.add(this.addSubractMenu);
        this.importMenu.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/import.gif")));
        this.importMenu.setText("Import");
        this.importTabbedMenuItem.setText("Simple Tabbed");
        this.importTabbedMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.importTabbedMenuItemActionPerformed(evt);
            }
        });
        this.importMenu.add(this.importTabbedMenuItem);
        this.fileMenu.add(this.importMenu);
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Save.gif")));
        this.saveMenuItem.setText("Save");
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.exportMenu.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/export.gif")));
        this.exportMenu.setText("Export");
        this.exportImageMenu.setText("Image");
        this.exportJPGMenuItem.setText("JPG");
        this.exportJPGMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.exportJPGMenuItemActionPerformed(evt);
            }
        });
        this.exportImageMenu.add(this.exportJPGMenuItem);
        this.exportPNGMenuItem.setText("PNG");
        this.exportPNGMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.exportPNGMenuItemActionPerformed(evt);
            }
        });
        this.exportImageMenu.add(this.exportPNGMenuItem);
        this.exportMenu.add(this.exportImageMenu);
        this.exportPostscriptMenu.setText("PostScript");
        this.exportPSMenuItem.setText("PS");
        this.exportPSMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.exportPSMenuItemActionPerformed(evt);
            }
        });
        this.exportPostscriptMenu.add(this.exportPSMenuItem);
        this.exportEPSMenuItem.setText("EPS");
        this.exportEPSMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.exportEPSMenuItemActionPerformed(evt);
            }
        });
        this.exportPostscriptMenu.add(this.exportEPSMenuItem);
        this.exportMenu.add(this.exportPostscriptMenu);
        this.saveHTMLParametersMenuItem.setText("HTML Parameters");
        this.saveHTMLParametersMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.saveHTMLParametersMenuItemActionPerformed(evt);
            }
        });
        this.exportMenu.add(this.saveHTMLParametersMenuItem);
        this.exportPajekMenuItem.setText("Pajek");
        this.exportPajekMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.exportPajekMenuItemActionPerformed(evt);
            }
        });
        this.exportMenu.add(this.exportPajekMenuItem);
        this.jMenuItem5.setText("Arena3D");
        this.jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.jMenuItem5ActionPerformed(evt);
            }
        });
        this.exportMenu.add(this.jMenuItem5);
        this.jMenuItem6.setText("BioLayout Express 3D");
        this.jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.jMenuItem6ActionPerformed(evt);
            }
        });
        this.exportMenu.add(this.jMenuItem6);
        this.jMenuItem7.setText("Cytoscape");
        this.jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.jMenuItem7ActionPerformed(evt);
            }
        });
        this.exportMenu.add(this.jMenuItem7);
        this.jMenuItem8.setText("GraphViz");
        this.jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.jMenuItem8ActionPerformed(evt);
            }
        });
        this.exportMenu.add(this.jMenuItem8);
        this.fileMenu.add(this.exportMenu);
        this.stringButton.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Datbase.gif")));
        this.stringButton.setText("Database connection");
        this.stringButton.setEnabled(false);
        this.stringButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.stringButtonActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.stringButton);
        this.fileMenu.add(this.jSeparator1);
        this.quitMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.quitMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Application-cancel.gif")));
        this.quitMenuItem.setText("Quit");
        this.quitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.quitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.quitMenuItem);
        this.jMenuBar1.add(this.fileMenu);
        this.layoutMenu.setText("Layout");
        this.randomMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.randomMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Tag-Blue.gif")));
        this.randomMenuItem.setText("Random");
        this.randomMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.randomMenuItemActionPerformed(evt);
            }
        });
        this.layoutMenu.add(this.randomMenuItem);
        this.circularMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.circularMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Tag-Green.gif")));
        this.circularMenuItem.setText("Circular");
        this.circularMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.circularMenuItemActionPerformed(evt);
            }
        });
        this.layoutMenu.add(this.circularMenuItem);
        this.gridMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.gridMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Tag-Orange.gif")));
        this.gridMenuItem.setText("Grid");
        this.gridMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.gridMenuItemActionPerformed(evt);
            }
        });
        this.layoutMenu.add(this.gridMenuItem);
        this.layoutMenu.add(this.jSeparator9);
        this.relaxMenu.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Tag-Del.gif")));
        this.relaxMenu.setText("Relax");
        this.startRelaxMenuItem.setAccelerator(KeyStroke.getKeyStroke(32, 2));
        this.startRelaxMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Compile-Run.gif")));
        this.startRelaxMenuItem.setText("Start relaxation");
        this.startRelaxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.startRelaxMenuItemActionPerformed(evt);
            }
        });
        this.relaxMenu.add(this.startRelaxMenuItem);
        this.stopRelaxMenuItem.setAccelerator(KeyStroke.getKeyStroke(32, 10));
        this.stopRelaxMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Compile-Cancel.gif")));
        this.stopRelaxMenuItem.setText("Stop relaxation");
        this.stopRelaxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.stopRelaxMenuItemActionPerformed(evt);
            }
        });
        this.relaxMenu.add(this.stopRelaxMenuItem);
        this.temperatureButton.setSelected(true);
        this.temperatureButton.setText("Cooling");
        this.temperatureButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MedusaSimplerFrame.this.temperatureButtonItemStateChanged(evt);
            }
        });
        this.relaxMenu.add(this.temperatureButton);
        this.layoutMenu.add(this.relaxMenu);
        this.layoutMenu.add(this.jSeparator10);
        this.fruchtermanMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.fruchtermanMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Tag-Purple.gif")));
        this.fruchtermanMenuItem.setText("Fruchterman");
        this.fruchtermanMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.fruchtermanMenuItemActionPerformed(evt);
            }
        });
        this.layoutMenu.add(this.fruchtermanMenuItem);
        this.hierarchicalMenuItem.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.hierarchicalMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Tag-Red.gif")));
        this.hierarchicalMenuItem.setText("Hierarchical");
        this.hierarchicalMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.hierarchicalMenuItemActionPerformed(evt);
            }
        });
        this.layoutMenu.add(this.hierarchicalMenuItem);
        this.distanceGeometryMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.distanceGeometryMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Tag-Yellow.gif")));
        this.distanceGeometryMenuItem.setText("Distance Geometry");
        this.distanceGeometryMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.distanceGeometryMenuItemActionPerformed(evt);
            }
        });
        this.layoutMenu.add(this.distanceGeometryMenuItem);
        this.jMenuBar1.add(this.layoutMenu);
        this.clusteringMenu.setText("Clustering");
        this.kmeansMenuItem.setAccelerator(KeyStroke.getKeyStroke(75, 2));
        this.kmeansMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Flag-Cyan.gif")));
        this.kmeansMenuItem.setText("K-Means");
        this.kmeansMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.kmeansMenuItemActionPerformed(evt);
            }
        });
        this.clusteringMenu.add(this.kmeansMenuItem);
        this.affinityMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.affinityMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Flag-Red.gif")));
        this.affinityMenuItem.setText("Affinity Propagation");
        this.affinityMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.affinityMenuItemActionPerformed(evt);
            }
        });
        this.clusteringMenu.add(this.affinityMenuItem);
        this.mclMenuItem.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.mclMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Flag-Yellow.gif")));
        this.mclMenuItem.setText("Markov Clustering");
        this.mclMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.mclMenuItemActionPerformed(evt);
            }
        });
        this.clusteringMenu.add(this.mclMenuItem);
        this.jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.jMenuItem2.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Flag-Green.gif")));
        this.jMenuItem2.setText("Predefined Clustering");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.clusteringMenu.add(this.jMenuItem2);
        this.jMenuBar1.add(this.clusteringMenu);
        this.zoomMenu.setText("Zoom");
        this.jMenuItem1.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Blue/Zoom_In.gif")));
        this.zoomMenu.add(this.jMenuItem1);
        this.jMenuBar1.add(this.zoomMenu);
        this.selectMenu.setText("Select");
        this.selectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        this.selectAllMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Doc-Ok.gif")));
        this.selectAllMenuItem.setText("All");
        this.selectAllMenuItem.setToolTipText("Select all nodes");
        this.selectAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.selectAllMenuItemActionPerformed(evt);
            }
        });
        this.selectMenu.add(this.selectAllMenuItem);
        this.selectNoneMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 8));
        this.selectNoneMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Doc-Error.gif")));
        this.selectNoneMenuItem.setText("None");
        this.selectNoneMenuItem.setToolTipText("Clear selection");
        this.selectNoneMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.selectNoneMenuItemActionPerformed(evt);
            }
        });
        this.selectMenu.add(this.selectNoneMenuItem);
        this.selectNodeLabelByRegExpMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 8));
        this.selectNodeLabelByRegExpMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Search.gif")));
        this.selectNodeLabelByRegExpMenuItem.setText("By label");
        this.selectNodeLabelByRegExpMenuItem.setToolTipText("Select nodes by label using regular expressions.");
        this.selectNodeLabelByRegExpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.selectNodeLabelByRegExpMenuItemActionPerformed(evt);
            }
        });
        this.selectMenu.add(this.selectNodeLabelByRegExpMenuItem);
        this.selectNodeAnnotationByRegExpMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 8));
        this.selectNodeAnnotationByRegExpMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Blue/Search.gif")));
        this.selectNodeAnnotationByRegExpMenuItem.setText("By annotation");
        this.selectNodeAnnotationByRegExpMenuItem.setToolTipText("Select nodes by annotation using regular expressions.");
        this.selectNodeAnnotationByRegExpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.selectNodeAnnotationByRegExpMenuItemActionPerformed(evt);
            }
        });
        this.selectMenu.add(this.selectNodeAnnotationByRegExpMenuItem);
        this.selectNodeFromFileMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Green/Folder Open.gif")));
        this.selectNodeFromFileMenuItem.setText("From file");
        this.selectNodeFromFileMenuItem.setToolTipText("Select nodes from a file of node labels.");
        this.selectNodeFromFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.selectNodeFromFileMenuItemActionPerformed(evt);
            }
        });
        this.selectMenu.add(this.selectNodeFromFileMenuItem);
        this.invertFixMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Orange/Char - Tilde.gif")));
        this.invertFixMenuItem.setText("Invert");
        this.invertFixMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.invertFixMenuItemActionPerformed(evt);
            }
        });
        this.selectMenu.add(this.invertFixMenuItem);
        this.selectGrowMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/16x16/Direction Diag1.gif")));
        this.selectGrowMenuItem.setText("Grow selection");
        this.selectGrowMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.selectGrowMenuItemActionPerformed(evt);
            }
        });
        this.selectMenu.add(this.selectGrowMenuItem);
        this.jMenuBar1.add(this.selectMenu);
        this.optionMenu.setText("Options");
        this.jMenuItem3.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Chart2.gif")));
        this.jMenuItem3.setText("Network characteristics");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.optionMenu.add(this.jMenuItem3);
        this.changeNodeSizeMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/16x16/Directions.gif")));
        this.changeNodeSizeMenuItem.setText("Change node size");
        this.changeNodeSizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.changeNodeSizeMenuItemActionPerformed(evt);
            }
        });
        this.optionMenu.add(this.changeNodeSizeMenuItem);
        this.setEdgeLenMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/16x16/Size Horz.gif")));
        this.setEdgeLenMenuItem.setText("Edge length");
        this.setEdgeLenMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.setEdgeLenMenuItemActionPerformed(evt);
            }
        });
        this.optionMenu.add(this.setEdgeLenMenuItem);
        this.optionMenu.add(this.jSeparator2);
        this.colorMenu.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Chart1-Edit.gif")));
        this.colorMenu.setText("Color");
        this.colorMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.colorMenuActionPerformed(evt);
            }
        });
        this.changeColorMenuItem.setText("Change node color");
        this.changeColorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.changeColorMenuItemActionPerformed(evt);
            }
        });
        this.colorMenu.add(this.changeColorMenuItem);
        this.switchColorMenuItem.setText("Switch channels");
        this.switchColorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.switchColorMenuItemActionPerformed(evt);
            }
        });
        this.colorMenu.add(this.switchColorMenuItem);
        this.copyColorMenuItem.setText("Copy channels");
        this.copyColorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.copyColorMenuItemActionPerformed(evt);
            }
        });
        this.colorMenu.add(this.copyColorMenuItem);
        this.colorMenu.add(this.jSeparator4);
        this.setBasicEdgeColorMenuItem.setText("Base color");
        this.setBasicEdgeColorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.setBasicEdgeColorMenuItemActionPerformed(evt);
            }
        });
        this.colorMenu.add(this.setBasicEdgeColorMenuItem);
        this.setBackgroundColorMenuItem.setText("Background");
        this.setBackgroundColorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.setBackgroundColorMenuItemActionPerformed(evt);
            }
        });
        this.colorMenu.add(this.setBackgroundColorMenuItem);
        this.optionMenu.add(this.colorMenu);
        this.fontMenu.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Orange/Text2.gif")));
        this.fontMenu.setText("Font");
        this.setLabelColorMenuItem.setText("Label");
        this.setLabelColorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.setLabelColorMenuItemActionPerformed(evt);
            }
        });
        this.fontMenu.add(this.setLabelColorMenuItem);
        this.changeFontSizeMenuItem.setText("Font size");
        this.changeFontSizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.changeFontSizeMenuItemActionPerformed(evt);
            }
        });
        this.fontMenu.add(this.changeFontSizeMenuItem);
        this.optionMenu.add(this.fontMenu);
        this.optionMenu.add(this.jSeparator3);
        this.imageMenu.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Image.gif")));
        this.imageMenu.setText("Image");
        this.loadImageMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Image-Add.gif")));
        this.loadImageMenuItem.setText("Load");
        this.loadImageMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.loadImageMenuItemActionPerformed(evt);
            }
        });
        this.imageMenu.add(this.loadImageMenuItem);
        this.clearImageMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Image-Del.gif")));
        this.clearImageMenuItem.setText("Clear");
        this.clearImageMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.clearImageMenuItemActionPerformed(evt);
            }
        });
        this.imageMenu.add(this.clearImageMenuItem);
        this.optionMenu.add(this.imageMenu);
        this.jMenuBar1.add(this.optionMenu);
        this.manipulateMenu.setText("Manipulate");
        this.clearGraphMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Green/Nuke.gif")));
        this.clearGraphMenuItem.setText("Clear graph");
        this.clearGraphMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.clearGraphMenuItemActionPerformed(evt);
            }
        });
        this.manipulateMenu.add(this.clearGraphMenuItem);
        this.changeNodeShapeMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Blue/Player Play.gif")));
        this.changeNodeShapeMenuItem.setText("Change node shape");
        this.changeNodeShapeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.changeNodeShapeMenuItemActionPerformed(evt);
            }
        });
        this.manipulateMenu.add(this.changeNodeShapeMenuItem);
        this.deleteNodeMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Delete.gif")));
        this.deleteNodeMenuItem.setText("Delete Nodes");
        this.deleteNodeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.deleteNodeMenuItemActionPerformed(evt);
            }
        });
        this.manipulateMenu.add(this.deleteNodeMenuItem);
        this.cropMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Cut.gif")));
        this.cropMenuItem.setText("Crop graph");
        this.cropMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.cropMenuItemActionPerformed(evt);
            }
        });
        this.manipulateMenu.add(this.cropMenuItem);
        this.randomGraphMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Blue/Under Construction.gif")));
        this.randomGraphMenuItem.setText("Random graph");
        this.randomGraphMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.randomGraphMenuItemActionPerformed(evt);
            }
        });
        this.manipulateMenu.add(this.randomGraphMenuItem);
        this.rotateMenu.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Orange/Rotate.gif")));
        this.rotateMenu.setText("Rotate");
        this.rotateRightMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Green/Action Redo.gif")));
        this.rotateRightMenuItem.setText("90d clockwise");
        this.rotateRightMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.rotateRightMenuItemActionPerformed(evt);
            }
        });
        this.rotateMenu.add(this.rotateRightMenuItem);
        this.rotateLeftMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Green/Action Undo.gif")));
        this.rotateLeftMenuItem.setText("90d anti-clockwise");
        this.rotateLeftMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.rotateLeftMenuItemActionPerformed(evt);
            }
        });
        this.rotateMenu.add(this.rotateLeftMenuItem);
        this.manipulateMenu.add(this.rotateMenu);
        this.flipMenu.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Orange/Refresh.gif")));
        this.flipMenu.setText("Flip");
        this.flipXItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Blue/Back Top.gif")));
        this.flipXItem.setText("Vertical");
        this.flipMenu.add(this.flipXItem);
        this.flipYItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Blue/Back.gif")));
        this.flipYItem.setText("Horizontal");
        this.flipMenu.add(this.flipYItem);
        this.manipulateMenu.add(this.flipMenu);
        this.alignNodesMenu.setText("Align nodes");
        this.alignTop.setText("Horizontally based on top node");
        this.alignTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.alignTopActionPerformed(evt);
            }
        });
        this.alignNodesMenu.add(this.alignTop);
        this.alignBottom.setText("Horizontally based on bottom node");
        this.alignBottom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.alignBottomActionPerformed(evt);
            }
        });
        this.alignNodesMenu.add(this.alignBottom);
        this.alignLeft.setText("Vertically based on left-most node");
        this.alignLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.alignLeftActionPerformed(evt);
            }
        });
        this.alignNodesMenu.add(this.alignLeft);
        this.alignRight.setText("Vertically based on right-most node");
        this.alignRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.alignRightActionPerformed(evt);
            }
        });
        this.alignNodesMenu.add(this.alignRight);
        this.manipulateMenu.add(this.alignNodesMenu);
        this.manipulateMenu.add(this.jSeparator5);
        this.editGraphMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Doc-Edit.gif")));
        this.editGraphMenuItem.setText("Edit graph");
        this.editGraphMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.editGraphMenuItemActionPerformed(evt);
            }
        });
        this.manipulateMenu.add(this.editGraphMenuItem);
        this.recalcButton.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Blue/Calc.gif")));
        this.recalcButton.setText("Recalculate");
        this.recalcButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.recalcButtonActionPerformed(evt);
            }
        });
        this.manipulateMenu.add(this.recalcButton);
        this.jMenuBar1.add(this.manipulateMenu);
        interactionMenu.setText("Interaction");
        this.loadInteractionMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/News-Add.gif")));
        this.loadInteractionMenuItem.setText("Load");
        this.loadInteractionMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.loadInteractionMenuItemActionPerformed(evt);
            }
        });
        interactionMenu.add(this.loadInteractionMenuItem);
        interactionMenu.add(this.jSeparator6);
        jMenuItem4.setText("Multi-edged connections");
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.jMenuItem4ActionPerformed(evt);
            }
        });
        interactionMenu.add(jMenuItem4);
        interactionMenu.add(this.jSeparator11);
        this.stringCOGInteractionMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Datbase-Lock.gif")));
        this.stringCOGInteractionMenuItem.setText("String default");
        this.stringProteinInteractionMenuItem.setText("Protein");
        this.stringProteinInteractionMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.stringProteinInteractionMenuItemActionPerformed(evt);
            }
        });
        this.stringCOGInteractionMenuItem.add(this.stringProteinInteractionMenuItem);
        this.jMenuItem50.setText("COGS");
        this.jMenuItem50.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.jMenuItem50ActionPerformed(evt);
            }
        });
        this.stringCOGInteractionMenuItem.add(this.jMenuItem50);
        interactionMenu.add(this.stringCOGInteractionMenuItem);
        this.jMenuBar1.add(interactionMenu);
        this.displayMenu.setText("Display");
        this.prettyCBMItem.setAccelerator(KeyStroke.getKeyStroke(73, 8));
        this.prettyCBMItem.setText("Interactions");
        this.prettyCBMItem.setToolTipText("<html>\nIf enabled, interactions will be presented as<br/>\ncurves and colors. If disabled, simple straight<br/>\nedges will be used.\n</html>");
        this.prettyCBMItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MedusaSimplerFrame.this.prettyCBMItemItemStateChanged(evt);
            }
        });
        this.prettyCBMItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.prettyCBMItemActionPerformed(evt);
            }
        });
        this.displayMenu.add(this.prettyCBMItem);
        this.namesCBMItem.setSelected(true);
        this.namesCBMItem.setText("Labels");
        this.namesCBMItem.setToolTipText("Check this to display node labels or annotations");
        this.namesCBMItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MedusaSimplerFrame.this.namesCBMItemItemStateChanged(evt);
            }
        });
        this.displayMenu.add(this.namesCBMItem);
        this.showNamesCBMItem.setSelected(true);
        this.showNamesCBMItem.setText("Show names");
        this.showNamesCBMItem.setToolTipText("If checked, the node label will be displayed. Otherwise, the node annotation will be shown.");
        this.showNamesCBMItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MedusaSimplerFrame.this.showNamesCBMItemItemStateChanged(evt);
            }
        });
        this.displayMenu.add(this.showNamesCBMItem);
        this.directedCBMItem.setText("Directed");
        this.directedCBMItem.setToolTipText("Check this to diplay arrows, signifying a directionality of an edge.");
        this.directedCBMItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MedusaSimplerFrame.this.directedCBMItemItemStateChanged(evt);
            }
        });
        this.displayMenu.add(this.directedCBMItem);
        this.confidenceCBMItem.setSelected(true);
        this.confidenceCBMItem.setText("Confidence");
        this.confidenceCBMItem.setToolTipText("Display confidence or draw all edges as solid lines.");
        this.confidenceCBMItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MedusaSimplerFrame.this.confidenceCBMItemItemStateChanged(evt);
            }
        });
        this.displayMenu.add(this.confidenceCBMItem);
        this.alphaCBMItem.setSelected(true);
        this.alphaCBMItem.setText("Show alpha");
        this.alphaCBMItem.setToolTipText("Check this to show confidences as alpha opacity. Uncheck to display as dashed lines.");
        this.alphaCBMItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MedusaSimplerFrame.this.alphaCBMItemItemStateChanged(evt);
            }
        });
        this.displayMenu.add(this.alphaCBMItem);
        this.displayMenu.add(this.jSeparator7);
        this.hideWhenMoveCBMItem.setSelected(true);
        this.hideWhenMoveCBMItem.setText("Hide edges on move");
        this.hideWhenMoveCBMItem.setToolTipText("Check to hide all other edges when moving a node. Very useful for large graphs.");
        this.hideWhenMoveCBMItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MedusaSimplerFrame.this.hideWhenMoveCBMItemItemStateChanged(evt);
            }
        });
        this.displayMenu.add(this.hideWhenMoveCBMItem);
        this.displayMenu.add(this.jSeparator8);
        this.nodeColorDisplayMenu.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Chart1.gif")));
        this.nodeColorDisplayMenu.setText("Node color set");
        ButtonGroup nodeColorSetGroup = new ButtonGroup();
        nodeColorSetGroup.add(channel1MenuItem);
        nodeColorSetGroup.add(channel2MenuItem);
        nodeColorSetGroup.add(channel3MenuItem);
        nodeColorSetGroup.add(jRadioButtonMenuItem1);
        channel1MenuItem.setAccelerator(KeyStroke.getKeyStroke(49, 2));
        channel1MenuItem.setSelected(true);
        channel1MenuItem.setText("1");
        channel1MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.channel1MenuItemActionPerformed(evt);
            }
        });
        this.nodeColorDisplayMenu.add(channel1MenuItem);
        channel2MenuItem.setAccelerator(KeyStroke.getKeyStroke(50, 2));
        channel2MenuItem.setText("2");
        channel2MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.channel2MenuItemActionPerformed(evt);
            }
        });
        this.nodeColorDisplayMenu.add(channel2MenuItem);
        channel3MenuItem.setAccelerator(KeyStroke.getKeyStroke(51, 2));
        channel3MenuItem.setText("3");
        channel3MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.channel3MenuItemActionPerformed(evt);
            }
        });
        this.nodeColorDisplayMenu.add(channel3MenuItem);
        jRadioButtonMenuItem1.setAccelerator(KeyStroke.getKeyStroke(52, 2));
        jRadioButtonMenuItem1.setText("Clustering Color");
        jRadioButtonMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.jRadioButtonMenuItem1ActionPerformed(evt);
            }
        });
        this.nodeColorDisplayMenu.add(jRadioButtonMenuItem1);
        this.displayMenu.add(this.nodeColorDisplayMenu);
        this.jMenuBar1.add(this.displayMenu);
        this.helpMenu.setText("Help");
        this.aboutMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/medusa/images/Info.gif")));
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MedusaSimplerFrame.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.jMenuBar1.add(this.helpMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        this.loadEvent(0);
        this.hide_starting_background();
    }

    private void addMenuItemActionPerformed(ActionEvent evt) {
        this.addGraphEvent();
        this.hide_starting_background();
    }

    private void subtractMenuItemActionPerformed(ActionEvent evt) {
        this.subtractGraphEvent();
    }

    private void copyMenuItemActionPerformed(ActionEvent evt) {
        this.copyGraphEvent();
    }

    private void importTabbedMenuItemActionPerformed(ActionEvent evt) {
        this.copyGraphEvent();
        this.hide_starting_background();
    }

    private void saveMenuItemActionPerformed(ActionEvent evt) {
        this.saveEvent();
    }

    private void exportJPGMenuItemActionPerformed(ActionEvent evt) {
        this.exportImageEvent(false);
    }

    private void exportPNGMenuItemActionPerformed(ActionEvent evt) {
        this.exportImageEvent(true);
    }

    private void exportPajekMenuItemActionPerformed(ActionEvent evt) {
        this.exportPajekEvent();
    }

    private void saveHTMLParametersMenuItemActionPerformed(ActionEvent evt) {
        this.saveHTMLParametersEvent();
    }

    private void quitMenuItemActionPerformed(ActionEvent evt) {
        this.quitApplication();
    }

    private void randomMenuItemActionPerformed(ActionEvent evt) {
        System.out.println("RANDOM");
        this.stopRelax();
        Graph g = stringletPanel.getGraph();
        Layouts.Apply_Random_Coordinates(g, stringletPanel);
        this.updateInfo();
        stringletPanel.repaint();
    }

    private void circularMenuItemActionPerformed(ActionEvent evt) {
        System.out.println("CIRCULAR");
        this.stopRelax();
        Graph g = stringletPanel.getGraph();
        Layouts.Apply_Circular_Coordinates(g, stringletPanel);
        this.updateInfo();
        stringletPanel.repaint();
    }

    private void gridMenuItemActionPerformed(ActionEvent evt) {
        System.out.println("GRID");
        this.stopRelax();
        Graph g = stringletPanel.getGraph();
        Layouts.Apply_Grid_Coordinates(g, stringletPanel);
        this.updateInfo();
        stringletPanel.repaint();
    }

    private void fruchtermanMenuItemActionPerformed(ActionEvent evt) {
        Graph g = stringletPanel.getGraph();
        if (g.getNodeSize() > 1) {
            System.out.println("FRUCHTERMAN");
            this.stopRelax();
            stringletPanel.energy();
            this.updateInfo();
            stringletPanel.repaint();
        }
    }

    private void hierarchicalMenuItemActionPerformed(ActionEvent evt) {
        System.out.println("HIERARCHICAL");
        this.stopRelax();
        Graph g = stringletPanel.getGraph();
        Layouts.Apply_GO_like_Coordinates(g, stringletPanel);
        this.updateInfo();
        stringletPanel.repaint();
    }

    private void distanceGeometryMenuItemActionPerformed(ActionEvent evt) {
        System.out.println("DISTANCE GEOMETRY");
        this.stopRelax();
        Graph g = stringletPanel.getGraph();
        Layouts.Apply_Distance_Geomretry_Coordinates(g, stringletPanel);
        this.updateInfo();
        stringletPanel.repaint();
    }

    private void kmeansMenuItemActionPerformed(ActionEvent evt) {
        this.stopRelax();
        System.out.println("K-Means");
        Graph g = stringletPanel.getGraph();
        Layouts.Apply_Kmeans_Clustering(g, stringletPanel);
        this.updateInfo();
        stringletPanel.repaint();
    }

    private void affinityMenuItemActionPerformed(ActionEvent evt) {
        this.stopRelax();
        System.out.println("AFFINITY");
        Graph g = stringletPanel.getGraph();
        Layouts.Apply_Affinity_Propagation_Clustering(g, stringletPanel);
        this.updateInfo();
        stringletPanel.repaint();
    }

    private void mclMenuItemActionPerformed(ActionEvent evt) {
        this.stopRelax();
        System.out.println("MCL");
        Graph g = stringletPanel.getGraph();
        Layouts.Apply_MCL_Propagation_Clustering(g, stringletPanel);
        this.updateInfo();
        stringletPanel.repaint();
    }

    private void selectAllMenuItemActionPerformed(ActionEvent evt) {
        stringletPanel.setFix(true);
    }

    private void selectNoneMenuItemActionPerformed(ActionEvent evt) {
        stringletPanel.setFix(false);
    }

    private void selectNodeLabelByRegExpMenuItemActionPerformed(ActionEvent evt) {
        this.searchNodeEvent(true);
    }

    private void selectNodeAnnotationByRegExpMenuItemActionPerformed(ActionEvent evt) {
        this.searchNodeEvent(false);
    }

    private void selectNodeFromFileMenuItemActionPerformed(ActionEvent evt) {
        this.selectNodeFromFileEvent();
    }

    private void invertFixMenuItemActionPerformed(ActionEvent evt) {
        stringletPanel.invertFix();
    }

    private void selectGrowMenuItemActionPerformed(ActionEvent evt) {
        stringletPanel.growSelection();
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        String aboutText = "<html><center><h2>Medusa 1.5</h2><br><center>Authors:<br>Sean Hooper<br>Georgios Pavlopoulos<p><p>EMBL Heidelberg 2008</center><p><center><b>hooper@embl.de<br>pavlopou@embl.de<br></b><br>Full documentation at<p>www.bork.embl.de/medusa</center></html>";
        JOptionPane.showMessageDialog(this, aboutText);
    }

    private void changeNodeSizeMenuItemActionPerformed(ActionEvent evt) {
        this.changeNodeSizeEvent();
    }

    private void setEdgeLenMenuItemActionPerformed(ActionEvent evt) {
        this.setEdgeLenEvent();
    }

    private void changeColorMenuItemActionPerformed(ActionEvent evt) {
        this.changeColorEvent();
    }

    private void switchColorMenuItemActionPerformed(ActionEvent evt) {
        this.switchColorEvent();
    }

    private void copyColorMenuItemActionPerformed(ActionEvent evt) {
        this.copyColorEvent();
    }

    private void setBasicEdgeColorMenuItemActionPerformed(ActionEvent evt) {
        this.setBasicEdgeColorEvent();
    }

    private void setBackgroundColorMenuItemActionPerformed(ActionEvent evt) {
        this.setBackgroundColorEvent();
    }

    private void setLabelColorMenuItemActionPerformed(ActionEvent evt) {
        this.setLabelColorEvent();
    }

    private void changeFontSizeMenuItemActionPerformed(ActionEvent evt) {
        this.changeFontSizeEvent();
    }

    private void loadImageMenuItemActionPerformed(ActionEvent evt) {
        this.loadImageEvent();
        this.hide_starting_background();
    }

    private void clearImageMenuItemActionPerformed(ActionEvent evt) {
        this.clearImageEvent();
    }

    private void colorMenuActionPerformed(ActionEvent evt) {
    }

    private void clearGraphMenuItemActionPerformed(ActionEvent evt) {
        this.clearGraphEvent();
        this.startinglabel.setVisible(true);
        stringletPanel.repaint();
    }

    private void changeNodeShapeMenuItemActionPerformed(ActionEvent evt) {
        this.setShapeEvent();
    }

    private void deleteNodeMenuItemActionPerformed(ActionEvent evt) {
        this.stopRelax();
        stringletPanel.removeFixedNodes();
        this.updateInfo();
        stringletPanel.repaint();
    }

    private void cropMenuItemActionPerformed(ActionEvent evt) {
        String confidence = JOptionPane.showInputDialog("Choose minimum confidence level:", (Object)"1.0");
        if (confidence != null) {
            stringletPanel.crop(Double.parseDouble(confidence));
            this.updateInfo();
            stringletPanel.repaint();
        }
    }

    private void randomGraphMenuItemActionPerformed(ActionEvent evt) {
        this.getRandomGraphEvent();
        this.hide_starting_background();
    }

    private void rotateRightMenuItemActionPerformed(ActionEvent evt) {
        this.rotateEvent(1.5707963267948966);
    }

    private void rotateLeftMenuItemActionPerformed(ActionEvent evt) {
        this.rotateEvent(-1.5707963267948966);
    }

    private void editGraphMenuItemActionPerformed(ActionEvent evt) {
        this.editGraph();
    }

    private void loadInteractionMenuItemActionPerformed(ActionEvent evt) {
        this.interactionEvent();
    }

    private void stringProteinInteractionMenuItemActionPerformed(ActionEvent evt) {
        this.proteinInteractionEvent();
    }

    private void jMenuItem50ActionPerformed(ActionEvent evt) {
        this.cogInteractionEvent();
    }

    private void prettyCBMItemItemStateChanged(ItemEvent evt) {
        stringletPanel.setPretty(this.prettyCBMItem.isSelected());
        stringletPanel.repaint();
        this.validate();
    }

    private void hideShowInteractionsEvent() {
        Container content = this.getContentPane();
        this.hideInteractions = !this.hideInteractions;
        this.validate();
    }

    private void namesCBMItemItemStateChanged(ItemEvent evt) {
        stringletPanel.setLabel(this.namesCBMItem.isSelected());
        stringletPanel.repaint();
    }

    private void showNamesCBMItemItemStateChanged(ItemEvent evt) {
        stringletPanel.setShowName(this.showNamesCBMItem.isSelected());
        stringletPanel.repaint();
    }

    private void confidenceCBMItemItemStateChanged(ItemEvent evt) {
        stringletPanel.setConfidence(this.confidenceCBMItem.isSelected());
        stringletPanel.repaint();
    }

    private void directedCBMItemItemStateChanged(ItemEvent evt) {
        stringletPanel.setArrows(this.directedCBMItem.isSelected());
        stringletPanel.repaint();
    }

    private void hideWhenMoveCBMItemItemStateChanged(ItemEvent evt) {
        stringletPanel.setHideWhenMove(this.hideWhenMoveCBMItem.isSelected());
        stringletPanel.repaint();
    }

    private void alphaCBMItemItemStateChanged(ItemEvent evt) {
        stringletPanel.setAlpha(this.alphaCBMItem.isSelected());
        stringletPanel.repaint();
    }

    private void channel1MenuItemActionPerformed(ActionEvent evt) {
        MedusaSimplerFrame.setNodeColorSet(1);
    }

    private void channel2MenuItemActionPerformed(ActionEvent evt) {
        MedusaSimplerFrame.setNodeColorSet(2);
    }

    private void channel3MenuItemActionPerformed(ActionEvent evt) {
        MedusaSimplerFrame.setNodeColorSet(3);
    }

    private void recalcButtonActionPerformed(ActionEvent evt) {
        this.recalcEvent();
    }

    private void stringButtonActionPerformed(ActionEvent evt) {
        this.stringConnection();
    }

    private void startRelaxMenuItemActionPerformed(ActionEvent evt) {
        stringletPanel.start();
    }

    private void stopRelaxMenuItemActionPerformed(ActionEvent evt) {
        stringletPanel.stop();
    }

    private void temperatureButtonItemStateChanged(ItemEvent evt) {
        stringletPanel.setCool(this.temperatureButton.isSelected());
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        String[] result = stringletPanel.getGraphData();
        String planar = "Graph is " + (stringletPanel.getGraph().isPlanar() ? "" : "not ") + "planar";
        String display = "<html><b>nodes: " + result[0] + "<br>edges: " + result[1] + "<br>File: " + this.lastFile + "</b></html>";
        JOptionPane.showMessageDialog(null, display);
    }

    private void jMenuItem4ActionPerformed(ActionEvent evt) {
    }

    private void exportEPSMenuItemActionPerformed(ActionEvent evt) {
        this.exportEPSEvent();
    }

    private void exportPSMenuItemActionPerformed(ActionEvent evt) {
        this.exportPSEvent();
    }

    private void jRadioButtonMenuItem1ActionPerformed(ActionEvent evt) {
        MedusaSimplerFrame.setNodeColorSet(4);
    }

    private void formKeyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == 'r') {
            if (MedusaSimplerFrame.stringletPanel.running) {
                stringletPanel.stop();
            } else {
                stringletPanel.start();
            }
        }
    }

    private void prettyCBMItemActionPerformed(ActionEvent evt) {
    }

    private void addSubractMenuActionPerformed(ActionEvent evt) {
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        this.stopRelax();
        System.out.println("Predefined");
        Graph g = stringletPanel.getGraph();
        Layouts.Apply_Predefined_Clustering(g, stringletPanel);
        this.updateInfo();
        stringletPanel.repaint();
    }

    private void jMenuItem5ActionPerformed(ActionEvent evt) {
        this.exportArena3DEvent();
    }

    private void jMenuItem6ActionPerformed(ActionEvent evt) {
        this.exportBiolayoutEvent();
    }

    private void jMenuItem7ActionPerformed(ActionEvent evt) {
        this.exportCytoscapeEvent();
    }

    private void jMenuItem8ActionPerformed(ActionEvent evt) {
        this.exportGraphVizEvent();
    }

    private void alignTopActionPerformed(ActionEvent evt) {
        this.alignNodes(EditableGraphPanel.EXTREME_TOP);
    }

    private void alignBottomActionPerformed(ActionEvent evt) {
        this.alignNodes(EditableGraphPanel.EXTREME_BOTTOM);
    }

    private void alignLeftActionPerformed(ActionEvent evt) {
        this.alignNodes(EditableGraphPanel.EXTREME_LEFT);
    }

    private void alignRightActionPerformed(ActionEvent evt) {
        this.alignNodes(EditableGraphPanel.EXTREME_RIGHT);
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MedusaSimplerFrame frame = new MedusaSimplerFrame();
                try {
                    frame.checkArgs(args);
                }
                catch (DataFormatException ex) {
                    System.out.println("Data format error! Check your data and make sure it is in the correct format");
                    ex.printStackTrace();
                    System.exit(0);
                }
                catch (IOException ex) {
                    System.out.println("File error! Check the integrity of your file. You may need to provide the full path to the file");
                    ex.printStackTrace();
                    System.exit(0);
                }
                frame.setVisible(true);
            }
        });
    }

    public void checkArgs(String[] args) throws IOException, DataFormatException {
        System.out.println("Checking arguments");
        int ln = args.length;
        if (ln == 0) {
            System.out.println("No arguments. Proceeding normally");
            return;
        }
        if (ln == 2) {
            this.checkArgPair(args);
            return;
        }
        if (ln == 4) {
            this.checkArgPair(new String[]{args[0], args[1]});
            this.checkArgPair(new String[]{args[2], args[3]});
            return;
        }
    }

    private void checkArgPair(String[] args) throws IOException, DataFormatException {
        if (args[0].compareTo("f") == 0) {
            this.waitForLoad(args[1], 0);
            this.hide_starting_background();
        }
        if (args[0].compareTo("i") == 0) {
            this.stringSettings.load(args[1]);
        }
        if (args[0].compareTo("t") == 0) {
            this.waitForLoad(args[1], 1);
            this.hide_starting_background();
        }
    }

    static {
        darkBackground = new Color(0.33f, 0.0f, 0.0f);
        foreground = new Color(0.0f, 0.0f, 0.0f);
        oldScale = 1.0;
        scale = 1.0;
        STRINGCOLOR = new Color(161, 173, 236);
    }
}

