/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.util;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jplot2d.javacc.ParseException;
import org.jplot2d.javacc.SymbolShapeParser;
import org.jplot2d.javacc.TokenMgrError;

public class SymbolShape {
    private static final Map<String, SymbolShape> _symbolMap = new LinkedHashMap<String, SymbolShape>();
    private static final ThreadLocal<SymbolShapeParser> parserTL = new ThreadLocal<SymbolShapeParser>(){

        @Override
        protected SymbolShapeParser initialValue() {
            return new SymbolShapeParser(new StringReader(""));
        }
    };
    public static final SymbolShape VCROSS = SymbolShape.createSymbolShape("VCROSS", "{L(-0.5,0)(0.5,0) L(0,-0.5)(0,0.5)}");
    public static final SymbolShape DCROSS = SymbolShape.createSymbolShape("DCROSS", "{L(-0.707,-0.707)(0.707,0.707) L(-0.707,0.707)(0.707,-0.707)}");
    public static final SymbolShape VDCROSS = SymbolShape.createSymbolShape("VDCROSS", "{L(-0.5,0)(0.5,0) L(0,-0.5)(0,0.5) L(-0.707,-0.707)(0.707,0.707) L(-0.707,0.707)(0.707,-0.707)}");
    public static final SymbolShape CIRCLE = SymbolShape.createSymbolShape("CIRCLE", "{C(0,0,0.5)}");
    public static final SymbolShape FCIRCLE = SymbolShape.createSymbolShape("FCIRCLE", "{FC(0,0,0.5)}");
    public static final SymbolShape TRIANGLE = SymbolShape.createSymbolShape("TRIANGLE", "{P(-0.433,-0.25)(0.433,-0.25)(0,0.5)}");
    public static final SymbolShape FTRIANGLE = SymbolShape.createSymbolShape("FTRIANGLE", "{FP(-0.433,-0.25)(0.433,-0.25)(0,0.5)}");
    public static final SymbolShape UTRIANGLE = SymbolShape.createSymbolShape("UTRIANGLE", "{P(-0.433,0.25)(0.433,0.25)(0,-0.5)}");
    public static final SymbolShape SQUARE = SymbolShape.createSymbolShape("SQUARE", "{R(-0.354,-0.354)(0.354,0.354)}");
    public static final SymbolShape FSQUARE = SymbolShape.createSymbolShape("FSQUARE", "{FR(-0.354,-0.354)(0.354,0.354)}");
    public static final SymbolShape SQUARE_CROSS = SymbolShape.createSymbolShape("SQUARE_CROSS", "{R(-0.354,-0.354)(0.354,0.354) L(-0.354,-0.354)(0.354,0.354) L(-0.354,0.354)(0.354,-0.354)}");
    public static final SymbolShape DIAMOND = SymbolShape.createSymbolShape("DIAMOND", "{P(-0.5,0)(0,-0.5)(0.5,0)(0,0.5)}");
    public static final SymbolShape FDIAMOND = SymbolShape.createSymbolShape("FDIAMOND", "{FP(-0.5,0)(0,-0.5)(0.5,0)(0,0.5)}");
    public static final SymbolShape DIAMOND_CROSS = SymbolShape.createSymbolShape("DIAMOND_CROSS", "{P(-0.5,0)(0,-0.5)(0.5,0)(0,0.5) L(-0.5,0)(0.5,0) L(0,-0.5)(0,0.5)}");
    public static final SymbolShape OCTAGON = SymbolShape.createSymbolShape("OCTAGON", "{P(-0.4619,-0.1913)(-0.1913,-0.4619)(0.1913,-0.4619)(0.4619,-0.1913)(0.4619,0.1913)(0.1913,0.4619)(-0.1913,0.4619)(-0.4619,0.1913)}");
    public static final SymbolShape FOCTAGON = SymbolShape.createSymbolShape("FOCTAGON", "{FP(-0.4619,-0.1913)(-0.1913,-0.4619)(0.1913,-0.4619)(0.4619,-0.1913)(0.4619,0.1913)(0.1913,0.4619)(-0.1913,0.4619)(-0.4619,0.1913)}");
    public static final SymbolShape STAR = SymbolShape.createSymbolShape("STAR", "{P(-0.4755,0.1545)(0.4755,0.1545)(-0.2939,-0.4045)(0,0.5)(0.2939,-0.4045)}");
    public static final SymbolShape UARROW = SymbolShape.createSymbolShape("UARROW", "{L(0,-0.5)(0,0) L(0,0)(-0.25,-0.25) L(0,0)(0.25,-0.25)}");
    public static final SymbolShape DARROW = SymbolShape.createSymbolShape("DARROW", "{L(0,0.5)(0,0) L(0,0)(-0.25,0.25) L(0,0)(0.25,0.25)}");
    public static final SymbolShape RARROW = SymbolShape.createSymbolShape("RARROW", "{L(-0.5,0)(0,0) L(0,0)(-0.25,0.25) L(0,0)(-0.25,-0.25)}");
    public static final SymbolShape LARROW = SymbolShape.createSymbolShape("LARROW", "{L(0.5,0)(0,0) L(0,0)(0.25,-0.25) L(0,0)(0.25,0.25)}");
    public static final SymbolShape UARROW_TAIL = SymbolShape.createSymbolShape("UARROW_TAIL", "{L(0,0)(0,0.5) L(0,0.5)(-0.25,0.25) L(0,0.5)(0.25,0.25)}");
    public static final SymbolShape DARROW_TAIL = SymbolShape.createSymbolShape("DARROW_TAIL", "{L(0,0)(0,-0.5) L(0,-0.5)(-0.25,-0.25) L(0,-0.5)(0.25,-0.25)}");
    public static final SymbolShape RARROW_TAIL = SymbolShape.createSymbolShape("RARROW_TAIL", "{L(0,0)(0.5,0) L(0.5,0)(0.25,0.25) L(0.5,0)(0.25,-0.25)}");
    public static final SymbolShape LARROW_TAIL = SymbolShape.createSymbolShape("LARROW_TAIL", "{L(0,0)(-0.5,0) L(-0.5,0)(-0.25,-0.25) L(-0.5,0)(-0.25,0.25)}");
    private String name;
    private String data;
    protected final List<Shape> drawShapeList = new ArrayList<Shape>();
    protected final List<Shape> fillShapeList = new ArrayList<Shape>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SymbolShape[] getSymbolShapes() {
        Map<String, SymbolShape> map = _symbolMap;
        synchronized (map) {
            return _symbolMap.values().toArray(new SymbolShape[_symbolMap.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SymbolShape createSymbolShape(String name, String data) {
        SymbolShape ss = new SymbolShape(name, data);
        Map<String, SymbolShape> map = _symbolMap;
        synchronized (map) {
            _symbolMap.put(name, ss);
        }
        return ss;
    }

    protected SymbolShape(String name, String data) {
        if (name.indexOf(123) != -1) {
            throw new IllegalArgumentException("The char '{' is not allowed in name.");
        }
        this.name = name;
        this.data = data;
        this.parseData(data);
    }

    public String getName() {
        return this.name;
    }

    public String getData() {
        return this.data;
    }

    public void draw(Graphics2D g, AffineTransform maf) {
        Iterator<Shape> dit = this.drawShapeList.iterator();
        while (dit.hasNext()) {
            Shape s = maf.createTransformedShape(dit.next());
            g.draw(s);
        }
        Iterator<Shape> fit = this.fillShapeList.iterator();
        while (fit.hasNext()) {
            Shape s = maf.createTransformedShape(fit.next());
            g.fill(s);
        }
    }

    protected void parseData(String data) {
        if (data == null || data.length() == 0) {
            throw new IllegalArgumentException("data cannot be null or empty");
        }
        SymbolShapeParser ssp = parserTL.get();
        try {
            ssp.parse(data);
            this.drawShapeList.addAll(ssp.getDrawShapeList());
            this.fillShapeList.addAll(ssp.getFillShapeList());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("the syntax of data is not correct", e);
        }
        catch (TokenMgrError e) {
            throw new IllegalArgumentException("the syntax of data is not correct", e);
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof SymbolShape && this.name == ((SymbolShape)obj).name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

