/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.util;

import java.util.Locale;

public class NumberUtils {
    private static final int SIGNIFICAND_WIDTH = 53;
    private static final int EXP_BIAS = 1023;
    private static final long SIGN_BIT_MASK = Long.MIN_VALUE;
    private static final long EXP_BIT_MASK = 0x7FF0000000000000L;
    private static final long SIGNIF_BIT_MASK = 0xFFFFFFFFFFFFFL;

    public static boolean approximate(double a, double b, int bit) {
        long mask;
        long delta;
        long lbb;
        if (a == b) {
            return true;
        }
        if (bit == 0) {
            return false;
        }
        long lba = Double.doubleToLongBits(a);
        if ((lba & Long.MIN_VALUE) != ((lbb = Double.doubleToLongBits(b)) & Long.MIN_VALUE)) {
            return false;
        }
        int expa = (int)(((lba & 0x7FF0000000000000L) >> 52) - 1023L);
        int expb = (int)(((lbb & 0x7FF0000000000000L) >> 52) - 1023L);
        if (expa - expb > 1 || expa - expb < -1) {
            return false;
        }
        long ma = lba & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        long mb = lbb & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        if (expa > expb) {
            ma <<= 1;
        }
        if (expa < expb) {
            mb <<= 1;
        }
        return ((delta = Math.abs(ma - mb)) & ((mask = (1L << bit) - 1L) ^ 0xFFFFFFFFFFFFFFFFL)) == 0L;
    }

    public static String calcFormatStr(double value, int digits) {
        int eidx;
        int ensi;
        if (value == 0.0 || Double.isNaN(value) || Double.isInfinite(value)) {
            return "%.0f";
        }
        int maxPrec = 0;
        int maxFractionDigits = 0;
        double v = Math.abs(value);
        String s = String.format((Locale)null, "%." + (digits - 1) + "e", v);
        if (s.charAt(ensi = (eidx = s.lastIndexOf(101)) + 1) == '+') {
            ++ensi;
        }
        int mag = Integer.parseInt(s.substring(ensi));
        int pp1 = -1;
        for (int i = eidx - 1; i >= 0; --i) {
            if (s.charAt(i) == '0') continue;
            pp1 = i;
            break;
        }
        if (maxPrec < pp1) {
            maxPrec = pp1;
        }
        if (maxFractionDigits < pp1 - mag - 1) {
            maxFractionDigits = pp1 - mag - 1;
        }
        int n0 = mag >= 0 ? mag - maxPrec + 1 : (mag <= 0 ? -mag : 0);
        String format = n0 < 4 && mag >= -4 && mag < 6 ? "%." + maxFractionDigits + "f" : "%." + (maxPrec - 1) + "e";
        return format;
    }

    public static String toString(float v) {
        return NumberUtils.toString(v, 6);
    }

    public static String toString(float v, int digits) {
        if (digits == 0) {
            digits = 6;
        }
        return String.format((Locale)null, NumberUtils.calcFormatStr(v, digits), Float.valueOf(v));
    }

    public static String toString(double v) {
        return NumberUtils.toString(v, 15);
    }

    public static String toString(double v, int digits) {
        if (digits == 0) {
            digits = 15;
        }
        return String.format((Locale)null, NumberUtils.calcFormatStr(v, digits), v);
    }

    public static String calcDeltaFormatStr(double v, double delta) {
        if (v == 0.0 || Double.isNaN(v) || Double.isInfinite(v)) {
            return "%.0f";
        }
        int deltaExp = (int)Math.floor(Math.log10(delta));
        int aExp = (int)Math.floor(Math.log10(Math.abs(v)));
        int precision = aExp - deltaExp;
        if (precision >= 0) {
            if (-4 <= aExp && aExp < 6) {
                if (deltaExp >= 0) {
                    return "%.0f";
                }
                return "%." + -deltaExp + "f";
            }
            return "%." + precision + "e";
        }
        if (-4 <= deltaExp && deltaExp < 0) {
            return "%." + -deltaExp + "f";
        }
        return "0";
    }
}

