/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.util;

public abstract class Insets2D {
    public abstract double getTop();

    public abstract double getLeft();

    public abstract double getBottom();

    public abstract double getRight();

    public static class Float
    extends Insets2D {
        public float top;
        public float left;
        public float bottom;
        public float right;

        public Float(float top, float left, float bottom, float right) {
            this.top = top;
            this.left = left;
            this.bottom = bottom;
            this.right = right;
        }

        @Override
        public double getTop() {
            return this.top;
        }

        @Override
        public double getLeft() {
            return this.left;
        }

        @Override
        public double getBottom() {
            return this.bottom;
        }

        @Override
        public double getRight() {
            return this.right;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Double) {
                Double insets = (Double)obj;
                return (double)this.top == insets.top && (double)this.left == insets.left && (double)this.bottom == insets.bottom && (double)this.right == insets.right;
            }
            return false;
        }

        public int hashCode() {
            int bits = java.lang.Float.floatToIntBits(this.top);
            bits += java.lang.Float.floatToIntBits(this.left) * 37;
            bits += java.lang.Float.floatToIntBits(this.bottom) * 43;
            return bits += java.lang.Float.floatToIntBits(this.right) * 47;
        }

        public String toString() {
            return this.getClass().getName() + "[top=" + this.top + ",left=" + this.left + ",bottom=" + this.bottom + ",right=" + this.right + "]";
        }
    }

    public static class Double
    extends Insets2D {
        private double left;
        private double right;
        private double top;
        private double bottom;

        public Double(double top, double left, double bottom, double right) {
            this.top = top;
            this.left = left;
            this.bottom = bottom;
            this.right = right;
        }

        @Override
        public double getTop() {
            return this.top;
        }

        @Override
        public double getLeft() {
            return this.left;
        }

        @Override
        public double getBottom() {
            return this.bottom;
        }

        @Override
        public double getRight() {
            return this.right;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Double) {
                Double insets = (Double)obj;
                return this.top == insets.top && this.left == insets.left && this.bottom == insets.bottom && this.right == insets.right;
            }
            return false;
        }

        public int hashCode() {
            long bits = java.lang.Double.doubleToLongBits(this.top);
            bits += java.lang.Double.doubleToLongBits(this.left) * 37L;
            bits += java.lang.Double.doubleToLongBits(this.bottom) * 43L;
            return (int)(bits += java.lang.Double.doubleToLongBits(this.right) * 47L) ^ (int)(bits >> 32);
        }

        public String toString() {
            return this.getClass().getName() + "[top=" + this.top + ",left=" + this.left + ",bottom=" + this.bottom + ",right=" + this.right + "]";
        }
    }
}

