/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.util;

public class FloatBottomNFinder {
    private float[] a;

    public FloatBottomNFinder(float[] array) {
        this.a = array;
        if (this.a.length == 0) {
            throw new IllegalArgumentException("The array cannot be empty");
        }
        this.heapify();
    }

    public void check(float v) {
        if (v < this.a[0]) {
            this.a[0] = v;
            this.siftDown(0);
        }
    }

    public float getMax() {
        return this.a[0];
    }

    public float getMax2nd() {
        if (this.a.length == 1) {
            return this.a[0];
        }
        if (this.a.length == 2) {
            return this.a[1];
        }
        return Math.max(this.a[1], this.a[2]);
    }

    private void heapify() {
        for (int i = (this.a.length - 2) / 2; i >= 0; --i) {
            this.siftDown(i);
        }
    }

    private void siftDown(int s) {
        int root = s;
        while (root * 2 < this.a.length - 1) {
            int l = 2 * root + 1;
            int r = l + 1;
            int swap = root;
            if (this.a[swap] < this.a[l]) {
                swap = l;
            }
            if (r < this.a.length && this.a[swap] < this.a[r]) {
                swap = r;
            }
            if (swap == root) break;
            this.swap(root, swap);
            root = swap;
        }
    }

    private void swap(int i, int j) {
        float t = this.a[i];
        this.a[i] = this.a[j];
        this.a[j] = t;
    }
}

