/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.tex;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class MathElement {
    public static final MathElement EMPTY = new MathElement(){

        @Override
        public String toMathML() {
            return "<mrow></mrow>";
        }

        @Override
        public void fillTeXString(TeXStringBuilder sb) {
            sb.append("{}");
        }
    };
    private String str;

    public abstract String toMathML();

    public abstract void fillTeXString(TeXStringBuilder var1);

    protected String toTeXString() {
        TeXStringBuilder sb = new TeXStringBuilder();
        this.fillTeXString(sb);
        if (sb.isMathMode()) {
            sb.append('$');
        }
        return sb.toString();
    }

    public String toString() {
        if (this.str == null) {
            this.str = this.toTeXString();
        }
        return this.str;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof MathElement) {
            return this.toString().equals(((MathElement)anObject).toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static String escape(String s) {
        return s.replace("\\", "\\\\").replace("$", "\\$").replace("{", "\\{").replace("}", "\\}");
    }

    private static class TeXStringBuilder {
        private final StringBuilder sb = new StringBuilder();
        private boolean mathMode;

        public void append(String string) {
            this.sb.append(string);
        }

        public void append(char c) {
            this.sb.append(c);
        }

        public boolean isTextMode() {
            return !this.mathMode;
        }

        public boolean isMathMode() {
            return this.mathMode;
        }

        public void goTextMode() {
            this.mathMode = false;
        }

        public void goMathMode() {
            this.mathMode = true;
        }

        public String toString() {
            return this.sb.toString();
        }
    }

    public static class Msubsup
    extends PElement {
        public PElement base;
        public PElement subscript;
        public PElement superscript;

        public Msubsup(PElement base, PElement sub, PElement sup) {
            if (base == null) {
                base = new Mrow();
            }
            this.base = base;
            this.subscript = sub;
            this.superscript = sup;
        }

        @Override
        public String toMathML() {
            return "<msubsup>" + this.base.toMathML() + this.subscript.toMathML() + this.superscript.toMathML() + "</msubsup>";
        }

        @Override
        public void fillTeXString(TeXStringBuilder sb) {
            if (sb.isTextMode()) {
                sb.goMathMode();
                sb.append('$');
            }
            this.base.fillTeXString(sb);
            sb.append("_");
            this.subscript.fillTeXString(sb);
            sb.append("^");
            this.superscript.fillTeXString(sb);
        }
    }

    public static class Msup
    extends PElement {
        public PElement base;
        public PElement superscript;

        public Msup(PElement base, PElement superscript) {
            if (base == null) {
                base = new Mrow();
            }
            this.base = base;
            this.superscript = superscript;
        }

        @Override
        public String toMathML() {
            return "<msup>" + this.base.toMathML() + this.superscript.toMathML() + "</msup>";
        }

        @Override
        public void fillTeXString(TeXStringBuilder sb) {
            if (sb.isTextMode()) {
                sb.goMathMode();
                sb.append('$');
            }
            this.base.fillTeXString(sb);
            sb.append("^");
            this.superscript.fillTeXString(sb);
        }
    }

    public static class Msub
    extends PElement {
        public PElement base;
        public PElement subscript;

        public Msub(PElement base, PElement subscript) {
            if (base == null) {
                base = new Mrow();
            }
            this.base = base;
            this.subscript = subscript;
        }

        @Override
        public String toMathML() {
            return "<msub>" + this.base.toMathML() + this.subscript.toMathML() + "</msub>";
        }

        @Override
        public void fillTeXString(TeXStringBuilder sb) {
            if (sb.isTextMode()) {
                sb.goMathMode();
                sb.append('$');
            }
            this.base.fillTeXString(sb);
            sb.append("_");
            this.subscript.fillTeXString(sb);
        }
    }

    public static class Mtext
    extends PToken {
        public Mtext(String s) {
            this._string = s;
        }

        @Override
        public String toMathML() {
            return "<mtext>" + this._string + "</mtext>";
        }

        @Override
        public void fillTeXString(TeXStringBuilder sb) {
            if (sb.isMathMode()) {
                sb.append('$');
                sb.goTextMode();
            }
            sb.append(this.escape());
        }

        @Override
        public String escape() {
            return Mtext.escape(this._string);
        }
    }

    public static class Mo
    extends PToken {
        public Mo(String s) {
            this._string = s;
        }

        @Override
        public String toMathML() {
            return "<mo>" + this._string + "</mo>";
        }
    }

    public static class Mn
    extends PToken {
        public Mn(String s) {
            this._string = s;
        }

        @Override
        public String toMathML() {
            return "<mn>" + this._string + "</mn>";
        }

        @Override
        public String escape() {
            if (this._string.startsWith("-")) {
                return "{" + this._string + "}";
            }
            return this._string;
        }
    }

    public static class Mi
    extends PToken {
        public Mi(String s) {
            this._string = s;
        }

        public Mi(char c) {
            this._string = String.valueOf(c);
        }

        @Override
        public String toMathML() {
            return "<mi>" + this._string + "</mi>";
        }

        @Override
        public String escape() {
            return Mi.escape(this._string);
        }
    }

    public static abstract class PToken
    extends PElement {
        protected String _string;

        @Override
        public void fillTeXString(TeXStringBuilder sb) {
            if (sb.isTextMode()) {
                sb.goMathMode();
                sb.append('$');
            }
            sb.append(this.escape());
        }

        protected String escape() {
            return this._string;
        }

        public String getToken() {
            return this._string;
        }
    }

    public static class XLines
    extends MathElement {
        private final List<MathElement> mel = new ArrayList<MathElement>();

        public XLines(List<MathElement> xlines) {
            this.mel.addAll(xlines);
        }

        public int size() {
            return this.mel.size();
        }

        public MathElement[] getElements() {
            MathElement[] pa = new MathElement[this.mel.size()];
            return this.mel.toArray(pa);
        }

        public MathElement get(int index) {
            return this.mel.get(index);
        }

        @Override
        public String toMathML() {
            StringBuilder sb = new StringBuilder();
            sb.append("<xlines>");
            for (MathElement p : this.mel) {
                sb.append(p.toMathML());
            }
            sb.append("</xlines>");
            return sb.toString();
        }

        @Override
        public void fillTeXString(TeXStringBuilder sb) {
            if (sb.isMathMode()) {
                throw new IllegalStateException();
            }
            Iterator<MathElement> itr = this.mel.iterator();
            MathElement p = itr.next();
            p.fillTeXString(sb);
            while (itr.hasNext()) {
                if (sb.isMathMode()) {
                    sb.append('$');
                    sb.goTextMode();
                }
                sb.append("\\n");
                p = itr.next();
                p.fillTeXString(sb);
            }
        }
    }

    public static class Mstyle
    extends PContainer {
        protected final MathVariant _mathvariant;

        public Mstyle(MathVariant mathvariant, PElement pe) {
            this._mathvariant = mathvariant;
            if (pe instanceof Mrow) {
                this.pl.addAll(((Mrow)pe).pl);
            } else {
                this.pl.add(pe);
            }
        }

        public MathVariant getMathVariant() {
            return this._mathvariant;
        }

        @Override
        public String toMathML() {
            StringBuilder sb = new StringBuilder();
            sb.append("<mstyle mathvariant=" + (Object)((Object)this._mathvariant) + ">");
            this.fillMathML(sb);
            sb.append("</mstyle>");
            return sb.toString();
        }

        @Override
        public void fillTeXString(TeXStringBuilder sb) {
            if (sb.isTextMode()) {
                sb.append(this._mathvariant.textCommand());
                sb.append('{');
                super.fillTeXString(sb);
                sb.append('}');
            } else if (this.isMtextChildExist()) {
                sb.append(this._mathvariant.textCommand());
                sb.append('{');
                sb.goTextMode();
                super.fillTeXString(sb);
                sb.goMathMode();
                sb.append('}');
            } else {
                sb.append(this._mathvariant.mathCommand());
                sb.append('{');
                super.fillTeXString(sb);
                sb.append('}');
            }
        }
    }

    public static class Mrow
    extends PContainer {
        public Mrow() {
        }

        public Mrow(List<PElement> mes) {
            this.pl.addAll(mes);
        }

        @Override
        public String toMathML() {
            StringBuilder sb = new StringBuilder();
            sb.append("<mrow>");
            this.fillMathML(sb);
            sb.append("</mrow>");
            return sb.toString();
        }

        @Override
        public void fillTeXString(TeXStringBuilder sb) {
            sb.append("{");
            super.fillTeXString(sb);
            sb.append("}");
        }

        @Override
        protected String toTeXString() {
            TeXStringBuilder sb = new TeXStringBuilder();
            super.fillTeXString(sb);
            if (sb.isMathMode()) {
                sb.append('$');
            }
            return sb.toString();
        }
    }

    public static abstract class PContainer
    extends PElement {
        protected final List<PElement> pl = new ArrayList<PElement>();

        public int size() {
            return this.pl.size();
        }

        public List<PElement> getElementList() {
            return this.pl;
        }

        public PElement get(int index) {
            return this.pl.get(index);
        }

        protected void fillMathML(StringBuilder sb) {
            if (this.pl.size() == 0) {
                return;
            }
            for (PElement p : this.pl) {
                sb.append(p.toMathML());
            }
        }

        @Override
        public void fillTeXString(TeXStringBuilder sb) {
            if (this.pl.size() == 0) {
                return;
            }
            for (PElement p : this.pl) {
                p.fillTeXString(sb);
            }
        }

        protected boolean isMtextChildExist() {
            for (PElement p : this.pl) {
                if (p instanceof Mtext) {
                    return true;
                }
                if (!(p instanceof Mrow) || !((Mrow)p).isMtextChildExist()) continue;
                return true;
            }
            return false;
        }
    }

    public static abstract class PElement
    extends MathElement {
    }

    public static enum MathVariant {
        NORMAL,
        BOLD,
        ITALIC;


        public String mathCommand() {
            switch (this) {
                case NORMAL: {
                    return "\\mathrm";
                }
                case BOLD: {
                    return "\\mathbf";
                }
                case ITALIC: {
                    return "\\mathit";
                }
            }
            return null;
        }

        public String textCommand() {
            switch (this) {
                case NORMAL: {
                    return "\\textrm";
                }
                case BOLD: {
                    return "\\textbf";
                }
                case ITALIC: {
                    return "\\textit";
                }
            }
            return null;
        }
    }
}

