/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.proptable.property;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jplot2d.env.PropertyInfo;
import org.jplot2d.swing.proptable.property.MainProperty;

class PropertyDescriptorAdapter<T>
extends MainProperty<T> {
    private PropertyInfo descriptor;

    public PropertyDescriptorAdapter(PropertyInfo descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public String getDisplayName() {
        return this.descriptor.getDisplayName();
    }

    @Override
    public String getShortDescription() {
        return this.descriptor.getShortDescription();
    }

    @Override
    public int getDisplayDigits() {
        return this.descriptor.getDisplayDigits();
    }

    @Override
    public Class<T> getType() {
        return this.descriptor.getPropertyType();
    }

    @Override
    public void readFromObject(Object object) {
        Method method = this.descriptor.getReadMethod();
        if (method != null) {
            try {
                this.setValue(method.invoke(object, new Object[0]));
            }
            catch (InvocationTargetException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public void writeToObject(Object object) throws Throwable {
        Method method = this.descriptor.getWriteMethod();
        if (method != null) {
            try {
                method.invoke(object, this.getValue());
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }

    @Override
    public boolean isEditable() {
        return this.descriptor.getWriteMethod() != null && !this.descriptor.isReadOnly();
    }
}

