/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.proptable.cellrenderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class ColorCellRenderer
extends DefaultTableCellRenderer.UIResource {
    private static final long serialVersionUID = 1L;
    private Color color;

    private String getColorText() {
        if (this.color == null) {
            return "null";
        }
        Color c = this.color;
        if (c.equals(Color.black)) {
            return "black";
        }
        if (c.equals(Color.blue)) {
            return "blue";
        }
        if (c.equals(Color.cyan)) {
            return "cyan";
        }
        if (c.equals(Color.darkGray)) {
            return "darkGray";
        }
        if (c.equals(Color.gray)) {
            return "gray";
        }
        if (c.equals(Color.green)) {
            return "green";
        }
        if (c.equals(Color.lightGray)) {
            return "lightGray";
        }
        if (c.equals(Color.magenta)) {
            return "magenta";
        }
        if (c.equals(Color.orange)) {
            return "orange";
        }
        if (c.equals(Color.pink)) {
            return "pink";
        }
        if (c.equals(Color.red)) {
            return "red";
        }
        if (c.equals(Color.white)) {
            return "white";
        }
        if (c.equals(Color.yellow)) {
            return "yellow";
        }
        return "[" + c.getRed() + ", " + c.getGreen() + ", " + c.getBlue() + "]";
    }

    @Override
    public void setValue(Object value) {
        this.color = (Color)value;
        this.setText(this.getColorText());
        this.setIcon(new ColorIcon());
    }

    public class ColorIcon
    implements Icon {
        @Override
        public int getIconHeight() {
            return ColorCellRenderer.this.getHeight() - 3;
        }

        @Override
        public int getIconWidth() {
            return this.getIconHeight();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color oldColor = g.getColor();
            if (ColorCellRenderer.this.color != null) {
                g.setColor(ColorCellRenderer.this.color);
                g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
            }
            g.setColor(UIManager.getColor("controlDkShadow"));
            g.drawRect(x, y, this.getIconWidth(), this.getIconHeight());
            g.setColor(oldColor);
        }
    }
}

