/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.outline;

import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jplot2d.element.Annotation;
import org.jplot2d.element.Axis;
import org.jplot2d.element.AxisTickManager;
import org.jplot2d.element.AxisTransform;
import org.jplot2d.element.Element;
import org.jplot2d.element.Graph;
import org.jplot2d.element.ImageGraph;
import org.jplot2d.element.Layer;
import org.jplot2d.element.Plot;
import org.jplot2d.element.RGBImageGraph;
import org.jplot2d.element.RGBImageMapping;
import org.jplot2d.element.Title;
import org.jplot2d.element.XYGraph;

public class PlotTreeModel
implements TreeModel {
    private Plot root;
    protected EventListenerList listenerList = new EventListenerList();

    public PlotTreeModel(Plot plot) {
        this.root = plot;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof Plot) {
            Plot plot = (Plot)parent;
            int titleNum = plot.getTitles().length;
            int xaxisNum = plot.getXAxes().length;
            int yaxisNum = plot.getYAxes().length;
            int layerNum = plot.getLayers().length;
            int subplotNum = plot.getSubplots().length;
            int start = 0;
            if (index == start) {
                return plot.getMargin();
            }
            if (++start <= index && index < start + titleNum) {
                return plot.getTitle(index - start);
            }
            if (index == (start += titleNum)) {
                return plot.getLegend();
            }
            if (++start <= index && index < start + xaxisNum) {
                return plot.getXAxis(index - start);
            }
            if ((start += xaxisNum) <= index && index < start + yaxisNum) {
                return plot.getYAxis(index - start);
            }
            if ((start += yaxisNum) <= index && index < start + layerNum) {
                return plot.getLayer(index - start);
            }
            if ((start += layerNum) <= index && index < start + subplotNum) {
                return plot.getSubplot(index - start);
            }
        } else if (parent instanceof Axis) {
            Axis axis = (Axis)parent;
            if (index == 0) {
                return axis.getTitle();
            }
            if (index == 1) {
                return axis.getTickManager();
            }
        } else if (parent instanceof AxisTickManager) {
            AxisTickManager atm = (AxisTickManager)parent;
            if (index == 0) {
                return atm.getAxisTransform();
            }
        } else if (parent instanceof AxisTransform) {
            AxisTransform arm = (AxisTransform)parent;
            if (index == 0) {
                return arm.getLockGroup();
            }
        } else if (parent instanceof Layer) {
            Layer layer = (Layer)parent;
            int gpNum = layer.getGraphs().length;
            int annNum = layer.getAnnotations().length;
            int start = 0;
            if (layer.getXAxisTransform() != null) {
                if (index == start) {
                    return layer.getXAxisTransform();
                }
                ++start;
            }
            if (layer.getXAxisTransform() != null) {
                if (index == start) {
                    return layer.getYAxisTransform();
                }
                ++start;
            }
            if (start <= index && index < start + gpNum) {
                return layer.getGraph(index - start);
            }
            if ((start += gpNum) <= index && index < start + annNum) {
                return layer.getAnnotation(index - start);
            }
        } else if (parent instanceof XYGraph) {
            XYGraph gp = (XYGraph)parent;
            if (index == 0) {
                return gp.getLegendItem();
            }
        } else if (parent instanceof ImageGraph) {
            ImageGraph gp = (ImageGraph)parent;
            if (index == 0) {
                return gp.getMapping();
            }
        } else if (parent instanceof RGBImageGraph) {
            RGBImageGraph gp = (RGBImageGraph)parent;
            if (index == 0) {
                return gp.getMapping();
            }
        } else if (parent instanceof RGBImageMapping) {
            RGBImageMapping mapping = (RGBImageMapping)parent;
            if (index == 0) {
                return mapping.getRedTransform();
            }
            if (index == 1) {
                return mapping.getGreenTransform();
            }
            if (index == 2) {
                return mapping.getBlueTransform();
            }
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof Plot) {
            Plot plot = (Plot)parent;
            int titleNum = plot.getTitles().length;
            int xaxisNum = plot.getXAxes().length;
            int yaxisNum = plot.getYAxes().length;
            int layerNum = plot.getLayers().length;
            int subplotNum = plot.getSubplots().length;
            return 2 + titleNum + xaxisNum + yaxisNum + layerNum + subplotNum;
        }
        if (parent instanceof Axis) {
            return 2;
        }
        if (parent instanceof AxisTickManager) {
            return 1;
        }
        if (parent instanceof AxisTransform) {
            return 1;
        }
        if (parent instanceof Layer) {
            Layer layer = (Layer)parent;
            int n = 0;
            if (layer.getXAxisTransform() != null) {
                ++n;
            }
            if (layer.getYAxisTransform() != null) {
                ++n;
            }
            n += layer.getGraphs().length;
            return n += layer.getAnnotations().length;
        }
        if (parent instanceof XYGraph) {
            return 1;
        }
        if (parent instanceof ImageGraph) {
            return 1;
        }
        if (parent instanceof RGBImageGraph) {
            return 1;
        }
        if (parent instanceof RGBImageMapping) {
            return 3;
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        if (parent instanceof Plot) {
            int i;
            Plot plot = (Plot)parent;
            Title[] titles = plot.getTitles();
            Axis[] xaxes = plot.getXAxes();
            Axis[] yaxes = plot.getYAxes();
            Layer[] layers = plot.getLayers();
            Plot[] subplots = plot.getSubplots();
            int start = 0;
            if (child == plot.getMargin()) {
                return start;
            }
            ++start;
            for (i = 0; i < titles.length; ++i) {
                if (titles[i] != child) continue;
                return start + i;
            }
            start += titles.length;
            if (child == plot.getLegend()) {
                return start;
            }
            ++start;
            for (i = 0; i < xaxes.length; ++i) {
                if (xaxes[i] != child) continue;
                return start + i;
            }
            start += xaxes.length;
            for (i = 0; i < yaxes.length; ++i) {
                if (yaxes[i] != child) continue;
                return start + i;
            }
            start += yaxes.length;
            for (i = 0; i < layers.length; ++i) {
                if (layers[i] != child) continue;
                return start + i;
            }
            start += layers.length;
            for (i = 0; i < subplots.length; ++i) {
                if (subplots[i] != child) continue;
                return start + i;
            }
        } else if (parent instanceof Axis) {
            Axis axis = (Axis)parent;
            if (child == axis.getTitle()) {
                return 0;
            }
            if (child == axis.getTickManager()) {
                return 1;
            }
        } else if (parent instanceof AxisTickManager) {
            if (child == ((AxisTickManager)parent).getAxisTransform()) {
                return 0;
            }
        } else if (parent instanceof AxisTransform) {
            if (child == ((AxisTransform)parent).getLockGroup()) {
                return 0;
            }
        } else if (parent instanceof Layer) {
            int i;
            Layer layer = (Layer)parent;
            Graph[] graphs = layer.getGraphs();
            Annotation[] anns = layer.getAnnotations();
            int start = 0;
            if (layer.getXAxisTransform() != null) {
                if (child == layer.getXAxisTransform()) {
                    return start;
                }
                ++start;
            }
            if (layer.getYAxisTransform() != null) {
                if (child == layer.getYAxisTransform()) {
                    return start;
                }
                ++start;
            }
            for (i = 0; i < graphs.length; ++i) {
                if (graphs[i] != child) continue;
                return start + i;
            }
            start += anns.length;
            for (i = 0; i < anns.length; ++i) {
                if (anns[i] != child) continue;
                return start + i;
            }
        } else if (parent instanceof XYGraph) {
            if (child == ((XYGraph)parent).getLegendItem()) {
                return 0;
            }
        } else if (parent instanceof ImageGraph) {
            if (child == ((ImageGraph)parent).getMapping()) {
                return 0;
            }
        } else if (parent instanceof RGBImageGraph) {
            if (child == ((RGBImageGraph)parent).getMapping()) {
                return 0;
            }
        } else if (parent instanceof RGBImageMapping) {
            if (child == ((RGBImageMapping)parent).getRedTransform()) {
                return 0;
            }
            if (child == ((RGBImageMapping)parent).getGreenTransform()) {
                return 1;
            }
            if (child == ((RGBImageMapping)parent).getBlueTransform()) {
                return 2;
            }
        }
        return -1;
    }

    @Override
    public boolean isLeaf(Object node) {
        return !(node instanceof Plot) && !(node instanceof Axis) && !(node instanceof AxisTickManager) && !(node instanceof AxisTransform) && !(node instanceof Layer) && !(node instanceof Graph) && !(node instanceof RGBImageMapping);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    public void fireTreeStructureChanged(Element cpath) {
        TreeModelListener[] listeners = (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class);
        TreeModelEvent e = new TreeModelEvent((Object)this, new TreePath(this.root));
        for (int i = listeners.length - 1; i >= 0; --i) {
            listeners[i].treeStructureChanged(e);
        }
    }
}

