/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.interaction;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import org.jplot2d.env.RenderEnvironment;
import org.jplot2d.interaction.GenericMouseEvent;
import org.jplot2d.interaction.InteractionHandler;
import org.jplot2d.interaction.InteractionManager;
import org.jplot2d.interaction.VisualFeedbackDrawer;
import org.jplot2d.swing.JPlot2DComponent;
import org.jplot2d.swing.interaction.PopupMenu;
import org.jplot2d.swing.interaction.SwingInteractiveComp;

public class InteractionListener
implements KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
VisualFeedbackDrawer {
    private final JPlot2DComponent comp;
    private final PopupMenu popup;
    private final InteractionHandler ihandler;

    public InteractionListener(JPlot2DComponent comp, InteractionManager imanager, RenderEnvironment env) {
        this.comp = comp;
        this.popup = new PopupMenu(env);
        this.ihandler = new InteractionHandler(imanager);
        this.ihandler.putValue("PLOT_ENV", env);
        this.ihandler.putValue("INTERACTIVE_COMP", new SwingInteractiveComp(comp, env));
        this.ihandler.init();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyMask = this.getKeyMask(e.getKeyCode());
        if (keyMask != 0) {
            this.ihandler.keyPressed(e.getModifiersEx(), keyMask);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int keyMask = this.getKeyMask(e.getKeyCode());
        if (keyMask != 0) {
            this.ihandler.keyReleased(e.getModifiersEx(), keyMask);
        }
    }

    private int getKeyMask(int keyCode) {
        switch (keyCode) {
            case 16: {
                return 64;
            }
            case 17: {
                return 128;
            }
            case 157: {
                return 256;
            }
            case 18: {
                return 512;
            }
        }
        return 0;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popupMenu(e.getX(), e.getY());
        } else {
            this.ihandler.mousePressed(this.getGenericMouseEvent(e));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popupMenu(e.getX(), e.getY());
        } else {
            this.ihandler.mouseReleased(this.getGenericMouseEvent(e));
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.ihandler.mouseMoved(this.getGenericMouseEvent(e));
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.ihandler.mouseDragged(this.getGenericMouseEvent(e));
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.ihandler.mouseWheelMoved(this.getGenericMouseEvent(e));
    }

    @Override
    public void draw(Object graphics) {
        this.ihandler.draw(graphics);
    }

    private GenericMouseEvent getGenericMouseEvent(MouseEvent e) {
        int count = e instanceof MouseWheelEvent ? ((MouseWheelEvent)e).getWheelRotation() : e.getClickCount();
        GenericMouseEvent gme = new GenericMouseEvent(e.getID(), e.getModifiersEx(), e.getX() - this.comp.getImageOffsetX(), e.getY() - this.comp.getImageOffsetY(), count, e.getButton());
        return gme;
    }

    private void popupMenu(int x, int y) {
        this.popup.updateStatus(x, y);
        this.popup.show(this.comp, x, y);
    }
}

