/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.demo;

import org.jplot2d.data.ArrayPair;
import org.jplot2d.element.Axis;
import org.jplot2d.element.ElementFactory;
import org.jplot2d.element.Layer;
import org.jplot2d.element.Plot;
import org.jplot2d.element.XYGraph;
import org.jplot2d.sizing.FillContainerSizeMode;
import org.jplot2d.swing.JPlot2DFrame;
import org.jplot2d.util.Range;
import org.jplot2d.util.SymbolShape;

public class FastPanDemo {
    public static void main(String[] args) {
        int n = 1000;
        Plot plot = ElementFactory.getInstance().createPlot();
        plot.setSizeMode(new FillContainerSizeMode(1.0));
        JPlot2DFrame frame = new JPlot2DFrame(plot);
        frame.setSize(640, 480);
        frame.setVisible(true);
        Axis xaxis = ElementFactory.getInstance().createAxis();
        Axis yaxis = ElementFactory.getInstance().createAxis();
        xaxis.getTitle().setText("x axis");
        xaxis.getTickManager().setRange(new Range.Double(0.0, n));
        plot.addXAxis(xaxis);
        yaxis.getTitle().setText("y axis");
        yaxis.getTickManager().setRange(new Range.Double(0.0, n));
        plot.addYAxis(yaxis);
        ArrayPair ap0 = new ArrayPair(new double[]{0.0, 0.0}, new double[]{n, n});
        ArrayPair ap1 = new ArrayPair(new double[]{0.0, n}, new double[]{n, 0.0});
        XYGraph plotter0 = ElementFactory.getInstance().createXYGraph(ap0, "lineA");
        XYGraph plotter1 = ElementFactory.getInstance().createXYGraph(ap1, "lineB");
        plotter0.setSymbolVisible(true);
        plotter0.setSymbolShape(SymbolShape.CIRCLE);
        plotter1.setSymbolVisible(true);
        plotter1.setSymbolShape(SymbolShape.CIRCLE);
        Layer layer0 = ElementFactory.getInstance().createLayer();
        layer0.addGraph(plotter0);
        layer0.addGraph(plotter1);
        plot.addLayer(layer0, xaxis, yaxis);
        double step = 1.0 / (double)n;
        for (int i = 0; i < n; ++i) {
            plot.zoomXRange(-step, 1.0 - step);
            plot.zoomYRange(-step, 1.0 - step);
            System.out.print(".");
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("done");
    }
}

