/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.renderer;

import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jplot2d.element.impl.ComponentEx;
import org.jplot2d.element.impl.PlotEx;
import org.jplot2d.renderer.CacheableBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Renderer {
    protected static final Logger logger = LoggerFactory.getLogger((String)"org.jplot2d.renderer");

    public abstract void render(ComponentEx var1, List<CacheableBlock> var2);

    protected static Rectangle getDeviceBounds(ComponentEx comp) {
        if (comp instanceof PlotEx) {
            double scale = ((PlotEx)comp).getPaperTransform().getScale();
            Dimension2D size = ((PlotEx)comp).getSize();
            return new Rectangle2D.Double(0.0, 0.0, size.getWidth() * scale, size.getHeight() * scale).getBounds();
        }
        Rectangle2D pbounds = comp.getBounds();
        return comp.getPaperTransform().getPtoD(pbounds).getBounds();
    }
}

