/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.layout;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jplot2d.element.AxisPosition;
import org.jplot2d.element.HAlign;
import org.jplot2d.element.VAlign;
import org.jplot2d.element.impl.AxisEx;
import org.jplot2d.element.impl.LegendEx;
import org.jplot2d.element.impl.PlotEx;
import org.jplot2d.element.impl.PlotMarginEx;
import org.jplot2d.element.impl.TitleEx;
import org.jplot2d.layout.LayoutDirector;
import org.jplot2d.util.DoubleDimension2D;
import org.jplot2d.util.Insets2D;

public class SimpleLayoutDirector
implements LayoutDirector {
    static double LEGEND_GAP = 8.0;
    private Map<PlotEx, Object> constraints = new HashMap<PlotEx, Object>();

    @Override
    public Object getConstraint(PlotEx plot) {
        return this.constraints.get(plot);
    }

    @Override
    public void remove(PlotEx plot) {
        this.constraints.remove(plot);
    }

    @Override
    public void setConstraint(PlotEx plot, Object constraint) {
        this.constraints.put(plot, constraint);
    }

    @Override
    public void invalidateLayout(PlotEx plot) {
    }

    @Override
    public void layout(PlotEx plot) {
        double contentHeight;
        double contentWidth;
        AxesInPlot ais = SimpleLayoutDirector.getAllAxes(plot);
        Insets2D margin = SimpleLayoutDirector.calcMargin(plot, ais);
        if (plot.getContentConstrant() != null) {
            contentWidth = plot.getContentConstrant().getWidth();
            contentHeight = plot.getContentConstrant().getHeight();
        } else {
            contentWidth = plot.getSize().getWidth() - margin.getLeft() - margin.getRight();
            contentHeight = plot.getSize().getHeight() - margin.getTop() - margin.getBottom();
        }
        if (contentWidth < 0.0) {
            contentWidth = 0.0;
        }
        if (contentHeight < 0.0) {
            contentHeight = 0.0;
        }
        if (plot.getContentConstrant() != null) {
            double width = contentWidth + margin.getLeft() + margin.getRight();
            double height = contentHeight + margin.getTop() + margin.getBottom();
            plot.setSize(width, height);
        }
        DoubleDimension2D contentSize = new DoubleDimension2D(contentWidth, contentHeight);
        plot.setContentSize(contentSize);
        SimpleLayoutDirector.layoutLeftMargin(plot, contentSize, ais.leftAxes);
        SimpleLayoutDirector.layoutRightMargin(plot, contentSize, ais.rightAxes);
        SimpleLayoutDirector.layoutTopMargin(plot, contentSize, ais.topAxes);
        SimpleLayoutDirector.layoutBottomMargin(plot, contentSize, ais.bottomAxes);
    }

    protected static AxesInPlot getAllAxes(PlotEx plot) {
        AxesInPlot ais = new AxesInPlot();
        for (AxisEx axis : plot.getXAxes()) {
            if (!axis.isVisible() || !axis.canContribute()) continue;
            if (axis.getPosition() == AxisPosition.POSITIVE_SIDE) {
                ais.topAxes.add(axis);
                continue;
            }
            ais.bottomAxes.add(axis);
        }
        for (AxisEx axis : plot.getYAxes()) {
            if (!axis.isVisible() || !axis.canContribute()) continue;
            if (axis.getPosition() == AxisPosition.POSITIVE_SIDE) {
                ais.rightAxes.add(axis);
                continue;
            }
            ais.leftAxes.add(axis);
        }
        return ais;
    }

    protected static double calcLeftMargin(PlotEx plot, ArrayList<AxisEx> leftAxes) {
        LegendEx legend;
        PlotMarginEx margin = plot.getMargin();
        if (!margin.isAutoLeft()) {
            return margin.getLeft() + margin.getExtraLeft();
        }
        double mLeft = 0.0;
        if (leftAxes.size() > 0) {
            for (AxisEx am : leftAxes) {
                mLeft += am.getAsc() + am.getDesc();
            }
            mLeft -= leftAxes.get(0).getDesc();
        }
        if ((legend = plot.getLegend()).isVisible() && legend.canContribute()) {
            switch (legend.getPosition()) {
                case LEFTTOP: 
                case LEFTMIDDLE: 
                case LEFTBOTTOM: {
                    mLeft += LEGEND_GAP + legend.getSize().getWidth();
                }
            }
        }
        plot.getMargin().directLeft(mLeft);
        return mLeft + margin.getExtraLeft();
    }

    protected static double calcRightMargin(PlotEx plot, ArrayList<AxisEx> rightAxes) {
        LegendEx legend;
        PlotMarginEx margin = plot.getMargin();
        if (!margin.isAutoRight()) {
            return margin.getRight() + margin.getExtraRight();
        }
        double mRight = 0.0;
        if (rightAxes.size() > 0) {
            for (AxisEx am : rightAxes) {
                mRight += am.getAsc() + am.getDesc();
            }
            mRight -= rightAxes.get(0).getAsc();
        }
        if ((legend = plot.getLegend()).isVisible() && legend.canContribute()) {
            switch (legend.getPosition()) {
                case RIGHTTOP: 
                case RIGHTMIDDLE: 
                case RIGHTBOTTOM: {
                    mRight += LEGEND_GAP + legend.getSize().getWidth();
                }
            }
        }
        plot.getMargin().directRight(mRight);
        return mRight + margin.getExtraRight();
    }

    protected static double calcTopMargin(PlotEx plot, ArrayList<AxisEx> topAxes) {
        LegendEx legend;
        PlotMarginEx margin = plot.getMargin();
        if (!margin.isAutoTop()) {
            return margin.getTop() + margin.getExtraTop();
        }
        double mTop = 0.0;
        if (topAxes.size() > 0) {
            for (AxisEx am : topAxes) {
                mTop += am.getAsc() + am.getDesc();
            }
            mTop -= topAxes.get(0).getDesc();
        }
        if ((legend = plot.getLegend()).isVisible() && legend.canContribute()) {
            switch (legend.getPosition()) {
                case TOPLEFT: 
                case TOPCENTER: 
                case TOPRIGHT: {
                    mTop += LEGEND_GAP + legend.getSize().getHeight();
                }
            }
        }
        for (TitleEx title : plot.getTitles()) {
            if (!title.isVisible() || !title.canContribute()) continue;
            double titleHeight = title.getSize().getHeight();
            switch (title.getPosition()) {
                case TOPLEFT: 
                case TOPCENTER: 
                case TOPRIGHT: {
                    mTop += (1.0 + title.getGapFactor()) * titleHeight;
                }
            }
        }
        plot.getMargin().directTop(mTop);
        return mTop + margin.getExtraTop();
    }

    protected static double calcBottomMargin(PlotEx plot, ArrayList<AxisEx> bottomAxes) {
        LegendEx legend;
        PlotMarginEx margin = plot.getMargin();
        if (!margin.isAutoBottom()) {
            return margin.getBottom() + margin.getExtraBottom();
        }
        double mBottom = 0.0;
        if (bottomAxes.size() > 0) {
            for (AxisEx am : bottomAxes) {
                mBottom += am.getAsc() + am.getDesc();
            }
            mBottom -= bottomAxes.get(0).getAsc();
        }
        if ((legend = plot.getLegend()).isVisible() && legend.canContribute()) {
            switch (legend.getPosition()) {
                case BOTTOMLEFT: 
                case BOTTOMCENTER: 
                case BOTTOMRIGHT: {
                    mBottom += LEGEND_GAP + legend.getSize().getHeight();
                }
            }
        }
        for (TitleEx title : plot.getTitles()) {
            if (!title.isVisible() || !title.canContribute()) continue;
            double titleHeight = title.getSize().getHeight();
            switch (title.getPosition()) {
                case BOTTOMLEFT: 
                case BOTTOMCENTER: 
                case BOTTOMRIGHT: {
                    mBottom += (1.0 + title.getGapFactor()) * titleHeight;
                }
            }
        }
        plot.getMargin().directBottom(mBottom);
        return mBottom + margin.getExtraBottom();
    }

    private static Insets2D calcMargin(PlotEx plot, AxesInPlot ais) {
        double mTop = SimpleLayoutDirector.calcTopMargin(plot, ais.topAxes);
        double mBottom = SimpleLayoutDirector.calcBottomMargin(plot, ais.bottomAxes);
        double mLeft = SimpleLayoutDirector.calcLeftMargin(plot, ais.leftAxes);
        double mRight = SimpleLayoutDirector.calcRightMargin(plot, ais.rightAxes);
        return new Insets2D.Double(mTop, mLeft, mBottom, mRight);
    }

    private static void layoutLeftMargin(PlotEx sp, Dimension2D contentSize, ArrayList<AxisEx> leftAxes) {
        LegendEx legend;
        double iabLeft = 0.0;
        double iabBottom = 0.0;
        double xloc = iabLeft;
        if (leftAxes.size() > 0) {
            AxisEx am = leftAxes.get(0);
            am.setLength(contentSize.getHeight());
            am.setLocation(xloc, iabBottom);
            xloc -= am.getAsc();
            for (int i = 1; i < leftAxes.size(); ++i) {
                am = leftAxes.get(i);
                am.setLength(contentSize.getHeight());
                am.setLocation(xloc -= am.getDesc(), iabBottom);
                xloc -= am.getAsc();
            }
        }
        if ((legend = sp.getLegend()).isVisible() && legend.canContribute()) {
            switch (legend.getPosition()) {
                case LEFTTOP: {
                    legend.directLocation(xloc -= LEGEND_GAP, contentSize.getHeight());
                    legend.setHAlign(HAlign.RIGHT);
                    legend.setVAlign(VAlign.TOP);
                    break;
                }
                case LEFTMIDDLE: {
                    legend.directLocation(xloc -= LEGEND_GAP, contentSize.getHeight() / 2.0);
                    legend.setHAlign(HAlign.RIGHT);
                    legend.setVAlign(VAlign.MIDDLE);
                    break;
                }
                case LEFTBOTTOM: {
                    legend.directLocation(xloc -= LEGEND_GAP, 0.0);
                    legend.setHAlign(HAlign.RIGHT);
                    legend.setVAlign(VAlign.BOTTOM);
                }
            }
        }
    }

    private static void layoutRightMargin(PlotEx sp, Dimension2D contentSize, ArrayList<AxisEx> rightAxes) {
        LegendEx legend;
        double iabRight = contentSize.getWidth();
        double iabBottom = 0.0;
        double xloc = iabRight;
        if (rightAxes.size() > 0) {
            AxisEx am = rightAxes.get(0);
            am.setLength(contentSize.getHeight());
            am.setLocation(xloc, iabBottom);
            xloc += am.getDesc();
            for (int i = 1; i < rightAxes.size(); ++i) {
                am = rightAxes.get(i);
                am.setLength(contentSize.getHeight());
                am.setLocation(xloc += am.getAsc(), iabBottom);
                xloc += am.getDesc();
            }
        }
        if ((legend = sp.getLegend()).isVisible() && legend.canContribute()) {
            switch (legend.getPosition()) {
                case RIGHTTOP: {
                    legend.directLocation(xloc += LEGEND_GAP, contentSize.getHeight());
                    legend.setHAlign(HAlign.LEFT);
                    legend.setVAlign(VAlign.TOP);
                    break;
                }
                case RIGHTMIDDLE: {
                    legend.directLocation(xloc += LEGEND_GAP, contentSize.getHeight() / 2.0);
                    legend.setHAlign(HAlign.LEFT);
                    legend.setVAlign(VAlign.MIDDLE);
                    break;
                }
                case RIGHTBOTTOM: {
                    legend.directLocation(xloc += LEGEND_GAP, 0.0);
                    legend.setHAlign(HAlign.LEFT);
                    legend.setVAlign(VAlign.BOTTOM);
                }
            }
        }
    }

    private static void layoutTopMargin(PlotEx sp, Dimension2D contentSize, ArrayList<AxisEx> topAxes) {
        LegendEx legend;
        double iabTop;
        double iabLeft = 0.0;
        double yloc = iabTop = contentSize.getHeight();
        if (topAxes.size() > 0) {
            AxisEx am = topAxes.get(0);
            am.setLength(contentSize.getWidth());
            am.setLocation(iabLeft, yloc);
            yloc += am.getAsc();
            for (int i = 1; i < topAxes.size(); ++i) {
                am = topAxes.get(i);
                am.setLength(contentSize.getWidth());
                am.setLocation(iabLeft, yloc += am.getDesc());
                yloc += am.getAsc();
            }
        }
        if ((legend = sp.getLegend()).isVisible() && legend.canContribute()) {
            switch (legend.getPosition()) {
                case TOPLEFT: {
                    legend.directLocation(0.0, yloc += LEGEND_GAP);
                    legend.setHAlign(HAlign.LEFT);
                    legend.setVAlign(VAlign.BOTTOM);
                    yloc += legend.getSize().getHeight();
                    break;
                }
                case TOPCENTER: {
                    legend.directLocation(contentSize.getWidth() / 2.0, yloc += LEGEND_GAP);
                    legend.setHAlign(HAlign.CENTER);
                    legend.setVAlign(VAlign.BOTTOM);
                    yloc += legend.getSize().getHeight();
                    break;
                }
                case TOPRIGHT: {
                    legend.directLocation(contentSize.getWidth(), yloc += LEGEND_GAP);
                    legend.setHAlign(HAlign.RIGHT);
                    legend.setVAlign(VAlign.BOTTOM);
                    yloc += legend.getSize().getHeight();
                }
            }
        }
        TitleEx[] titles = sp.getTitles();
        block11: for (int i = titles.length - 1; i >= 0; --i) {
            TitleEx title = titles[i];
            if (!title.isVisible() || !title.canContribute()) continue;
            double titleHeight = title.getSize().getHeight();
            switch (title.getPosition()) {
                case TOPLEFT: {
                    title.setLocation(0.0, yloc += title.getGapFactor() * titleHeight);
                    title.setHAlign(HAlign.LEFT);
                    title.setVAlign(VAlign.BOTTOM);
                    yloc += titleHeight;
                    continue block11;
                }
                case TOPCENTER: {
                    title.setLocation(contentSize.getWidth() / 2.0, yloc += title.getGapFactor() * titleHeight);
                    title.setHAlign(HAlign.CENTER);
                    title.setVAlign(VAlign.BOTTOM);
                    yloc += titleHeight;
                    continue block11;
                }
                case TOPRIGHT: {
                    title.setLocation(contentSize.getWidth(), yloc += title.getGapFactor() * titleHeight);
                    title.setHAlign(HAlign.RIGHT);
                    title.setVAlign(VAlign.BOTTOM);
                    yloc += titleHeight;
                }
            }
        }
    }

    private static void layoutBottomMargin(PlotEx sp, Dimension2D contentSize, ArrayList<AxisEx> bottomAxes) {
        LegendEx legend;
        double iabBottom;
        double iabLeft = 0.0;
        double yloc = iabBottom = 0.0;
        if (bottomAxes.size() > 0) {
            AxisEx am = bottomAxes.get(0);
            am.setLength(contentSize.getWidth());
            am.setLocation(iabLeft, yloc);
            yloc -= am.getDesc();
            for (int i = 1; i < bottomAxes.size(); ++i) {
                am = bottomAxes.get(i);
                am.setLength(contentSize.getWidth());
                am.setLocation(iabLeft, yloc -= am.getAsc());
                yloc -= am.getDesc();
            }
        }
        if ((legend = sp.getLegend()).isVisible() && legend.canContribute()) {
            switch (legend.getPosition()) {
                case BOTTOMLEFT: {
                    legend.directLocation(0.0, yloc -= LEGEND_GAP);
                    legend.setHAlign(HAlign.LEFT);
                    legend.setVAlign(VAlign.TOP);
                    yloc -= legend.getSize().getHeight();
                    break;
                }
                case BOTTOMCENTER: {
                    legend.directLocation(contentSize.getWidth() / 2.0, yloc -= LEGEND_GAP);
                    legend.setHAlign(HAlign.CENTER);
                    legend.setVAlign(VAlign.TOP);
                    yloc -= legend.getSize().getHeight();
                    break;
                }
                case BOTTOMRIGHT: {
                    legend.directLocation(contentSize.getWidth(), yloc -= LEGEND_GAP);
                    legend.setHAlign(HAlign.RIGHT);
                    legend.setVAlign(VAlign.TOP);
                    yloc -= legend.getSize().getHeight();
                }
            }
        }
        block11: for (TitleEx title : sp.getTitles()) {
            if (!title.isVisible() || !title.canContribute()) continue;
            double titleHeight = title.getSize().getHeight();
            switch (title.getPosition()) {
                case BOTTOMLEFT: {
                    title.setLocation(0.0, yloc -= title.getGapFactor() * titleHeight);
                    title.setHAlign(HAlign.LEFT);
                    title.setVAlign(VAlign.TOP);
                    yloc -= titleHeight;
                    continue block11;
                }
                case BOTTOMCENTER: {
                    title.setLocation(contentSize.getWidth() / 2.0, yloc -= title.getGapFactor() * titleHeight);
                    title.setHAlign(HAlign.CENTER);
                    title.setVAlign(VAlign.TOP);
                    yloc -= titleHeight;
                    continue block11;
                }
                case BOTTOMRIGHT: {
                    title.setLocation(contentSize.getWidth(), yloc -= title.getGapFactor() * titleHeight);
                    title.setHAlign(HAlign.RIGHT);
                    title.setVAlign(VAlign.TOP);
                    yloc -= titleHeight;
                }
            }
        }
    }

    @Override
    public Dimension2D getPreferredContentSize(PlotEx plot) {
        return plot.getPreferredContentSize();
    }

    @Override
    public Dimension2D getPreferredSize(PlotEx plot) {
        Dimension2D prefContSize = this.getPreferredContentSize(plot);
        if (prefContSize == null) {
            return null;
        }
        AxesInPlot ais = SimpleLayoutDirector.getAllAxes(plot);
        Insets2D margin = SimpleLayoutDirector.calcMargin(plot, ais);
        double w = prefContSize.getWidth() + margin.getLeft() + margin.getRight();
        double h = prefContSize.getHeight() + margin.getTop() + margin.getBottom();
        return new DoubleDimension2D(w, h);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class AxesInPlot {
        final ArrayList<AxisEx> leftAxes = new ArrayList();
        final ArrayList<AxisEx> rightAxes = new ArrayList();
        final ArrayList<AxisEx> topAxes = new ArrayList();
        final ArrayList<AxisEx> bottomAxes = new ArrayList();
    }
}

