/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.layout;

import org.jplot2d.util.SparseDoubleArray;

public class GridCellInsets {
    private final SparseDoubleArray topPadding;
    private final SparseDoubleArray leftPadding;
    private final SparseDoubleArray bottomPadding;
    private final SparseDoubleArray rightPadding;
    private final double sumWidth;
    private final double sumHeight;

    public GridCellInsets(SparseDoubleArray topPadding, SparseDoubleArray leftPadding, SparseDoubleArray bottomPadding, SparseDoubleArray rightPadding) {
        int i;
        int i2;
        this.topPadding = topPadding;
        this.leftPadding = leftPadding;
        this.bottomPadding = bottomPadding;
        this.rightPadding = rightPadding;
        double sumXpad = 0.0;
        for (i2 = 0; i2 < leftPadding.size(); ++i2) {
            double left = leftPadding.valueAt(i2);
            sumXpad += left;
        }
        for (i2 = 0; i2 < rightPadding.size(); ++i2) {
            double right = rightPadding.valueAt(i2);
            sumXpad += right;
        }
        this.sumWidth = sumXpad;
        double sumYpad = 0.0;
        for (i = 0; i < topPadding.size(); ++i) {
            double top = topPadding.valueAt(i);
            sumYpad += top;
        }
        for (i = 0; i < bottomPadding.size(); ++i) {
            double bottom = bottomPadding.valueAt(i);
            sumYpad += bottom;
        }
        this.sumHeight = sumYpad;
    }

    public double getTop(int row) {
        Double v = this.topPadding.get(row);
        return v == null ? 0.0 : v;
    }

    public double getLeft(int col) {
        Double v = this.leftPadding.get(col);
        return v == null ? 0.0 : v;
    }

    public double getBottom(int row) {
        Double v = this.bottomPadding.get(row);
        return v == null ? 0.0 : v;
    }

    public double getRight(int col) {
        Double v = this.rightPadding.get(col);
        return v == null ? 0.0 : v;
    }

    public double getSumWidth() {
        return this.sumWidth;
    }

    public double getSumHeight() {
        return this.sumHeight;
    }
}

