/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.interaction;

import org.jplot2d.interaction.CursorFeedbackBehavior;
import org.jplot2d.interaction.InteractionManager;
import org.jplot2d.interaction.InteractionMode;
import org.jplot2d.interaction.MouseActivateComponentBehavior;
import org.jplot2d.interaction.MouseAdaptiveZoomBehavior;
import org.jplot2d.interaction.MouseAxisAdaptiveZoomBehavior;
import org.jplot2d.interaction.MouseAxisPanBehavior;
import org.jplot2d.interaction.MouseAxisRangeZoomBehavior;
import org.jplot2d.interaction.MouseAxisWheelFinerZoomBehavior;
import org.jplot2d.interaction.MouseAxisWheelZoomBehavior;
import org.jplot2d.interaction.MouseBehavior;
import org.jplot2d.interaction.MouseCoordinatesTooltipBehavior;
import org.jplot2d.interaction.MouseMarqueeZoomBehavior;
import org.jplot2d.interaction.MouseMoveComponentBehavior;
import org.jplot2d.interaction.MousePanBehavior;
import org.jplot2d.interaction.MouseWheelFinerZoomBehavior;
import org.jplot2d.interaction.MouseWheelZoomBehavior;

public final class PlotInteractionManager
extends InteractionManager {
    public static final String PLOT_ENV_KEY = "PLOT_ENV";
    public static final String INTERACTIVE_COMP_KEY = "INTERACTIVE_COMP";
    public static final String ACTIVE_COMPONENT_KEY = "ACTIVE_COMPONENT";
    public static final String ACTIVE_COMPONENT_MOVABLE_KEY = "ACTIVE_COMPONENT_MOVABLE";
    private static final PlotInteractionManager instance = new PlotInteractionManager();
    protected final MouseBehavior activeComponentBehavior;
    protected final MouseBehavior showCoordinatesTooltipBehavior;
    protected final MouseBehavior moveComponentBehavior;
    protected final MouseBehavior axisAdaptiveZoomBehavior;
    protected final MouseBehavior adaptiveZoomBehavior;
    protected final MouseBehavior axisRangeZoomBehavior;
    protected final MouseBehavior marqueeZoomBehavior;
    protected final MouseBehavior axisWheelZoomBehavior;
    protected final MouseBehavior wheelZoomBehavior;
    protected final MouseBehavior axisWheelFinerZoomBehavior;
    protected final MouseBehavior wheelFinerZoomBehavior;
    protected final MouseBehavior axisPanBehavior;
    protected final MouseBehavior panBehavior;
    final InteractionMode defaultMode = new InteractionMode("DEFAULT");

    public static PlotInteractionManager getInstance() {
        return instance;
    }

    private PlotInteractionManager() {
        this.activeComponentBehavior = new MouseActivateComponentBehavior("ActivateComponent");
        this.showCoordinatesTooltipBehavior = new MouseCoordinatesTooltipBehavior("UpdateCoordinatesTooltip");
        this.moveComponentBehavior = new MouseMoveComponentBehavior("MoveComponent");
        this.axisPanBehavior = new MouseAxisPanBehavior("Pan on axis");
        this.panBehavior = new MousePanBehavior("Pan");
        this.axisAdaptiveZoomBehavior = new MouseAxisAdaptiveZoomBehavior("AdaptiveZoom on axis");
        this.adaptiveZoomBehavior = new MouseAdaptiveZoomBehavior("AdaptiveZoom");
        this.axisRangeZoomBehavior = new MouseAxisRangeZoomBehavior("Zoom on axis");
        this.marqueeZoomBehavior = new MouseMarqueeZoomBehavior("Zoom");
        this.axisWheelZoomBehavior = new MouseAxisWheelZoomBehavior("WheelZoom on axis");
        this.wheelZoomBehavior = new MouseWheelZoomBehavior("WheelZoom");
        this.axisWheelFinerZoomBehavior = new MouseAxisWheelFinerZoomBehavior("WheelFinerZoom on axis");
        this.wheelFinerZoomBehavior = new MouseWheelFinerZoomBehavior("WheelFinerZoom");
        this.defaultMode.setAvailableMouseBehaviors(this.activeComponentBehavior, this.showCoordinatesTooltipBehavior, this.moveComponentBehavior, this.axisPanBehavior, this.panBehavior, this.axisAdaptiveZoomBehavior, this.adaptiveZoomBehavior, this.axisRangeZoomBehavior, this.marqueeZoomBehavior, this.axisWheelZoomBehavior, this.wheelZoomBehavior, this.axisWheelFinerZoomBehavior, this.wheelFinerZoomBehavior);
        this.defaultMode.setValueChangeBehaviors(new CursorFeedbackBehavior());
        this.registerMode(this.defaultMode);
        this.setDefaultMode(this.defaultMode);
    }
}

