/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.interaction;

import org.jplot2d.interaction.GenericMouseEvent;
import org.jplot2d.interaction.InteractionModeHandler;
import org.jplot2d.interaction.MouseBehaviorHandler;
import org.jplot2d.interaction.MouseDragBehavior;

public abstract class MouseDragBehaviorHandler<T extends MouseDragBehavior>
extends MouseBehaviorHandler<T> {
    private boolean indrag;

    public MouseDragBehaviorHandler(T behavior, InteractionModeHandler handler) {
        super(behavior, handler);
    }

    @Override
    public final boolean processMouseEvent(GenericMouseEvent e) {
        if (e.getType() == 501 && this.canStartDargging(e.getX(), e.getY())) {
            this.indrag = true;
            this.draggingStarted(e.getX(), e.getY());
            return true;
        }
        if (e.getType() == 506 && this.indrag) {
            this.draggingTo(e.getX(), e.getY());
            return true;
        }
        if (e.getType() == 502 && this.indrag) {
            this.indrag = false;
            this.draggingFinished(e.getX(), e.getY());
            return true;
        }
        return false;
    }

    public abstract boolean canStartDargging(int var1, int var2);

    public abstract void draggingStarted(int var1, int var2);

    public abstract void draggingTo(int var1, int var2);

    public abstract void draggingFinished(int var1, int var2);

    public abstract void draggingCancelled();
}

