/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.interaction;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.jplot2d.interaction.GenericMouseEvent;
import org.jplot2d.interaction.InteractionHandler;
import org.jplot2d.interaction.InteractionMode;
import org.jplot2d.interaction.MouseBehavior;
import org.jplot2d.interaction.MouseBehaviorHandler;
import org.jplot2d.interaction.MouseButtonCombination;
import org.jplot2d.interaction.MouseWheelBehavior;
import org.jplot2d.interaction.ValueChangeBehavior;
import org.jplot2d.interaction.ValueChangeHandler;
import org.jplot2d.interaction.VisualFeedbackDrawer;

public class InteractionModeHandler {
    public static final String MODE_ENTERED_KEY = "MODE_ENTERED";
    private final InteractionHandler ihandler;
    private final InteractionMode imode;
    final Map<String, Object> valueMap = new HashMap<String, Object>();
    private final Map<MouseBehavior, MouseBehaviorHandler<?>> handlerMap = new HashMap();
    private final Map<ValueChangeBehavior, ValueChangeHandler<?>> vcHandlerMap = new HashMap();

    public InteractionModeHandler(InteractionHandler ihandler, InteractionMode imode) {
        this.imode = imode;
        this.ihandler = ihandler;
    }

    public final InteractionMode getInteractionMode() {
        return this.imode;
    }

    void addMouseBehaviorHandler(MouseBehaviorHandler<?> handler) {
        this.handlerMap.put((MouseBehavior)handler.behavior, handler);
    }

    void addValueChangeHandler(ValueChangeHandler<?> handler) {
        this.vcHandlerMap.put((ValueChangeBehavior)handler.behavior, handler);
    }

    public void keyPressed(int modifiers, int modifierKey) {
        this.exitModifiersKey(modifiers & ~modifierKey);
        this.enterModifiersKey(modifiers);
    }

    public void keyReleased(int modifiers, int modifierKey) {
        this.exitModifiersKey(modifiers | modifierKey);
        this.enterModifiersKey(modifiers);
    }

    private void enterModifiersKey(int modifiers) {
        for (Map.Entry<MouseBehavior, Integer> me : this.imode.modifiersKeyMap.entrySet()) {
            MouseBehaviorHandler<?> handler;
            MouseBehavior behavior = me.getKey();
            int modi = me.getValue();
            if (modi != modifiers || !(handler = this.handlerMap.get(behavior)).enterModifiersKey()) continue;
            break;
        }
    }

    private void exitModifiersKey(int modifiers) {
        for (Map.Entry<MouseBehavior, Integer> me : this.imode.modifiersKeyMap.entrySet()) {
            MouseBehaviorHandler<?> handler;
            MouseBehavior behavior = me.getKey();
            int modi = me.getValue();
            if (modi != modifiers || !(handler = this.handlerMap.get(behavior)).exitModifiersKey()) continue;
            break;
        }
    }

    public void mouseEntered(GenericMouseEvent e) {
    }

    public void mouseExited(GenericMouseEvent e) {
    }

    public void mouseClicked(GenericMouseEvent e) {
        this.handleMouseEvent(e, this.imode.clickMap);
    }

    public void mousePressed(GenericMouseEvent e) {
        this.handleMouseEvent(e, this.imode.pressMap);
    }

    public void mouseReleased(GenericMouseEvent e) {
        this.handleMouseEvent(e, this.imode.releaseMap);
    }

    public void mouseMoved(GenericMouseEvent e) {
        this.handleMouseEvent(e, this.imode.moveMap);
    }

    public void mouseDragged(GenericMouseEvent e) {
        this.handleMouseEvent(e, this.imode.dragMap);
    }

    public void mouseWheelMoved(GenericMouseEvent e) {
        for (Map.Entry<MouseWheelBehavior, MouseButtonCombination> me : this.imode.wheelMap.entrySet()) {
            MouseBehaviorHandler<?> handler;
            MouseWheelBehavior behavior = me.getKey();
            MouseButtonCombination mbc = me.getValue();
            if (!mbc.match(e) || !(handler = this.handlerMap.get(behavior)).processMouseEvent(e)) continue;
            break;
        }
    }

    private void handleMouseEvent(GenericMouseEvent e, Map<MouseBehavior, MouseButtonCombination> behaviorMap) {
        for (Map.Entry<MouseBehavior, MouseButtonCombination> me : behaviorMap.entrySet()) {
            MouseBehaviorHandler<?> handler;
            MouseBehavior behavior = me.getKey();
            MouseButtonCombination mbc = me.getValue();
            if (!mbc.match(e) || !(handler = this.handlerMap.get(behavior)).processMouseEvent(e)) continue;
            break;
        }
    }

    public void draw(Object graphics) {
        for (MouseBehaviorHandler<?> mouseBehaviorHandler : this.handlerMap.values()) {
            if (!(mouseBehaviorHandler instanceof VisualFeedbackDrawer)) continue;
            ((VisualFeedbackDrawer)((Object)mouseBehaviorHandler)).draw(graphics);
        }
        for (ValueChangeHandler valueChangeHandler : this.vcHandlerMap.values()) {
            if (!(valueChangeHandler instanceof VisualFeedbackDrawer)) continue;
            ((VisualFeedbackDrawer)((Object)valueChangeHandler)).draw(graphics);
        }
    }

    public Object getValue(String key) {
        Object result = this.valueMap.get(key);
        if (result == null) {
            result = this.ihandler.getValue(key);
        }
        return result;
    }

    public void putValue(String key, Object newValue) {
        Object oldValue = this.valueMap.containsKey(key) && newValue == null ? this.valueMap.remove(key) : this.valueMap.put(key, newValue);
        this.firePropertyChange(key, oldValue, newValue);
    }

    private void firePropertyChange(String key, Object oldValue, Object newValue) {
        if (oldValue == newValue) {
            return;
        }
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, key, oldValue, newValue);
        for (MouseBehaviorHandler<?> mouseBehaviorHandler : this.handlerMap.values()) {
            if (!(mouseBehaviorHandler instanceof PropertyChangeListener)) continue;
            ((PropertyChangeListener)((Object)mouseBehaviorHandler)).propertyChange(propertyChangeEvent);
        }
        for (ValueChangeHandler valueChangeHandler : this.vcHandlerMap.values()) {
            valueChangeHandler.propertyChange(propertyChangeEvent);
        }
    }

    public void modeEntered() {
        Object oldValue = this.valueMap.get(MODE_ENTERED_KEY);
        this.firePropertyChange(MODE_ENTERED_KEY, oldValue, Boolean.TRUE);
    }

    public void modeExited() {
        Object oldValue = this.valueMap.get(MODE_ENTERED_KEY);
        this.firePropertyChange(MODE_ENTERED_KEY, oldValue, Boolean.FALSE);
    }

    public String toString() {
        return this.imode.getName() + " handler";
    }
}

