/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.image;

import java.awt.Dimension;
import org.jplot2d.data.ImageDataBuffer;
import org.jplot2d.image.LimitsCalculator;

public class MinMaxCalculator
implements LimitsCalculator {
    @Override
    public double[] calcLimits(ImageDataBuffer[] dbufs, Dimension[] sizeArray) {
        return MinMaxCalculator.calcMinMax(dbufs, sizeArray);
    }

    public static double[] calcMinMax(ImageDataBuffer[] dbufs, Dimension[] sizeArray) {
        double min = Double.NaN;
        double max = Double.NaN;
        for (int i = 0; i < dbufs.length; ++i) {
            ImageDataBuffer dbuf = dbufs[i];
            Dimension size = sizeArray[i];
            double[] minmax = null;
            minmax = dbuf.calcMinMax(size.width, size.height);
            if (minmax == null) continue;
            double dmin = minmax[0];
            double dmax = minmax[1];
            if (Double.isNaN(min) || Double.isNaN(max)) {
                min = dmin;
                max = dmax;
                continue;
            }
            if (min > dmin) {
                min = dmin;
            }
            if (!(max < dmax)) continue;
            max = dmax;
        }
        if (Double.isNaN(min) || Double.isNaN(max)) {
            return null;
        }
        return new double[]{min, max};
    }
}

