/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.env;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jplot2d.element.Element;
import org.jplot2d.element.PComponent;
import org.jplot2d.element.Plot;
import org.jplot2d.element.impl.ComponentEx;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.IntermediateCacheEx;
import org.jplot2d.element.impl.PlotEx;
import org.jplot2d.env.DummyEnvironment;
import org.jplot2d.env.ElementAddition;
import org.jplot2d.env.ElementChangeEvent;
import org.jplot2d.env.ElementChangeListener;
import org.jplot2d.env.ElementIH;
import org.jplot2d.env.Environment;
import org.jplot2d.env.UndoManager;
import org.jplot2d.env.UndoMemento;
import org.jplot2d.notice.LoggingNotifier;
import org.jplot2d.notice.Notifier;
import org.jplot2d.renderer.CacheableBlock;
import org.jplot2d.transform.PaperTransform;

public class PlotEnvironment
extends Environment {
    private List<Object> cacheHolders;
    protected Map<ElementEx, ElementEx> copyMap = new HashMap<ElementEx, ElementEx>();
    protected Map<ElementEx, Element> copyProxyMap;
    protected final UndoManager<UndoMemento> undoManager = new UndoManager(Integer.MAX_VALUE);
    protected final List<CacheableBlock> cacheBlockList = new ArrayList<CacheableBlock>();
    protected volatile Plot plot;
    protected PlotEx plotImpl;
    protected PlotEx plotCopy;

    public PlotEnvironment(boolean threadSafe) {
        super(threadSafe);
    }

    public void setPlot(Plot plot) {
        this.setPlot(plot, LoggingNotifier.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlot(Plot plot, Notifier notifier) {
        Environment oldEnv;
        Object object = PlotEnvironment.getGlobalLock();
        synchronized (object) {
            oldEnv = plot.getEnvironment();
            if (!(oldEnv instanceof DummyEnvironment)) {
                throw new IllegalArgumentException("The plot to be added has been added a PlotEnvironment");
            }
            this.beginCommand("setPlot");
            if (this.plot != null) {
                this.endCommand();
                throw new IllegalArgumentException("This Environment has hosted a plot");
            }
            oldEnv.beginCommand("setPlot");
            for (Element proxy : oldEnv.proxyMap.values()) {
                ((ElementAddition)((Object)proxy)).setEnvironment(this);
            }
        }
        this.plot = plot;
        this.plotImpl = (PlotEx)((ElementAddition)((Object)plot)).getImpl();
        this.componentAdded(this.plotImpl, oldEnv);
        this.notifier = notifier;
        this.plotImpl.setNotifier(notifier);
        this.plotImpl.setRerenderNeeded(true);
        oldEnv.endCommand();
        this.endCommand();
    }

    public Plot getPlot() {
        return this.plot;
    }

    public Notifier getNotifier() {
        Notifier result = null;
        this.begin();
        result = this.notifier;
        this.end();
        return result;
    }

    public void setNotifier(Notifier notifier) {
        this.begin();
        this.notifier = notifier;
        this.plotImpl.setNotifier(notifier);
        this.end();
    }

    @Override
    protected void commit() {
        this.plotImpl.commit();
        this.fireChangeProcessed();
        ArrayList<Object> holders = new ArrayList<Object>();
        for (ElementEx element : this.proxyMap.keySet()) {
            Object cacheHolder;
            if (!(element instanceof IntermediateCacheEx) || (cacheHolder = ((IntermediateCacheEx)((Object)element)).createCacheHolder()) == null) continue;
            holders.add(cacheHolder);
        }
        this.cacheHolders = holders;
        this.makeUndoMemento();
        this.buildComponentCacheBlock();
        this.render();
    }

    protected void render() {
    }

    protected void fireChangeProcessed() {
        ElementChangeListener[] ls = this.getElementChangeListeners();
        if (ls.length > 0) {
            ElementChangeEvent evt = new ElementChangeEvent(this, null);
            for (ElementChangeListener lsnr : ls) {
                lsnr.propertyChangesProcessed(evt);
            }
        }
    }

    protected void buildComponentCacheBlock() {
        ArrayList<ComponentEx> cacheableComponentList = new ArrayList<ComponentEx>();
        HashMap<ComponentEx, ArrayList<ComponentEx>> subcompsMap = new HashMap<ComponentEx, ArrayList<ComponentEx>>();
        this.cacheBlockList.clear();
        for (ElementEx element : this.proxyMap.keySet()) {
            ComponentEx cacheableAncestor;
            ComponentEx comp;
            ComponentEx copy;
            if (!(element instanceof ComponentEx) || !PlotEnvironment.isShowing(copy = (ComponentEx)this.copyMap.get(comp = (ComponentEx)element))) continue;
            if (comp.isCacheable() || comp == this.plotImpl) {
                cacheableComponentList.add((ComponentEx)element);
                cacheableAncestor = copy;
            } else {
                cacheableAncestor = PlotEnvironment.getCacheableAncestor(copy);
            }
            ArrayList<ComponentEx> subComps = (ArrayList<ComponentEx>)subcompsMap.get(cacheableAncestor);
            if (subComps == null) {
                subComps = new ArrayList<ComponentEx>();
                subcompsMap.put(cacheableAncestor, subComps);
            }
            subComps.add(copy);
        }
        PlotEnvironment.updateOrder(cacheableComponentList);
        for (ComponentEx comp : cacheableComponentList) {
            ComponentEx copy = (ComponentEx)this.copyMap.get(comp);
            List subcomps = (List)subcompsMap.get(copy);
            PlotEnvironment.updateOrder(subcomps);
            CacheableBlock cb = new CacheableBlock(comp, copy, subcomps);
            this.cacheBlockList.add(cb);
        }
    }

    protected static void updateOrder(List<ComponentEx> list) {
        ComponentEx[] comps = list.toArray(new ComponentEx[list.size()]);
        Comparator<PComponent> zComparator = new Comparator<PComponent>(){

            @Override
            public int compare(PComponent o1, PComponent o2) {
                return o1.getZOrder() - o2.getZOrder();
            }
        };
        Arrays.sort(comps, zComparator);
        list.clear();
        for (ComponentEx comp : comps) {
            list.add(comp);
        }
    }

    private static boolean isShowing(ComponentEx comp) {
        if (!comp.isVisible()) {
            return false;
        }
        if (comp.getParent() != null) {
            return PlotEnvironment.isShowing(comp.getParent());
        }
        return true;
    }

    private void makeUndoMemento() {
        this.copyMap.clear();
        this.plotCopy = this.plotImpl.copyStructure(this.copyMap);
        for (Map.Entry<ElementEx, ElementEx> entry : this.copyMap.entrySet()) {
            entry.getValue().copyFrom(entry.getKey());
        }
        if (this.undoManager.getCapacity() > 0) {
            this.copyProxyMap = new LinkedHashMap<ElementEx, Element>();
            for (Map.Entry<ElementEx, ElementEx> entry : this.proxyMap.entrySet()) {
                Element element = entry.getKey();
                Element proxy = entry.getValue();
                ElementEx copye = this.copyMap.get(element);
                this.copyProxyMap.put(copye, proxy);
            }
            this.undoManager.add(new UndoMemento(this.plotCopy, this.copyProxyMap));
        }
    }

    public int getUndoLevels() {
        this.begin();
        int capacity = this.undoManager.getCapacity();
        this.end();
        return capacity;
    }

    public void setUndoLevels(int levels) {
        this.begin();
        this.undoManager.setCapacity(levels);
        this.end();
    }

    public boolean canUndo() {
        this.begin();
        boolean b = this.undoManager.canUndo();
        this.end();
        return b;
    }

    public boolean canRedo() {
        this.begin();
        boolean b = this.undoManager.canRedo();
        this.end();
        return b;
    }

    public void undo() {
        this.begin();
        UndoMemento memento = this.undoManager.undo();
        if (memento == null) {
            throw new RuntimeException("Cannot undo");
        }
        this.restore(memento);
        this.buildComponentCacheBlock();
        this.plotImpl.setRerenderNeeded(false);
        this.render();
        this.end();
    }

    public void redo() {
        this.begin();
        UndoMemento memento = this.undoManager.redo();
        if (memento == null) {
            throw new RuntimeException("Cannot redo");
        }
        this.restore(memento);
        this.buildComponentCacheBlock();
        this.plotImpl.setRerenderNeeded(false);
        this.render();
        this.end();
    }

    private void restore(UndoMemento memento) {
        this.copyMap.clear();
        HashMap<ElementEx, ElementEx> rcopyMap = new HashMap<ElementEx, ElementEx>();
        this.plotCopy = memento.getPlot();
        this.plotImpl = this.plotCopy.copyStructure(rcopyMap);
        this.plotImpl.setNotifier(this.notifier);
        this.proxyMap.clear();
        this.copyProxyMap = memento.getProxyMap();
        for (Map.Entry<ElementEx, Element> me : this.copyProxyMap.entrySet()) {
            ElementEx mmte = me.getKey();
            Element proxy = me.getValue();
            ElementEx impl = (ElementEx)rcopyMap.get(mmte);
            impl.copyFrom(mmte);
            ElementIH ih = (ElementIH)Proxy.getInvocationHandler(proxy);
            ih.replaceImpl(impl);
            this.proxyMap.put(impl, proxy);
            this.copyMap.put(impl, mmte);
        }
    }

    public PComponent getSelectableCompnentAt(Point2D dp) {
        PComponent result = null;
        this.begin();
        block0: for (int i = this.cacheBlockList.size() - 1; i >= 0; --i) {
            List<ComponentEx> uccList = this.cacheBlockList.get(i).getSubcomps();
            for (int j = uccList.size() - 1; j >= 0; --j) {
                ComponentEx ucc = uccList.get(j);
                if (!ucc.isSelectable()) continue;
                PaperTransform pxf = ucc.getPaperTransform();
                Rectangle2D sbnd = ucc.getSelectableBounds();
                if (pxf == null || sbnd == null || !sbnd.contains(pxf.getDtoP(dp))) continue;
                result = (PComponent)this.copyProxyMap.get(ucc);
                continue block0;
            }
        }
        this.end();
        return result;
    }

    public Plot getPlotAt(Point2D dp) {
        Plot result = null;
        this.begin();
        block0: for (int i = this.cacheBlockList.size() - 1; i >= 0; --i) {
            List<ComponentEx> uccList = this.cacheBlockList.get(i).getSubcomps();
            for (int j = uccList.size() - 1; j >= 0; --j) {
                ComponentEx ucc = uccList.get(j);
                if (!(ucc instanceof PlotEx)) continue;
                Point2D p = ucc.getPaperTransform().getDtoP(dp);
                if (!ucc.getBounds().contains(p)) continue;
                result = (Plot)this.copyProxyMap.get(ucc);
                continue block0;
            }
        }
        this.end();
        return result;
    }
}

