/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.env;

import java.beans.IntrospectionException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jplot2d.annotation.Hierarchy;
import org.jplot2d.annotation.HierarchyOp;
import org.jplot2d.annotation.Property;
import org.jplot2d.annotation.PropertyGroup;
import org.jplot2d.env.PropertyInfo;

public class InterfaceInfo {
    private static final String IS_PREFIX = "is";
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static Map<Class<?>, InterfaceInfo> interfaceInfoCache = new HashMap();
    private final Map<String, PropertyInfo> piMap;
    private final Map<Method, PropertyInfo> propReadMap = new HashMap<Method, PropertyInfo>();
    private final Map<Method, PropertyInfo> propWriteMap = new HashMap<Method, PropertyInfo>();
    private final Collection<Method> listenerGarMethods = new HashSet<Method>();
    private final Map<Method, HierarchyOp> hierachyMethodMap = new HashMap<Method, HierarchyOp>();
    private final Map<String, PropertyInfo[]> pisGroupMap = new LinkedHashMap<String, PropertyInfo[]>();

    public static synchronized InterfaceInfo loadInterfaceInfo(Class<?> interfaceClass) {
        InterfaceInfo iinfo = interfaceInfoCache.get(interfaceClass);
        if (iinfo == null) {
            iinfo = new InterfaceInfo(interfaceClass);
            interfaceInfoCache.put(interfaceClass, iinfo);
        }
        return iinfo;
    }

    private InterfaceInfo(Class<?> interfaceClass) {
        Method[] methods = interfaceClass.getMethods();
        try {
            this.piMap = InterfaceInfo.getPropertyInfo(methods);
        }
        catch (IntrospectionException e) {
            throw new Error(e);
        }
        this.loadGroup(interfaceClass);
        this.load(interfaceClass);
        for (Method method : methods) {
            Hierarchy hierAnn = method.getAnnotation(Hierarchy.class);
            if (hierAnn == null) continue;
            this.hierachyMethodMap.put(method, hierAnn.value());
        }
    }

    private void loadGroup(Class<?> interfaceClass) {
        for (Class<?> superClass : interfaceClass.getInterfaces()) {
            this.loadGroup(superClass);
        }
        PropertyGroup pg = interfaceClass.getAnnotation(PropertyGroup.class);
        if (pg != null) {
            this.pisGroupMap.put(pg.value(), null);
        }
    }

    private void load(Class<?> beanClass) {
        HashMap<String, ArrayList<PropertyInfo>> pilGroupMap = new HashMap<String, ArrayList<PropertyInfo>>();
        for (PropertyInfo p : this.piMap.values()) {
            Method readMethod = p.getReadMethod();
            Method writeMethod = p.getWriteMethod();
            if (readMethod == null) continue;
            Property pann = readMethod.getAnnotation(Property.class);
            if (pann != null) {
                p.setDisplayName(pann.displayName());
                p.setDisplayDigits(pann.displayDigits());
                p.setShortDescription(pann.description());
                p.setReadOnly(pann.readOnly());
                p.setOrder(pann.order());
                p.setStyleable(pann.styleable() && writeMethod != null);
                PropertyGroup pg = readMethod.getDeclaringClass().getAnnotation(PropertyGroup.class);
                if (pg != null) {
                    ArrayList<PropertyInfo> pis = (ArrayList<PropertyInfo>)pilGroupMap.get(pg.value());
                    if (pis == null) {
                        pis = new ArrayList<PropertyInfo>();
                        pilGroupMap.put(pg.value(), pis);
                    }
                    pis.add(p);
                }
            }
            this.propReadMap.put(readMethod, p);
            if (writeMethod == null) continue;
            this.propWriteMap.put(writeMethod, p);
        }
        Iterator<Map.Entry<String, PropertyInfo[]>> itr = this.pisGroupMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, PropertyInfo[]> me = itr.next();
            List gpdList = (List)pilGroupMap.get(me.getKey());
            if (gpdList != null) {
                Object[] gpds = gpdList.toArray(new PropertyInfo[gpdList.size()]);
                Arrays.sort(gpds);
                me.setValue((PropertyInfo[])gpds);
                continue;
            }
            itr.remove();
        }
    }

    public PropertyInfo getPropertyInfo(String pname) {
        return this.piMap.get(pname);
    }

    public Map<String, PropertyInfo[]> getPropertyInfoGroupMap() {
        return this.pisGroupMap;
    }

    public Map<String, PropertyInfo[]> getProfilePropertyInfoGroupMap() {
        LinkedHashMap<String, PropertyInfo[]> result = new LinkedHashMap<String, PropertyInfo[]>();
        for (Map.Entry<String, PropertyInfo[]> me : this.pisGroupMap.entrySet()) {
            String group = me.getKey();
            ArrayList<PropertyInfo> ppl = new ArrayList<PropertyInfo>();
            for (PropertyInfo pi : me.getValue()) {
                if (!pi.isStyleable()) continue;
                ppl.add(pi);
            }
            if (ppl.size() <= 0) continue;
            PropertyInfo[] pps = ppl.toArray(new PropertyInfo[ppl.size()]);
            result.put(group, pps);
        }
        return result;
    }

    public boolean isWritableProp(String pname) {
        if (this.piMap.containsKey(pname)) {
            return this.piMap.get(pname).getWriteMethod() != null;
        }
        return false;
    }

    protected boolean isPropReadMethod(Method method) {
        return this.propReadMap.containsKey(method);
    }

    protected boolean isPropWriteMethod(Method method) {
        return this.propWriteMap.containsKey(method);
    }

    protected boolean isPropWriteDisabled(Method method) {
        PropertyInfo pinfo = this.propWriteMap.get(method);
        if (pinfo == null) {
            throw new IllegalArgumentException("The method " + method.getName() + " is not a property writter.");
        }
        return pinfo.isReadOnly();
    }

    protected Method getPropReadMethodByWriteMethod(Method method) {
        PropertyInfo pinfo = this.propWriteMap.get(method);
        if (pinfo == null) {
            throw new IllegalArgumentException("The method " + method.getName() + " is not a property writter.");
        }
        return pinfo.getReadMethod();
    }

    protected boolean isListenerMethod(Method method) {
        return this.listenerGarMethods.contains(method);
    }

    protected boolean isGetCompMethod(Method method) {
        HierarchyOp hop = this.hierachyMethodMap.get(method);
        return hop != null && hop == HierarchyOp.GET;
    }

    protected boolean isGetCompArrayMethod(Method method) {
        HierarchyOp hop = this.hierachyMethodMap.get(method);
        return hop != null && hop == HierarchyOp.GETARRAY;
    }

    protected boolean isAddCompMethod(Method method) {
        HierarchyOp hop = this.hierachyMethodMap.get(method);
        return hop != null && hop == HierarchyOp.ADD;
    }

    protected boolean isRemoveCompMethod(Method method) {
        HierarchyOp hop = this.hierachyMethodMap.get(method);
        return hop != null && hop == HierarchyOp.REMOVE;
    }

    protected boolean isJoinElementMethod(Method method) {
        HierarchyOp hop = this.hierachyMethodMap.get(method);
        return hop != null && hop == HierarchyOp.JOIN;
    }

    protected boolean isRefElementMethod(Method method) {
        HierarchyOp hop = this.hierachyMethodMap.get(method);
        return hop != null && hop == HierarchyOp.REF;
    }

    protected boolean isRef2ElementMethod(Method method) {
        HierarchyOp hop = this.hierachyMethodMap.get(method);
        return hop != null && hop == HierarchyOp.REF2;
    }

    protected boolean isAddRef2Method(Method method) {
        HierarchyOp hop = this.hierachyMethodMap.get(method);
        return hop != null && hop == HierarchyOp.ADD_REF2;
    }

    private static Map<String, PropertyInfo> getPropertyInfo(Method[] methods) throws IntrospectionException {
        LinkedHashMap<String, Method> pdReaderMap = new LinkedHashMap<String, Method>();
        HashMap<String, Method> pdWriterMap = new HashMap<String, Method>();
        for (int i = 0; i < methods.length; ++i) {
            String pname;
            String name;
            int mods;
            Method method = methods[i];
            if (method == null || Modifier.isStatic(mods = method.getModifiers()) || (name = method.getName()).length() <= 3 && !name.startsWith(IS_PREFIX)) continue;
            Class<?>[] argTypes = method.getParameterTypes();
            Class<?> resultType = method.getReturnType();
            int argCount = argTypes.length;
            if (argCount == 0) {
                pname = null;
                if (name.startsWith(GET_PREFIX)) {
                    pname = InterfaceInfo.decapitalize(name.substring(3));
                } else if (resultType == Boolean.TYPE && name.startsWith(IS_PREFIX)) {
                    pname = InterfaceInfo.decapitalize(name.substring(2));
                }
                if (pname == null) continue;
                Method pre = (Method)pdReaderMap.get(pname);
                if (pre == null) {
                    pdReaderMap.put(pname, method);
                    continue;
                }
                if (pre.getReturnType().isAssignableFrom(method.getReturnType())) {
                    pdReaderMap.put(pname, method);
                    continue;
                }
                if (method.getReturnType().isAssignableFrom(pre.getReturnType())) continue;
                throw new IntrospectionException("getter name conflict: " + name);
            }
            if (argCount != 1 || resultType != Void.TYPE || !name.startsWith(SET_PREFIX)) continue;
            pname = InterfaceInfo.decapitalize(name.substring(3));
            if (pdWriterMap.containsKey(pname)) {
                throw new IntrospectionException("setter name conflict: " + name);
            }
            pdWriterMap.put(pname, method);
        }
        HashMap<String, PropertyInfo> pimap = new HashMap<String, PropertyInfo>();
        for (Map.Entry me : pdReaderMap.entrySet()) {
            String pname = (String)me.getKey();
            Method reader = (Method)me.getValue();
            Method writer = (Method)pdWriterMap.get(pname);
            PropertyInfo pd = new PropertyInfo(pname, reader, writer);
            pimap.put(pname, pd);
        }
        return pimap;
    }

    private static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }
}

