/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.env;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.jplot2d.element.Element;
import org.jplot2d.element.PComponent;
import org.jplot2d.element.impl.ComponentEx;
import org.jplot2d.element.impl.ContainerEx;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.env.BatchToken;
import org.jplot2d.env.CommandLogger;
import org.jplot2d.env.DummyEnvironment;
import org.jplot2d.env.ElementChangeEvent;
import org.jplot2d.env.ElementChangeListener;
import org.jplot2d.notice.NoticeType;
import org.jplot2d.notice.Notifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Environment {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.jplot2d.env");
    private static final Object LOCK = new Object();
    private static final int MAX_BATCH_DEPTH = 64;
    private final ReentrantLock lock;
    private int[] batchSND = new int[64];
    private int batchDepth;
    protected CommandLogger cmdLogger;
    protected Notifier notifier;
    protected final Map<ElementEx, Element> proxyMap = new LinkedHashMap<ElementEx, Element>();
    private final List<ElementChangeListener> plotStructureListenerList = Collections.synchronizedList(new ArrayList());

    protected static Object getGlobalLock() {
        return LOCK;
    }

    protected static boolean isAncestor(Element a, Element c) {
        if (c == null) {
            return false;
        }
        if (c == a) {
            return true;
        }
        return Environment.isAncestor(a, c.getParent());
    }

    protected static final ComponentEx getCacheableAncestor(ComponentEx comp) {
        if (comp.isCacheable()) {
            return comp;
        }
        ContainerEx parent = comp.getParent();
        if (parent == null) {
            return comp;
        }
        return Environment.getCacheableAncestor(parent);
    }

    protected Environment(boolean threadSafe) {
        this.lock = threadSafe ? new ReentrantLock() : null;
    }

    public final Element getProxy(ElementEx impl) {
        return this.proxyMap.get(impl);
    }

    void elementAdded(ElementEx element, Environment env) {
        this.proxyMap.putAll(env.proxyMap);
        env.proxyMap.clear();
    }

    void componentAdded(ComponentEx comp, Environment env) {
        this.proxyMap.putAll(env.proxyMap);
        env.proxyMap.clear();
        this.fireComponentAdded((PComponent)this.getProxy(comp));
    }

    void componentRemoving(ComponentEx comp) {
        this.fireComponentRemoving((PComponent)this.getProxy(comp));
    }

    DummyEnvironment componentRemoved(ElementEx comp) {
        DummyEnvironment result = this.createDummyEnvironment();
        Iterator<Map.Entry<ElementEx, Element>> ite = this.proxyMap.entrySet().iterator();
        while (ite.hasNext()) {
            Map.Entry<ElementEx, Element> e = ite.next();
            if (!Environment.isAncestor(comp, e.getKey())) continue;
            result.proxyMap.put(e.getKey(), e.getValue());
            ite.remove();
        }
        this.fireComponentRemoved((PComponent)this.getProxy(comp));
        return result;
    }

    void elementPropertyChanged(ElementEx comp) {
        this.fireElementPropertyChanged(this.getProxy(comp));
    }

    private void fireComponentAdded(PComponent element) {
        ElementChangeListener[] ls = this.getElementChangeListeners();
        if (ls.length > 0) {
            ElementChangeEvent evt = new ElementChangeEvent(this, element);
            for (ElementChangeListener lsnr : ls) {
                lsnr.componentAdded(evt);
            }
        }
    }

    private void fireComponentRemoving(PComponent element) {
        ElementChangeListener[] ls = this.getElementChangeListeners();
        if (ls.length > 0) {
            ElementChangeEvent evt = new ElementChangeEvent(this, element);
            for (ElementChangeListener lsnr : ls) {
                lsnr.componentRemoving(evt);
            }
        }
    }

    private void fireComponentRemoved(PComponent element) {
        ElementChangeListener[] ls = this.getElementChangeListeners();
        if (ls.length > 0) {
            ElementChangeEvent evt = new ElementChangeEvent(this, element);
            for (ElementChangeListener lsnr : ls) {
                lsnr.componentRemoved(evt);
            }
        }
    }

    private void fireElementPropertyChanged(Element element) {
        ElementChangeListener[] ls = this.getElementChangeListeners();
        if (ls.length > 0) {
            ElementChangeEvent evt = new ElementChangeEvent(this, element);
            for (ElementChangeListener lsnr : ls) {
                lsnr.propertiesChanged(evt);
            }
        }
    }

    public ElementChangeListener[] getElementChangeListeners() {
        return this.plotStructureListenerList.toArray(new ElementChangeListener[0]);
    }

    public void addElementChangeListener(ElementChangeListener listener) {
        this.plotStructureListenerList.add(listener);
    }

    public void removeElementChangeListener(ElementChangeListener listener) {
        this.plotStructureListenerList.remove(listener);
    }

    public CommandLogger getCommandLogger() {
        return this.cmdLogger;
    }

    public void setCommandLogger(CommandLogger cmdLogger) {
        this.cmdLogger = cmdLogger;
    }

    protected DummyEnvironment createDummyEnvironment() {
        return new DummyEnvironment(this.lock != null);
    }

    private String getBatchString() {
        if (this.batchDepth == 0) {
            throw new Error("Not in batch block.");
        }
        String result = "(" + this.batchSND[0];
        for (int i = 1; i < this.batchDepth; ++i) {
            result = result + "-" + this.batchSND[i];
        }
        return result + ")";
    }

    private BatchToken createBatchToken() {
        return new BatchToken(this.batchDepth, this.batchSND);
    }

    private boolean verifyBatchToken(BatchToken token) {
        return token.match(this.batchDepth, this.batchSND);
    }

    public final BatchToken beginBatch(String msg) {
        this.beginCommand(msg);
        return this.createBatchToken();
    }

    public final void endBatch(BatchToken token) {
        this.endBatch(token, null);
    }

    public final void endBatch(BatchToken token, NoticeType type) {
        this.begin();
        if (!this.verifyBatchToken(token)) {
            throw new IllegalArgumentException("Batch token not match. Require " + this.getBatchString() + " but is " + token);
        }
        this.endCommand(type);
        this.end();
    }

    protected final boolean isBatch() {
        return this.batchDepth > 0;
    }

    protected final void beginCommand(String msg) {
        this.begin();
        int n = this.batchDepth++;
        this.batchSND[n] = this.batchSND[n] + 1;
        this.batchSND[this.batchDepth] = 0;
        logger.trace("[>] {}{} {}", new Object[]{Integer.toHexString(this.hashCode()), this.getBatchString(), msg});
    }

    protected final void endCommand() {
        this.endCommand(null);
    }

    private void endCommand(NoticeType type) {
        logger.trace("[<] {}{}", (Object)Integer.toHexString(this.hashCode()), (Object)this.getBatchString());
        if (this.batchDepth == 1) {
            try {
                this.commit();
            }
            catch (Exception e) {
                logger.warn("", (Throwable)e);
            }
            if (this.notifier != null) {
                try {
                    this.notifier.processNotices(type);
                }
                catch (Exception e) {
                    logger.warn("", (Throwable)e);
                }
            }
        }
        --this.batchDepth;
        this.end();
    }

    protected final void begin() {
        if (this.lock != null) {
            this.lock.lock();
        }
    }

    protected final void end() {
        if (this.lock != null) {
            this.lock.unlock();
        }
    }

    protected abstract void commit();
}

