/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Method;
import org.jplot2d.element.HAlign;
import org.jplot2d.element.Plot;
import org.jplot2d.element.TitlePosition;
import org.jplot2d.element.VAlign;
import org.jplot2d.element.impl.ComponentImpl;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.InvokeStep;
import org.jplot2d.element.impl.PlotEx;
import org.jplot2d.element.impl.TitleEx;
import org.jplot2d.tex.MathElement;
import org.jplot2d.tex.MathLabel;
import org.jplot2d.tex.TeXMathUtils;
import org.jplot2d.util.DoubleDimension2D;

public class TitleImpl
extends ComponentImpl
implements TitleEx {
    private TitlePosition position = TitlePosition.TOPCENTER;
    private double locX;
    private double locY;
    private MathElement textModel;
    private HAlign hAlign = HAlign.CENTER;
    private VAlign vAlign = VAlign.BOTTOM;
    private MathLabel label;
    private double gapFactor = 0.25;

    public TitleImpl() {
        this.setSelectable(true);
    }

    @Override
    public String getId() {
        if (this.getParent() != null) {
            return "Title" + this.getParent().indexOf(this);
        }
        return "Title@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public InvokeStep getInvokeStepFormParent() {
        Method method;
        if (this.parent == null) {
            return null;
        }
        try {
            method = Plot.class.getMethod("getTitle", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
        return new InvokeStep(method, this.getParent().indexOf(this));
    }

    @Override
    public PlotEx getParent() {
        return (PlotEx)super.getParent();
    }

    @Override
    public boolean canContribute() {
        return this.textModel != null && this.textModel != MathElement.EMPTY;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.textModel != null && this.getPosition() != TitlePosition.FREE && this.getParent() != null) {
            this.getParent().invalidate();
        }
    }

    @Override
    public Point2D getLocation() {
        return new Point2D.Double(this.locX, this.locY);
    }

    @Override
    public final void setLocation(Point2D p) {
        this.setLocation(p.getX(), p.getY());
    }

    @Override
    public void setLocation(double locX, double locY) {
        if (this.getLocation().getX() != locX || this.getLocation().getY() != locY) {
            this.locX = locX;
            this.locY = locY;
        }
    }

    @Override
    public void thisEffectiveColorChanged() {
        TitleImpl.redraw(this);
    }

    @Override
    public void thisEffectiveFontChanged() {
        this.label = null;
        TitleImpl.redraw(this);
    }

    @Override
    public String getText() {
        return TeXMathUtils.toString(this.textModel);
    }

    @Override
    public void setText(String text) {
        this.setTextModel(TeXMathUtils.parseText(text));
    }

    public MathElement getTextModel() {
        return this.textModel;
    }

    public void setTextModel(MathElement model) {
        TitleImpl.redraw(this);
        this.textModel = model;
        this.label = null;
        TitleImpl.redraw(this);
    }

    @Override
    public HAlign getHAlign() {
        return this.hAlign;
    }

    @Override
    public void setHAlign(HAlign hAlign) {
        if (this.hAlign != hAlign) {
            this.hAlign = hAlign;
            this.label = null;
            TitleImpl.redraw(this);
        }
    }

    @Override
    public VAlign getVAlign() {
        return this.vAlign;
    }

    @Override
    public void setVAlign(VAlign vAlign) {
        if (this.vAlign != vAlign) {
            this.vAlign = vAlign;
            this.label = null;
            TitleImpl.redraw(this);
        }
    }

    @Override
    public Dimension2D getSize() {
        Rectangle2D bounds = this.getBounds();
        if (bounds == null) {
            return null;
        }
        return new DoubleDimension2D(bounds.getWidth(), bounds.getHeight());
    }

    @Override
    public TitlePosition getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(TitlePosition position) {
        if (position == null) {
            position = TitlePosition.FREE;
        }
        if (this.position != position) {
            this.position = position;
            this.invalidatePlot();
        }
    }

    @Override
    public double getGapFactor() {
        return this.gapFactor;
    }

    @Override
    public void setGapFactor(double factor) {
        this.gapFactor = factor;
        this.invalidatePlot();
    }

    private void invalidatePlot() {
        if (this.isVisible() && this.canContribute() && this.getParent() != null) {
            this.getParent().invalidate();
        }
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.label == null) {
            return null;
        }
        return this.label.getBounds();
    }

    @Override
    public void calcSize() {
        if (this.label == null) {
            this.label = new MathLabel(this.getTextModel(), this.getEffectiveFont(), this.getVAlign(), this.getHAlign());
        }
    }

    @Override
    public void copyFrom(ElementEx src) {
        super.copyFrom(src);
        TitleImpl tc = (TitleImpl)src;
        this.locX = tc.locX;
        this.locY = tc.locY;
        this.textModel = tc.textModel;
        this.hAlign = tc.hAlign;
        this.vAlign = tc.vAlign;
        this.label = tc.label;
        this.position = tc.position;
        this.gapFactor = tc.gapFactor;
    }

    @Override
    public void draw(Graphics2D g) {
        if (!this.canContribute()) {
            return;
        }
        if (this.label == null) {
            this.label = new MathLabel(this.getTextModel(), this.getEffectiveFont(), this.getVAlign(), this.getHAlign());
        }
        AffineTransform oldTransform = g.getTransform();
        g.transform(this.getParent().getPaperTransform().getTransform());
        g.translate(this.getLocation().getX(), this.getLocation().getY());
        g.scale(1.0, -1.0);
        g.setColor(this.getEffectiveColor());
        this.label.draw(g);
        g.setTransform(oldTransform);
    }
}

