/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.Dimension;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jplot2d.data.ImageDataBuffer;
import org.jplot2d.data.MultiBandImageData;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.ElementImpl;
import org.jplot2d.element.impl.ImageBandTransformEx;
import org.jplot2d.element.impl.ImageBandTransformImpl;
import org.jplot2d.element.impl.ImageGraphEx;
import org.jplot2d.element.impl.InvokeStep;
import org.jplot2d.element.impl.RGBImageGraphEx;
import org.jplot2d.element.impl.RGBImageMappingEx;

public class RGBImageMappingImpl
extends ElementImpl
implements RGBImageMappingEx {
    private final List<RGBImageGraphEx> graphs = new ArrayList<RGBImageGraphEx>();
    private final ImageBandTransformEx redTransform;
    private final ImageBandTransformEx greenTransform;
    private final ImageBandTransformEx blueTransform;

    public RGBImageMappingImpl() {
        this.redTransform = new ImageBandTransformImpl();
        this.greenTransform = new ImageBandTransformImpl();
        this.blueTransform = new ImageBandTransformImpl();
        this.redTransform.setParent(this);
        this.greenTransform.setParent(this);
        this.blueTransform.setParent(this);
    }

    public RGBImageMappingImpl(ImageBandTransformEx redTransform, ImageBandTransformEx greenTransform, ImageBandTransformEx blueTransform) {
        this.redTransform = redTransform;
        this.greenTransform = greenTransform;
        this.blueTransform = blueTransform;
        redTransform.setParent(this);
        greenTransform.setParent(this);
        blueTransform.setParent(this);
    }

    @Override
    public RGBImageGraphEx getParent() {
        return (RGBImageGraphEx)this.parent;
    }

    @Override
    public String getId() {
        StringBuilder sb = new StringBuilder();
        sb.append("RGBImageMapping(");
        for (RGBImageGraphEx graph : this.graphs) {
            sb.append(graph.getId()).append(',');
        }
        sb.replace(sb.length() - 1, sb.length(), ")");
        return sb.toString();
    }

    @Override
    public String getFullId() {
        return "RGBImageMapping@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public InvokeStep getInvokeStepFormParent() {
        Method method;
        if (this.graphs.size() == 0) {
            return null;
        }
        try {
            method = ImageGraphEx.class.getMethod("getMapping", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
        return new InvokeStep(method);
    }

    @Override
    public RGBImageGraphEx[] getGraphs() {
        return this.graphs.toArray(new RGBImageGraphEx[this.graphs.size()]);
    }

    @Override
    public void addImageGraph(RGBImageGraphEx graph) {
        this.graphs.add(graph);
        this.parent = this.graphs.size() == 1 ? (ElementEx)this.graphs.get(0) : null;
    }

    @Override
    public void removeImageGraph(RGBImageGraphEx graph) {
        this.graphs.remove(graph);
        this.parent = this.graphs.size() == 1 ? (ElementEx)this.graphs.get(0) : null;
    }

    @Override
    public ImageBandTransformEx getRedTransform() {
        return this.redTransform;
    }

    @Override
    public ImageBandTransformEx getGreenTransform() {
        return this.greenTransform;
    }

    @Override
    public ImageBandTransformEx getBlueTransform() {
        return this.blueTransform;
    }

    @Override
    public ElementEx copyStructure(Map<ElementEx, ElementEx> orig2copyMap) {
        ImageBandTransformEx redCopy = (ImageBandTransformEx)this.redTransform.copyStructure(orig2copyMap);
        ImageBandTransformEx greenCopy = (ImageBandTransformEx)this.greenTransform.copyStructure(orig2copyMap);
        ImageBandTransformEx blueCopy = (ImageBandTransformEx)this.blueTransform.copyStructure(orig2copyMap);
        RGBImageMappingImpl result = new RGBImageMappingImpl(redCopy, greenCopy, blueCopy);
        if (orig2copyMap != null) {
            orig2copyMap.put(this, result);
        }
        return result;
    }

    @Override
    public void calcLimits() {
        ImageDataBuffer[] redBuffers = new ImageDataBuffer[this.graphs.size()];
        ImageDataBuffer[] greenBuffers = new ImageDataBuffer[this.graphs.size()];
        ImageDataBuffer[] blueBuffers = new ImageDataBuffer[this.graphs.size()];
        Dimension[] sizeArray = new Dimension[this.graphs.size()];
        int n = 0;
        for (int i = 0; i < this.graphs.size(); ++i) {
            MultiBandImageData data = this.graphs.get(i).getData();
            if (data == null) continue;
            ImageDataBuffer[] dbBands = data.getDataBuffer();
            redBuffers[n] = dbBands[0];
            greenBuffers[n] = dbBands[1];
            blueBuffers[n] = dbBands[2];
            sizeArray[n] = new Dimension(data.getWidth(), data.getHeight());
            ++n;
        }
        if (n != this.graphs.size()) {
            redBuffers = Arrays.copyOf(redBuffers, n);
            greenBuffers = Arrays.copyOf(greenBuffers, n);
            blueBuffers = Arrays.copyOf(blueBuffers, n);
            sizeArray = Arrays.copyOf(sizeArray, n);
        }
        this.redTransform.calcLimits(redBuffers, sizeArray);
        this.greenTransform.calcLimits(greenBuffers, sizeArray);
        this.blueTransform.calcLimits(blueBuffers, sizeArray);
    }
}

