/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jplot2d.element.impl.AnnotationImpl;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.PointAnnotationEx;
import org.jplot2d.util.DoubleDimension2D;

public abstract class PointAnnotationImpl
extends AnnotationImpl
implements PointAnnotationEx {
    private double valueX;
    private double valueY;

    @Override
    public String getId() {
        if (this.getParent() != null) {
            return "PointAnnotation" + this.getParent().indexOf(this);
        }
        return "PointAnnotation@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public Point2D getLocation() {
        if (this.getParent() == null || this.getParent().getSize() == null || this.getParent().getXAxisTransform() == null || this.getParent().getYAxisTransform() == null) {
            return null;
        }
        double locX = this.getXWtoP(this.valueX);
        double locY = this.getYWtoP(this.valueY);
        return new Point2D.Double(locX, locY);
    }

    @Override
    public void setLocation(double locX, double locY) {
        Point2D loc = this.getLocation();
        if (loc != null && (loc.getX() != locX || loc.getY() != locY)) {
            this.setValuePoint(this.getXPtoW(locX), this.getYPtoW(locY));
        }
    }

    @Override
    public Dimension2D getSize() {
        Rectangle2D bounds = this.getBounds();
        return new DoubleDimension2D(bounds.getWidth(), bounds.getHeight());
    }

    @Override
    public void copyFrom(ElementEx src) {
        super.copyFrom(src);
        PointAnnotationImpl tc = (PointAnnotationImpl)src;
        this.valueX = tc.valueX;
        this.valueY = tc.valueY;
    }

    @Override
    public Point2D getValuePoint() {
        return new Point2D.Double(this.valueX, this.valueY);
    }

    @Override
    public void setValuePoint(Point2D point) {
        this.setValuePoint(point.getX(), point.getY());
    }

    @Override
    public void setValuePoint(double x, double y) {
        this.valueX = x;
        this.valueY = y;
        PointAnnotationImpl.redraw(this);
    }
}

