/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Method;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.ElementImpl;
import org.jplot2d.element.impl.InvokeStep;
import org.jplot2d.element.impl.LegendEx;
import org.jplot2d.element.impl.LegendItemEx;
import org.jplot2d.element.impl.XYGraphEx;

public abstract class LegendItemImpl
extends ElementImpl
implements LegendItemEx {
    private boolean visible = true;
    private double locX;
    private double locY;
    private LegendEx legend;

    @Override
    public String getId() {
        return "LegendItem";
    }

    @Override
    public InvokeStep getInvokeStepFormParent() {
        Method method;
        if (this.parent == null) {
            return null;
        }
        try {
            method = XYGraphEx.class.getMethod("getLegendItem", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
        return new InvokeStep(method);
    }

    @Override
    public XYGraphEx getParent() {
        return (XYGraphEx)super.getParent();
    }

    @Override
    public LegendEx getLegend() {
        return this.legend;
    }

    @Override
    public void setLegend(LegendEx legend) {
        this.legend = legend;
    }

    public Point2D getLocation() {
        return new Point2D.Double(this.locX, this.locY);
    }

    @Override
    public void setLocation(double locX, double locY) {
        this.locX = locX;
        this.locY = locY;
    }

    public Rectangle2D getBounds() {
        Dimension2D size = this.getSize();
        return new Rectangle2D.Double(this.locX, this.locY, size.getWidth(), size.getHeight());
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        if (this.getLegend() != null) {
            this.getLegend().itemVisibilityChanged(this);
        }
    }

    @Override
    public void copyFrom(ElementEx src) {
        super.copyFrom(src);
        LegendItemImpl item = (LegendItemImpl)src;
        this.visible = item.visible;
        this.locX = item.locX;
        this.locY = item.locY;
    }
}

