/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.Dimension;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jplot2d.data.ImageDataBuffer;
import org.jplot2d.data.SingleBandImageData;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.ElementImpl;
import org.jplot2d.element.impl.ImageGraphEx;
import org.jplot2d.element.impl.ImageMappingEx;
import org.jplot2d.element.impl.InvokeStep;
import org.jplot2d.image.ColorMap;
import org.jplot2d.image.IntensityTransform;
import org.jplot2d.image.LimitsAlgorithm;
import org.jplot2d.image.MinMaxAlgorithm;

public class ImageMappingImpl
extends ElementImpl
implements ImageMappingEx {
    private List<ImageGraphEx> graphs = new ArrayList<ImageGraphEx>();
    private LimitsAlgorithm algo = new MinMaxAlgorithm();
    private double[] limits;
    private IntensityTransform intensityTransform;
    private double bias = 0.5;
    private double gain = 0.5;
    private ColorMap colorMap;
    private boolean calcLimitsNeeded;

    @Override
    public ImageGraphEx getParent() {
        return (ImageGraphEx)this.parent;
    }

    @Override
    public String getId() {
        StringBuilder sb = new StringBuilder();
        sb.append("ImageMapping(");
        for (ImageGraphEx graph : this.graphs) {
            sb.append(graph.getId()).append(',');
        }
        sb.replace(sb.length() - 1, sb.length(), ")");
        return sb.toString();
    }

    @Override
    public String getFullId() {
        return "ImageMapping@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public InvokeStep getInvokeStepFormParent() {
        Method method;
        if (this.graphs.size() == 0) {
            return null;
        }
        try {
            method = ImageGraphEx.class.getMethod("getMapping", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
        return new InvokeStep(method);
    }

    @Override
    public void addImageGraph(ImageGraphEx graph) {
        this.graphs.add(graph);
        this.parent = this.graphs.size() == 1 ? (ElementEx)this.graphs.get(0) : null;
    }

    @Override
    public void removeImageGraph(ImageGraphEx graph) {
        this.graphs.remove(graph);
        this.parent = this.graphs.size() == 1 ? (ElementEx)this.graphs.get(0) : null;
    }

    @Override
    public ImageGraphEx[] getGraphs() {
        return this.graphs.toArray(new ImageGraphEx[this.graphs.size()]);
    }

    @Override
    public LimitsAlgorithm getLimitsAlgorithm() {
        return this.algo;
    }

    @Override
    public void setLimitsAlgorithm(LimitsAlgorithm algo) {
        this.algo = algo;
        this.redrawGraphs();
    }

    @Override
    public void recalcLimits() {
        this.calcLimitsNeeded = true;
    }

    @Override
    public void calcLimits() {
        if (this.calcLimitsNeeded || this.limits == null) {
            this.calcLimitsNeeded = false;
            ImageDataBuffer[] ids = new ImageDataBuffer[this.graphs.size()];
            Dimension[] sizeArray = new Dimension[this.graphs.size()];
            int n = 0;
            for (int i = 0; i < ids.length; ++i) {
                SingleBandImageData data = this.graphs.get(i).getData();
                if (data == null) continue;
                ids[n] = data.getDataBuffer();
                sizeArray[n] = new Dimension(data.getWidth(), data.getHeight());
                ++n;
            }
            if (n != this.graphs.size()) {
                ids = Arrays.copyOf(ids, n);
                sizeArray = Arrays.copyOf(sizeArray, n);
            }
            double[] newlimits = this.algo.getCalculator().calcLimits(ids, sizeArray);
            if (this.limits == null || newlimits == null || this.limits[0] != newlimits[0] || this.limits[1] != newlimits[1]) {
                this.limits = newlimits;
                this.redrawGraphs();
            }
        }
    }

    @Override
    public double[] getLimits() {
        return this.limits;
    }

    @Override
    public IntensityTransform getIntensityTransform() {
        return this.intensityTransform;
    }

    @Override
    public void setIntensityTransform(IntensityTransform it) {
        this.intensityTransform = it;
        this.redrawGraphs();
    }

    @Override
    public double getBias() {
        return this.bias;
    }

    @Override
    public void setBias(double bias) {
        this.bias = bias;
        this.redrawGraphs();
    }

    @Override
    public double getGain() {
        return this.gain;
    }

    @Override
    public void setGain(double gain) {
        this.gain = gain;
        this.redrawGraphs();
    }

    @Override
    public ColorMap getColorMap() {
        return this.colorMap;
    }

    @Override
    public void setColorMap(ColorMap colorMap) {
        if (colorMap.getInputBits() > 15) {
            throw new IllegalArgumentException("The colormap input bits is large than MAX_INPUT_BITS.");
        }
        this.colorMap = colorMap;
        this.redrawGraphs();
    }

    private void redrawGraphs() {
        for (ImageGraphEx graph : this.graphs) {
            graph.mappingChanged();
        }
    }

    @Override
    public void copyFrom(ElementEx src) {
        super.copyFrom(src);
        ImageMappingImpl imapping = (ImageMappingImpl)src;
        this.algo = imapping.algo;
        this.limits = imapping.limits;
        this.intensityTransform = imapping.intensityTransform;
        this.bias = imapping.bias;
        this.gain = imapping.gain;
        this.colorMap = imapping.colorMap;
        this.calcLimitsNeeded = imapping.calcLimitsNeeded;
    }

    @Override
    public int getILUTOutputBits() {
        if (this.colorMap == null) {
            return 8;
        }
        return this.colorMap.getInputBits();
    }
}

