/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.LookupOp;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import org.jplot2d.data.ImageDataBuffer;
import org.jplot2d.data.SingleBandImageData;
import org.jplot2d.element.ImageMapping;
import org.jplot2d.element.impl.ComponentEx;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.GraphImpl;
import org.jplot2d.element.impl.ImageGraphEx;
import org.jplot2d.element.impl.ImageMappingEx;
import org.jplot2d.element.impl.ImageZscaleCache;
import org.jplot2d.element.impl.IntermediateCacheEx;
import org.jplot2d.transform.NormalTransform;
import org.jplot2d.transform.PaperTransform;

public class ImageGraphImpl
extends GraphImpl
implements ImageGraphEx,
IntermediateCacheEx {
    private ImageMappingEx mapping;
    private SingleBandImageData data;

    @Override
    public String getId() {
        if (this.getParent() != null) {
            return "ImageGraph" + this.getParent().indexOf(this);
        }
        return "ImageGraph@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public ImageMappingEx getMapping() {
        return this.mapping;
    }

    @Override
    public void setMapping(ImageMapping mapping) {
        if (this.mapping != null) {
            this.mapping.removeImageGraph(this);
        }
        this.mapping = (ImageMappingEx)mapping;
        if (this.mapping != null) {
            this.mapping.addImageGraph(this);
        }
    }

    @Override
    public SingleBandImageData getData() {
        return this.data;
    }

    @Override
    public void setData(SingleBandImageData data) {
        this.data = data;
        this.mapping.recalcLimits();
        ImageGraphImpl.redraw(this);
    }

    @Override
    public void thisEffectiveColorChanged() {
    }

    @Override
    public void mappingChanged() {
        ImageGraphImpl.redraw(this);
    }

    @Override
    public Object createCacheHolder() {
        if (this.data == null) {
            return null;
        }
        return ImageZscaleCache.createCacheFor(this.data.getDataBuffer(), this.data.getWidth(), this.data.getHeight(), this.mapping.getLimits(), this.mapping.getIntensityTransform(), this.mapping.getBias(), this.mapping.getGain(), this.mapping.getILUTOutputBits());
    }

    @Override
    public ComponentEx copyStructure(Map<ElementEx, ElementEx> orig2copyMap) {
        ImageGraphImpl result = (ImageGraphImpl)super.copyStructure((Map)orig2copyMap);
        ImageMappingEx mappingCopy = (ImageMappingEx)orig2copyMap.get(this.mapping);
        if (mappingCopy == null) {
            mappingCopy = (ImageMappingEx)this.mapping.copyStructure(orig2copyMap);
        }
        result.mapping = mappingCopy;
        mappingCopy.addImageGraph(result);
        return result;
    }

    @Override
    public void copyFrom(ElementEx src) {
        super.copyFrom(src);
        this.data = ((ImageGraphImpl)src).data;
    }

    @Override
    public void draw(Graphics2D graphics) {
        WritableRaster raster;
        DataBuffer dbuffer;
        PixelInterleavedSampleModel sampleModel;
        if (this.data == null) {
            return;
        }
        double[] limits = this.mapping.getLimits();
        if (limits == null) {
            return;
        }
        int width = this.data.getWidth();
        int height = this.data.getHeight();
        double xval = this.data.getXRange().getMin();
        double yval = this.data.getYRange().getMin();
        ImageDataBuffer idb = this.data.getDataBuffer();
        int lutOutputBits = this.mapping.getILUTOutputBits();
        Object result = ImageZscaleCache.getValue(idb, width, height, limits, this.mapping.getIntensityTransform(), this.mapping.getBias(), this.mapping.getGain(), lutOutputBits);
        if (lutOutputBits <= 8) {
            sampleModel = new PixelInterleavedSampleModel(0, width, height, 1, width, new int[]{0});
            dbuffer = new DataBufferByte((byte[])result, width * height);
            raster = Raster.createWritableRaster(sampleModel, dbuffer, null);
        } else {
            sampleModel = new PixelInterleavedSampleModel(1, width, height, 1, width, new int[]{0});
            dbuffer = new DataBufferUShort((short[])result, width * height);
            raster = Raster.createWritableRaster(sampleModel, dbuffer, null);
        }
        PaperTransform pxf = this.getPaperTransform();
        NormalTransform xntrans = this.getParent().getXAxisTransform().getNormalTransform();
        NormalTransform yntrans = this.getParent().getYAxisTransform().getNormalTransform();
        Dimension2D paperSize = this.getParent().getSize();
        double xorig = pxf.getXPtoD(xntrans.convToNR(xval) * paperSize.getWidth());
        double yorig = pxf.getYPtoD(yntrans.convToNR(yval) * paperSize.getHeight());
        double xscale = pxf.getScale() / xntrans.getScale() * paperSize.getWidth() * this.data.getXcdelt();
        double yscale = pxf.getScale() / yntrans.getScale() * paperSize.getHeight() * this.data.getYcdelt();
        AffineTransform scaleAT = AffineTransform.getScaleInstance(xscale, yscale);
        AffineTransformOp axop = new AffineTransformOp(scaleAT, 2);
        raster = axop.filter(raster, null);
        BufferedImage image = this.colorImage(this.mapping.getILUTOutputBits(), raster);
        Graphics2D g = (Graphics2D)graphics.create();
        Shape clip = this.getPaperTransform().getPtoD(this.getBounds());
        g.setClip(clip);
        AffineTransform at = new AffineTransform(1.0, 0.0, 0.0, -1.0, xorig, yorig);
        g.drawRenderedImage(image, at);
        g.dispose();
    }

    private BufferedImage colorImage(int bits, WritableRaster raster) {
        int destNumComps = this.mapping.getColorMap() == null ? 3 : this.mapping.getColorMap().getColorModel().getNumComponents();
        if (destNumComps > 1) {
            SampleModel scm = raster.getSampleModel();
            BandedSampleModel dupSM = new BandedSampleModel(scm.getDataType(), scm.getWidth(), scm.getHeight(), destNumComps);
            int singleBandSize = raster.getDataBuffer().getSize();
            int[] bitsArray = new int[destNumComps];
            if (raster.getDataBuffer().getDataType() == 0) {
                byte[] singleBandData = ((DataBufferByte)raster.getDataBuffer()).getData();
                byte[][] dupDataArray = new byte[destNumComps][];
                for (int i = 0; i < destNumComps; ++i) {
                    bitsArray[i] = bits;
                    dupDataArray[i] = singleBandData;
                }
                DataBufferByte dbuffer = new DataBufferByte(dupDataArray, singleBandSize);
                raster = Raster.createWritableRaster(dupSM, dbuffer, null);
            } else {
                short[] singleBandData = ((DataBufferUShort)raster.getDataBuffer()).getData();
                short[][] dupDataArray = new short[destNumComps][];
                for (int i = 0; i < destNumComps; ++i) {
                    bitsArray[i] = bits;
                    dupDataArray[i] = singleBandData;
                }
                DataBufferUShort dbuffer = new DataBufferUShort(dupDataArray, singleBandSize);
                raster = Raster.createWritableRaster(dupSM, dbuffer, null);
            }
        }
        if (this.mapping.getColorMap() == null) {
            int[] bitsArray = new int[]{bits, bits, bits};
            ComponentColorModel destCM = new ComponentColorModel(ColorSpace.getInstance(1000), bitsArray, false, true, 1, raster.getSampleModel().getDataType());
            return new BufferedImage(destCM, raster, false, null);
        }
        ColorModel destCM = this.mapping.getColorMap().getColorModel();
        WritableRaster destRaster = destCM.createCompatibleWritableRaster(raster.getWidth(), raster.getHeight());
        LookupOp op = new LookupOp(this.mapping.getColorMap().getLookupTable(), null);
        op.filter(raster, destRaster);
        return new BufferedImage(destCM, destRaster, false, null);
    }
}

