/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.jplot2d.data.ArrayPair;
import org.jplot2d.data.ByteDataBuffer;
import org.jplot2d.data.DoubleDataBuffer;
import org.jplot2d.data.FloatDataBuffer;
import org.jplot2d.data.ImageDataBuffer;
import org.jplot2d.data.IntDataBuffer;
import org.jplot2d.data.MultiBandImageData;
import org.jplot2d.data.ShortDataBuffer;
import org.jplot2d.data.SingleBandImageData;
import org.jplot2d.data.XYGraphData;
import org.jplot2d.element.Axis;
import org.jplot2d.element.AxisPosition;
import org.jplot2d.element.AxisRangeLockGroup;
import org.jplot2d.element.AxisTickManager;
import org.jplot2d.element.AxisTitle;
import org.jplot2d.element.AxisTransform;
import org.jplot2d.element.CoordinateAnnotation;
import org.jplot2d.element.Element;
import org.jplot2d.element.Graph;
import org.jplot2d.element.HLineAnnotation;
import org.jplot2d.element.HStripAnnotation;
import org.jplot2d.element.ImageBandTransform;
import org.jplot2d.element.ImageGraph;
import org.jplot2d.element.ImageMapping;
import org.jplot2d.element.Layer;
import org.jplot2d.element.Legend;
import org.jplot2d.element.LegendItem;
import org.jplot2d.element.Plot;
import org.jplot2d.element.PlotMargin;
import org.jplot2d.element.RGBImageGraph;
import org.jplot2d.element.RGBImageMapping;
import org.jplot2d.element.RectangleAnnotation;
import org.jplot2d.element.SymbolAnnotation;
import org.jplot2d.element.Title;
import org.jplot2d.element.VLineAnnotation;
import org.jplot2d.element.VStripAnnotation;
import org.jplot2d.element.XYGraph;
import org.jplot2d.element.impl.AxisImpl;
import org.jplot2d.element.impl.AxisRangeLockGroupImpl;
import org.jplot2d.element.impl.AxisTickManagerEx;
import org.jplot2d.element.impl.AxisTickManagerImpl;
import org.jplot2d.element.impl.AxisTitleEx;
import org.jplot2d.element.impl.AxisTransformEx;
import org.jplot2d.element.impl.AxisTransformImpl;
import org.jplot2d.element.impl.CoordinateAnnotationImpl;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.HLineAnnotationImpl;
import org.jplot2d.element.impl.HStripAnnotationImpl;
import org.jplot2d.element.impl.ImageGraphImpl;
import org.jplot2d.element.impl.ImageMappingEx;
import org.jplot2d.element.impl.ImageMappingImpl;
import org.jplot2d.element.impl.LayerImpl;
import org.jplot2d.element.impl.LegendEx;
import org.jplot2d.element.impl.PlotImpl;
import org.jplot2d.element.impl.PlotMarginEx;
import org.jplot2d.element.impl.RGBImageGraphImpl;
import org.jplot2d.element.impl.RGBImageMappingEx;
import org.jplot2d.element.impl.RGBImageMappingImpl;
import org.jplot2d.element.impl.RectangleAnnotationImpl;
import org.jplot2d.element.impl.SymbolAnnotationImpl;
import org.jplot2d.element.impl.TitleImpl;
import org.jplot2d.element.impl.VLineAnnotationImpl;
import org.jplot2d.element.impl.VStripAnnotationImpl;
import org.jplot2d.element.impl.XYGraphImpl;
import org.jplot2d.element.impl.XYLegendItemEx;
import org.jplot2d.env.DummyEnvironment;
import org.jplot2d.env.ElementAddition;
import org.jplot2d.env.ElementIH;
import org.jplot2d.env.Environment;
import org.jplot2d.env.StyleConfiguration;
import org.jplot2d.sizing.FillContainerSizeMode;
import org.jplot2d.util.Range;
import org.jplot2d.util.SymbolShape;

public class ElementFactory {
    private static ElementFactory instance = new ElementFactory(false, null);
    private static ElementFactory threadSafeInstance = new ElementFactory(true, null);
    private final boolean threadSafe;
    private final StyleConfiguration profile;

    public static ElementFactory getInstance() {
        return instance;
    }

    public static ElementFactory getThreadSafeInstance() {
        return threadSafeInstance;
    }

    public static ElementFactory getInstance(StyleConfiguration profile) {
        return new ElementFactory(false, profile);
    }

    public static ElementFactory getThreadSafeInstance(StyleConfiguration profile) {
        return new ElementFactory(true, profile);
    }

    protected ElementFactory(boolean threadSafe, StyleConfiguration profile) {
        this.threadSafe = threadSafe;
        this.profile = profile;
    }

    protected final void applyProfile(Element element) {
        if (this.profile != null) {
            this.profile.applyTo(element);
        }
    }

    protected DummyEnvironment createDummyEnvironment() {
        return new DummyEnvironment(this.threadSafe);
    }

    public <T extends Element> T proxy(ElementEx impl, Class<T> clazz) {
        ElementIH ih = new ElementIH(impl, clazz);
        return (T)((Element)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz, ElementAddition.class}, (InvocationHandler)ih));
    }

    public Plot createPlot() {
        PlotImpl plot = new PlotImpl();
        plot.setCacheable(true);
        plot.setColor(Color.BLACK);
        plot.setFont(new Font("Serif", 0, 12));
        plot.getMargin().setExtraTop(12.0);
        plot.getMargin().setExtraLeft(12.0);
        plot.getMargin().setExtraBottom(12.0);
        plot.getMargin().setExtraRight(12.0);
        plot.setSizeMode(new FillContainerSizeMode(1.0));
        plot.setContainerSize(new Dimension(640, 480));
        this.applyProfile(plot);
        Plot plotProxy = this.proxy(plot, Plot.class);
        LegendEx legend = plot.getLegend();
        this.applyProfile(legend);
        Legend legendProxy = this.proxy(legend, Legend.class);
        PlotMarginEx margin = plot.getMargin();
        this.applyProfile(margin);
        PlotMargin marginProxy = this.proxy(margin, PlotMargin.class);
        DummyEnvironment env = this.createDummyEnvironment();
        env.registerElement(plot, plotProxy);
        env.registerElement(legend, legendProxy);
        env.registerElement(margin, marginProxy);
        return plotProxy;
    }

    public Plot createSubplot() {
        PlotImpl subplot = new PlotImpl();
        this.applyProfile(subplot);
        Plot subplotProxy = this.proxy(subplot, Plot.class);
        LegendEx legend = subplot.getLegend();
        this.applyProfile(legend);
        Legend legendProxy = this.proxy(legend, Legend.class);
        PlotMarginEx margin = subplot.getMargin();
        this.applyProfile(margin);
        PlotMargin marginProxy = this.proxy(margin, PlotMargin.class);
        DummyEnvironment env = this.createDummyEnvironment();
        env.registerElement(subplot, subplotProxy);
        env.registerElement(legend, legendProxy);
        env.registerElement(margin, marginProxy);
        return subplotProxy;
    }

    public Title createTitle(String text) {
        TitleImpl impl = new TitleImpl();
        if (text != null) {
            impl.setText(text);
        }
        this.applyProfile(impl);
        Title proxy = this.proxy(impl, Title.class);
        DummyEnvironment env = this.createDummyEnvironment();
        env.registerElement(impl, proxy);
        return proxy;
    }

    public Axis createAxis() {
        return this.createAxes(1)[0];
    }

    public Axis[] createAxes(int n) {
        AxisTickManager tm = this.createAxisTickManager();
        DummyEnvironment env = (DummyEnvironment)tm.getEnvironment();
        AxisTickManagerEx tme = (AxisTickManagerEx)((ElementAddition)((Object)tm)).getImpl();
        Axis[] result = new Axis[n];
        for (int i = 0; i < n; ++i) {
            AxisImpl axis = new AxisImpl();
            axis.setTickManager(tme);
            Axis axisProxy = this.proxy(axis, Axis.class);
            AxisTitleEx title = axis.getTitle();
            AxisTitle titleProxy = this.proxy(title, AxisTitle.class);
            if (i % 2 == 1) {
                axis.setPosition(AxisPosition.POSITIVE_SIDE);
            }
            env.registerElement(axis, axisProxy);
            env.registerElement(title, titleProxy);
            result[i] = axisProxy;
        }
        return result;
    }

    public AxisTickManager createAxisTickManager() {
        AxisTransform rm = this.createAxisTransform();
        DummyEnvironment env = (DummyEnvironment)rm.getEnvironment();
        AxisTransformEx rme = (AxisTransformEx)((ElementAddition)((Object)rm)).getImpl();
        AxisTickManagerImpl tm = new AxisTickManagerImpl();
        this.applyProfile(tm);
        tm.setAxisTransform(rme);
        AxisTickManager vaProxy = this.proxy(tm, AxisTickManager.class);
        env.registerElement(tm, vaProxy);
        return vaProxy;
    }

    public AxisTransform createAxisTransform() {
        AxisTransformImpl rm = new AxisTransformImpl();
        AxisRangeLockGroupImpl group = new AxisRangeLockGroupImpl();
        this.applyProfile(rm);
        this.applyProfile(group);
        rm.setLockGroup(group);
        AxisTransform vaProxy = this.proxy(rm, AxisTransform.class);
        AxisRangeLockGroup groupProxy = this.proxy(group, AxisRangeLockGroup.class);
        DummyEnvironment env = this.createDummyEnvironment();
        env.registerElement(rm, vaProxy);
        env.registerElement(group, groupProxy);
        return vaProxy;
    }

    public AxisRangeLockGroup createAxisRangeLockGroup() {
        AxisRangeLockGroupImpl impl = new AxisRangeLockGroupImpl();
        this.applyProfile(impl);
        AxisRangeLockGroup proxy = this.proxy(impl, AxisRangeLockGroup.class);
        DummyEnvironment env = this.createDummyEnvironment();
        env.registerElement(impl, proxy);
        return proxy;
    }

    public Layer createLayer(Graph graph) {
        Layer layer = this.createLayer();
        layer.addGraph(graph);
        return layer;
    }

    public Layer createLayer() {
        LayerImpl impl = new LayerImpl();
        this.applyProfile(impl);
        Layer proxy = this.proxy(impl, Layer.class);
        DummyEnvironment env = this.createDummyEnvironment();
        env.registerElement(impl, proxy);
        return proxy;
    }

    public XYGraph createXYGraph(Object xarray, Object yarray) {
        return this.createXYGraph(new ArrayPair(xarray, yarray));
    }

    public XYGraph createXYGraph(Object xarray, Object yarray, String name) {
        return this.createXYGraph(new ArrayPair(xarray, yarray), name);
    }

    public XYGraph createXYGraph(Object xarray, Object yarray, Object xErrorLow, Object xErrorHigh, Object yErrorLow, Object yErrorHigh) {
        return this.createXYGraph(xarray, yarray, xErrorLow, xErrorHigh, yErrorLow, yErrorHigh, null);
    }

    public XYGraph createXYGraph(Object xarray, Object yarray, Object xErrorLow, Object xErrorHigh, Object yErrorLow, Object yErrorHigh, String name) {
        ArrayPair errorX = null;
        if (xErrorLow != null && xErrorHigh != null) {
            errorX = new ArrayPair(xErrorLow, xErrorHigh);
        }
        ArrayPair errorY = null;
        if (yErrorLow != null && yErrorHigh != null) {
            errorY = new ArrayPair(yErrorLow, yErrorHigh);
        }
        return this.createXYGraph(new ArrayPair(xarray, yarray), errorX, errorY, name);
    }

    public XYGraph createXYGraph(ArrayPair xy) {
        return this.createXYGraph(new XYGraphData(xy));
    }

    public XYGraph createXYGraph(ArrayPair xy, String name) {
        return this.createXYGraph(new XYGraphData(xy), name);
    }

    public XYGraph createXYGraph(ArrayPair xy, ArrayPair errorX, ArrayPair errorY) {
        return this.createXYGraph(new XYGraphData(xy, errorX, errorY));
    }

    public XYGraph createXYGraph(ArrayPair xy, ArrayPair errorX, ArrayPair errorY, String name) {
        return this.createXYGraph(new XYGraphData(xy, errorX, errorY), name);
    }

    public XYGraph createXYGraph(XYGraphData data) {
        return this.createXYGraph(data, null);
    }

    public XYGraph createXYGraph(XYGraphData data, String name) {
        XYGraphImpl graph = new XYGraphImpl();
        graph.setData(data);
        graph.setName(name);
        this.applyProfile(graph);
        XYGraph gpProxy = this.proxy(graph, XYGraph.class);
        XYLegendItemEx li = graph.getLegendItem();
        LegendItem liProxy = this.proxy(li, LegendItem.class);
        DummyEnvironment env = this.createDummyEnvironment();
        env.registerElement(graph, gpProxy);
        env.registerElement(li, liProxy);
        return gpProxy;
    }

    public SymbolAnnotation createSymbolAnnotation(double x, double y) {
        SymbolAnnotationImpl annotation = new SymbolAnnotationImpl();
        annotation.setValuePoint(x, y);
        this.applyProfile(annotation);
        SymbolAnnotation annotationProxy = this.proxy(annotation, SymbolAnnotation.class);
        DummyEnvironment env = this.createDummyEnvironment();
        env.registerElement(annotation, annotationProxy);
        return annotationProxy;
    }

    public SymbolAnnotation createSymbolAnnotation(double x, double y, String text) {
        SymbolAnnotationImpl annotation = new SymbolAnnotationImpl();
        annotation.setValuePoint(x, y);
        annotation.setText(text);
        this.applyProfile(annotation);
        SymbolAnnotation annotationProxy = this.proxy(annotation, SymbolAnnotation.class);
        DummyEnvironment env = this.createDummyEnvironment();
        env.registerElement(annotation, annotationProxy);
        return annotationProxy;
    }

    public SymbolAnnotation createSymbolAnnotation(double x, double y, SymbolShape symbol) {
        SymbolAnnotationImpl annotation = new SymbolAnnotationImpl();
        annotation.setValuePoint(x, y);
        annotation.setSymbolShape(symbol);
        this.applyProfile(annotation);
        SymbolAnnotation annotationProxy = this.proxy(annotation, SymbolAnnotation.class);
        DummyEnvironment env = this.createDummyEnvironment();
        env.registerElement(annotation, annotationProxy);
        return annotationProxy;
    }

    public SymbolAnnotation createSymbolAnnotation(double x, double y, SymbolShape symbol, String text) {
        SymbolAnnotationImpl annotation = new SymbolAnnotationImpl();
        annotation.setValuePoint(x, y);
        annotation.setSymbolShape(symbol);
        annotation.setText(text);
        this.applyProfile(annotation);
        SymbolAnnotation annotationProxy = this.proxy(annotation, SymbolAnnotation.class);
        DummyEnvironment env = this.createDummyEnvironment();
        env.registerElement(annotation, annotationProxy);
        return annotationProxy;
    }

    public CoordinateAnnotation createCoordinateAnnotation(double x, double y, SymbolShape symbol) {
        CoordinateAnnotationImpl annotation = new CoordinateAnnotationImpl();
        annotation.setValuePoint(x, y);
        annotation.setSymbolShape(symbol);
        this.applyProfile(annotation);
        CoordinateAnnotation annotationProxy = this.proxy(annotation, CoordinateAnnotation.class);
        DummyEnvironment env = this.createDummyEnvironment();
        env.registerElement(annotation, annotationProxy);
        return annotationProxy;
    }

    public HLineAnnotation createHLineAnnotation(double y) {
        HLineAnnotationImpl annotation = new HLineAnnotationImpl();
        annotation.setValue(y);
        this.applyProfile(annotation);
        HLineAnnotation annotationProxy = this.proxy(annotation, HLineAnnotation.class);
        DummyEnvironment env = this.createDummyEnvironment();
        env.registerElement(annotation, annotationProxy);
        return annotationProxy;
    }

    public VLineAnnotation createVLineAnnotation(double x) {
        VLineAnnotationImpl annotation = new VLineAnnotationImpl();
        annotation.setValue(x);
        this.applyProfile(annotation);
        VLineAnnotation annotationProxy = this.proxy(annotation, VLineAnnotation.class);
        DummyEnvironment env = this.createDummyEnvironment();
        env.registerElement(annotation, annotationProxy);
        return annotationProxy;
    }

    public HStripAnnotation createHStripAnnotation(double start, double end) {
        HStripAnnotationImpl annotation = new HStripAnnotationImpl();
        annotation.setValueRange(new Range.Double(start, end));
        this.applyProfile(annotation);
        HStripAnnotation annotationProxy = this.proxy(annotation, HStripAnnotation.class);
        DummyEnvironment env = this.createDummyEnvironment();
        env.registerElement(annotation, annotationProxy);
        return annotationProxy;
    }

    public VStripAnnotation createVStripAnnotation(double start, double end) {
        VStripAnnotationImpl annotation = new VStripAnnotationImpl();
        annotation.setValueRange(new Range.Double(start, end));
        this.applyProfile(annotation);
        VStripAnnotation annotationProxy = this.proxy(annotation, VStripAnnotation.class);
        DummyEnvironment env = this.createDummyEnvironment();
        env.registerElement(annotation, annotationProxy);
        return annotationProxy;
    }

    public RectangleAnnotation createRectangleAnnotation(double x1, double x2, double y1, double y2) {
        RectangleAnnotationImpl annotation = new RectangleAnnotationImpl();
        annotation.setXValueRange(new Range.Double(x1, x2));
        annotation.setYValueRange(new Range.Double(y1, y2));
        this.applyProfile(annotation);
        RectangleAnnotation annotationProxy = this.proxy(annotation, RectangleAnnotation.class);
        DummyEnvironment env = this.createDummyEnvironment();
        env.registerElement(annotation, annotationProxy);
        return annotationProxy;
    }

    public BasicStroke createStroke(float width) {
        return new BasicStroke(width, 0, 0, 10.0f, null, 0.0f);
    }

    public BasicStroke createStroke(float width, float[] dash) {
        return new BasicStroke(width, 0, 0, 10.0f, dash, 0.0f);
    }

    public ImageGraph createImageGraph(byte[][] byte2d) {
        return this.createImageGraph(new SingleBandImageData(new ByteDataBuffer.Array2D(byte2d), byte2d[0].length, byte2d.length));
    }

    public ImageGraph createImageGraph(short[][] short2d) {
        return this.createImageGraph(new SingleBandImageData(new ShortDataBuffer.Array2D(short2d), short2d[0].length, short2d.length));
    }

    public ImageGraph createImageGraph(int[][] int2d) {
        return this.createImageGraph(new SingleBandImageData(new IntDataBuffer.Array2D(int2d), int2d[0].length, int2d.length));
    }

    public ImageGraph createImageGraph(float[][] float2d) {
        return this.createImageGraph(new SingleBandImageData(new FloatDataBuffer.Array2D(float2d), float2d[0].length, float2d.length));
    }

    public ImageGraph createImageGraph(double[][] double2d) {
        return this.createImageGraph(new SingleBandImageData(new DoubleDataBuffer.Array2D(double2d), double2d[0].length, double2d.length));
    }

    public ImageGraph createImageGraph(SingleBandImageData data) {
        ImageMapping im = this.createImageMapping();
        DummyEnvironment env = (DummyEnvironment)im.getEnvironment();
        ImageMappingEx ime = (ImageMappingEx)((ElementAddition)((Object)im)).getImpl();
        ImageGraphImpl graph = new ImageGraphImpl();
        graph.setMapping(ime);
        graph.setData(data);
        this.applyProfile(graph);
        ImageGraph gpProxy = this.proxy(graph, ImageGraph.class);
        env.registerElement(graph, gpProxy);
        return gpProxy;
    }

    public ImageMapping createImageMapping() {
        ImageMappingImpl impl = new ImageMappingImpl();
        this.applyProfile(impl);
        ImageMapping proxy = this.proxy(impl, ImageMapping.class);
        DummyEnvironment env = this.createDummyEnvironment();
        env.registerElement(impl, proxy);
        return proxy;
    }

    public RGBImageGraph createRGBImageGraph(byte[][] red2d, byte[][] green2d, byte[][] blue2d) {
        int w = red2d[0].length;
        int h = red2d.length;
        if (w != green2d[0].length || h != green2d.length || w != blue2d[0].length || h != blue2d.length) {
            throw new IllegalArgumentException("Input data do not have the same dimension.");
        }
        ByteDataBuffer.Array2D redBuffer = new ByteDataBuffer.Array2D(red2d);
        ByteDataBuffer.Array2D greenBuffer = new ByteDataBuffer.Array2D(green2d);
        ByteDataBuffer.Array2D blueBuffer = new ByteDataBuffer.Array2D(blue2d);
        return this.createRGBImageGraph(new MultiBandImageData(new ImageDataBuffer[]{redBuffer, greenBuffer, blueBuffer}, w, h));
    }

    public RGBImageGraph createRGBImageGraph(short[][] red2d, short[][] green2d, short[][] blue2d) {
        int w = red2d[0].length;
        int h = red2d.length;
        if (w != green2d[0].length || h != green2d.length || w != blue2d[0].length || h != blue2d.length) {
            throw new IllegalArgumentException("Input data do not have the same dimension.");
        }
        ShortDataBuffer.Array2D redBuffer = new ShortDataBuffer.Array2D(red2d);
        ShortDataBuffer.Array2D greenBuffer = new ShortDataBuffer.Array2D(green2d);
        ShortDataBuffer.Array2D blueBuffer = new ShortDataBuffer.Array2D(blue2d);
        return this.createRGBImageGraph(new MultiBandImageData(new ImageDataBuffer[]{redBuffer, greenBuffer, blueBuffer}, w, h));
    }

    public RGBImageGraph createRGBImageGraph(int[][] red2d, int[][] green2d, int[][] blue2d) {
        int w = red2d[0].length;
        int h = red2d.length;
        if (w != green2d[0].length || h != green2d.length || w != blue2d[0].length || h != blue2d.length) {
            throw new IllegalArgumentException("Input data do not have the same dimension.");
        }
        IntDataBuffer.Array2D redBuffer = new IntDataBuffer.Array2D(red2d);
        IntDataBuffer.Array2D greenBuffer = new IntDataBuffer.Array2D(green2d);
        IntDataBuffer.Array2D blueBuffer = new IntDataBuffer.Array2D(blue2d);
        return this.createRGBImageGraph(new MultiBandImageData(new ImageDataBuffer[]{redBuffer, greenBuffer, blueBuffer}, w, h));
    }

    public RGBImageGraph createRGBImageGraph(float[][] red2d, float[][] green2d, float[][] blue2d) {
        int w = red2d[0].length;
        int h = red2d.length;
        if (w != green2d[0].length || h != green2d.length || w != blue2d[0].length || h != blue2d.length) {
            throw new IllegalArgumentException("Input data do not have the same dimension.");
        }
        FloatDataBuffer.Array2D redBuffer = new FloatDataBuffer.Array2D(red2d);
        FloatDataBuffer.Array2D greenBuffer = new FloatDataBuffer.Array2D(green2d);
        FloatDataBuffer.Array2D blueBuffer = new FloatDataBuffer.Array2D(blue2d);
        return this.createRGBImageGraph(new MultiBandImageData(new ImageDataBuffer[]{redBuffer, greenBuffer, blueBuffer}, w, h));
    }

    public RGBImageGraph createRGBImageGraph(double[][] red2d, double[][] green2d, double[][] blue2d) {
        int w = red2d[0].length;
        int h = red2d.length;
        if (w != green2d[0].length || h != green2d.length || w != blue2d[0].length || h != blue2d.length) {
            throw new IllegalArgumentException("Input data do not have the same dimension.");
        }
        DoubleDataBuffer.Array2D redBuffer = new DoubleDataBuffer.Array2D(red2d);
        DoubleDataBuffer.Array2D greenBuffer = new DoubleDataBuffer.Array2D(green2d);
        DoubleDataBuffer.Array2D blueBuffer = new DoubleDataBuffer.Array2D(blue2d);
        return this.createRGBImageGraph(new MultiBandImageData(new ImageDataBuffer[]{redBuffer, greenBuffer, blueBuffer}, w, h));
    }

    public RGBImageGraph createRGBImageGraph(MultiBandImageData data) {
        RGBImageMapping im = this.createRGBImageMapping();
        DummyEnvironment env = (DummyEnvironment)im.getEnvironment();
        RGBImageMappingEx ime = (RGBImageMappingEx)((ElementAddition)((Object)im)).getImpl();
        RGBImageGraphImpl graph = new RGBImageGraphImpl();
        graph.setMapping(ime);
        graph.setData(data);
        this.applyProfile(graph);
        RGBImageGraph gpProxy = this.proxy(graph, RGBImageGraph.class);
        env.registerElement(graph, gpProxy);
        return gpProxy;
    }

    public RGBImageMapping createRGBImageMapping() {
        RGBImageMappingImpl impl = new RGBImageMappingImpl();
        this.applyProfile(impl);
        RGBImageMapping proxy = this.proxy(impl, RGBImageMapping.class);
        DummyEnvironment env = this.createDummyEnvironment();
        env.registerElement(impl, proxy);
        env.registerElement(impl.getRedTransform(), this.proxy(impl.getRedTransform(), ImageBandTransform.class));
        env.registerElement(impl.getGreenTransform(), this.proxy(impl.getGreenTransform(), ImageBandTransform.class));
        env.registerElement(impl.getBlueTransform(), this.proxy(impl.getBlueTransform(), ImageBandTransform.class));
        return proxy;
    }

    public <T extends Element> T copy(T element) {
        return this.copy(element, null);
    }

    public <T extends Element> T copy(T element, Map<Element, Element> copyMap) {
        if (copyMap == null) {
            copyMap = new HashMap<Element, Element>();
        }
        Environment senv = element.getEnvironment();
        DummyEnvironment denv = this.createDummyEnvironment();
        HashMap<ElementEx, ElementEx> implCopyMap = new HashMap<ElementEx, ElementEx>();
        ElementEx ecopy = ((ElementAddition)((Object)element)).getImpl().copyStructure(implCopyMap);
        for (Map.Entry<ElementEx, ElementEx> me : implCopyMap.entrySet()) {
            ElementEx simpl = me.getKey();
            ElementEx dimpl = me.getValue();
            dimpl.copyFrom(simpl);
            Element sproxy = senv.getProxy(simpl);
            Class<?> itf = sproxy.getClass().getInterfaces()[0];
            Object dproxy = this.proxy(me.getValue(), itf);
            denv.registerElement(dimpl, (Element)dproxy);
            copyMap.put(sproxy, (Element)dproxy);
        }
        return (T)denv.getProxy(ecopy);
    }
}

