/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.data;

import org.jplot2d.data.ImageCoordinateReference;
import org.jplot2d.data.ImageData;
import org.jplot2d.data.ImageDataBuffer;
import org.jplot2d.util.Range;

public class SingleBandImageData
extends ImageData {
    private final ImageDataBuffer dataBuffer;

    public SingleBandImageData(ImageDataBuffer dataBuffer, int w, int h) {
        super(w, h, new ImageCoordinateReference(), null, null);
        this.dataBuffer = dataBuffer;
    }

    public SingleBandImageData(ImageDataBuffer dataBuffer, int w, int h, ImageCoordinateReference cr) {
        super(w, h, cr, null, null);
        this.dataBuffer = dataBuffer;
    }

    protected SingleBandImageData(ImageDataBuffer dataBuffer, int w, int h, ImageCoordinateReference cr, Range xboundary, Range yboundary) {
        super(w, h, cr, xboundary, yboundary);
        this.dataBuffer = dataBuffer;
    }

    public ImageDataBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    @Override
    public SingleBandImageData applyCoordinateReference(ImageCoordinateReference cr) {
        return new SingleBandImageData(this.getDataBuffer(), this.getWidth(), this.getHeight(), cr, this.getXRange(), this.getYRange());
    }

    @Override
    public SingleBandImageData applyBoundary(Range xboundary, Range yboundary) {
        return new SingleBandImageData(this.getDataBuffer(), this.getWidth(), this.getHeight(), this.getCoordinateReference(), xboundary, yboundary);
    }
}

