/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.data;

import org.jplot2d.data.ImageCoordinateReference;
import org.jplot2d.data.ImageData;
import org.jplot2d.data.ImageDataBuffer;
import org.jplot2d.util.Range;

public class MultiBandImageData
extends ImageData {
    private final ImageDataBuffer[] dataBuffer;

    public MultiBandImageData(ImageDataBuffer[] dataBuffer, int w, int h) {
        this(dataBuffer, w, h, new ImageCoordinateReference(), null, null);
    }

    public MultiBandImageData(ImageDataBuffer[] dataBuffer, int w, int h, ImageCoordinateReference cr) {
        this(dataBuffer, w, h, cr, null, null);
    }

    protected MultiBandImageData(ImageDataBuffer[] dataBuffer, int w, int h, ImageCoordinateReference cr, Range xboundary, Range yboundary) {
        super(w, h, cr, xboundary, yboundary);
        this.dataBuffer = dataBuffer;
    }

    public ImageDataBuffer[] getDataBuffer() {
        return this.dataBuffer;
    }

    @Override
    public MultiBandImageData applyCoordinateReference(ImageCoordinateReference cr) {
        return new MultiBandImageData(this.getDataBuffer(), this.getWidth(), this.getHeight(), cr, this.getXRange(), this.getYRange());
    }

    @Override
    public MultiBandImageData applyBoundary(Range xboundary, Range yboundary) {
        return new MultiBandImageData(this.getDataBuffer(), this.getWidth(), this.getHeight(), this.getCoordinateReference(), xboundary, yboundary);
    }
}

