/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.data;

import org.jplot2d.data.ImageMaskBuffer;

public abstract class ImageDataBuffer {
    protected final ImageMaskBuffer mask;

    public ImageDataBuffer(ImageMaskBuffer mask) {
        this.mask = mask;
    }

    public boolean hasMasks() {
        return this.mask != null;
    }

    public boolean isMasked(int x, int y) {
        if (this.mask == null) {
            return false;
        }
        return this.mask.isMasked(x, y);
    }

    public abstract byte getByte(int var1, int var2);

    public abstract short getShort(int var1, int var2);

    public abstract int getInt(int var1, int var2);

    public abstract float getFloat(int var1, int var2);

    public abstract double getDouble(int var1, int var2);

    public abstract double countValid(int var1, int var2);

    public abstract double[] calcMinMax(int var1, int var2);
}

