/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.data;

import org.jplot2d.data.ImageMaskBuffer;

public interface BooleanMaskBuffer
extends ImageMaskBuffer {

    public static class Array2D
    implements BooleanMaskBuffer {
        private final boolean[][] mask;
        private final int xoffset;
        private final int yoffset;

        public Array2D(boolean[][] mask) {
            this(mask, 0, 0);
        }

        public Array2D(boolean[][] mask, int xoffset, int yoffset) {
            this.mask = mask;
            this.xoffset = xoffset;
            this.yoffset = yoffset;
        }

        @Override
        public boolean isMasked(int x, int y) {
            return this.mask[this.yoffset + y][this.xoffset + x];
        }
    }

    public static class Array
    implements BooleanMaskBuffer {
        private final boolean[] mask;
        private final int offset;

        public Array(boolean[] mask) {
            this(mask, 0);
        }

        public Array(boolean[] mask, int offset) {
            this.mask = mask;
            this.offset = offset;
        }

        @Override
        public boolean isMasked(int x, int y) {
            return this.mask[this.offset + x + y];
        }
    }
}

