/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.axtype;

import java.util.Locale;
import java.util.TimeZone;
import org.jplot2d.axtick.TAIMicrosTickAlgorithm;
import org.jplot2d.axtick.TickAlgorithm;
import org.jplot2d.axtype.AxisType;
import org.jplot2d.transform.AxisTickTransform;
import org.jplot2d.transform.TransformType;
import org.jplot2d.util.Range;

public class TAIMicrosAxisType
extends AxisType {
    private static final TAIMicrosAxisType DEFAULT = new TAIMicrosAxisType(TimeZone.getDefault(), Locale.getDefault());
    private static final TAIMicrosAxisType UTC_US = new TAIMicrosAxisType(TimeZone.getTimeZone("UTC"), Locale.US);
    private static final Range DATE_BOUNDARY = new Range.Long(Long.MIN_VALUE, Long.MAX_VALUE);
    private final TAIMicrosTickAlgorithm algo;

    public static TAIMicrosAxisType getDefault() {
        return DEFAULT;
    }

    public static TAIMicrosAxisType getUTC() {
        return UTC_US;
    }

    public static TAIMicrosAxisType getInstance(TimeZone zone, Locale aLocale) {
        return new TAIMicrosAxisType(zone, aLocale);
    }

    private TAIMicrosAxisType(TimeZone zone, Locale locale) {
        super("TAI-" + zone.getID() + "-" + locale.toString());
        this.algo = new TAIMicrosTickAlgorithm(zone, locale);
    }

    @Override
    public boolean canSupport(TransformType txfType) {
        return txfType == TransformType.LINEAR;
    }

    @Override
    public TransformType getDefaultTransformType() {
        return TransformType.LINEAR;
    }

    @Override
    public Range getBoundary(TransformType txfType) {
        return DATE_BOUNDARY;
    }

    @Override
    public Range getDefaultWorldRange(TransformType txfType) {
        long now = System.currentTimeMillis();
        return new Range.Long(now, now + 1L);
    }

    @Override
    public TickAlgorithm getTickAlgorithm(TransformType txfType, AxisTickTransform tickTransform) {
        if (tickTransform != null) {
            return null;
        }
        return this.algo;
    }
}

