/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.axtype;

import java.util.Locale;
import java.util.TimeZone;
import org.jplot2d.axtick.DateTickAlgorithm;
import org.jplot2d.axtick.TickAlgorithm;
import org.jplot2d.axtype.AxisType;
import org.jplot2d.transform.AxisTickTransform;
import org.jplot2d.transform.TransformType;
import org.jplot2d.util.Range;

public class DateAxisType
extends AxisType {
    private static final DateAxisType DEFAULT = new DateAxisType(TimeZone.getDefault(), Locale.getDefault());
    private static final DateAxisType UTC_US = new DateAxisType(TimeZone.getTimeZone("UTC"), Locale.US);
    private static final Range DATE_BOUNDARY = new Range.Long(Long.MIN_VALUE, Long.MAX_VALUE);
    private final DateTickAlgorithm algo;

    public static DateAxisType getDefault() {
        return DEFAULT;
    }

    public static DateAxisType getUTC() {
        return UTC_US;
    }

    public static DateAxisType getInstance(TimeZone zone, Locale aLocale) {
        return new DateAxisType(zone, aLocale);
    }

    private DateAxisType(TimeZone zone, Locale locale) {
        super("DATE-" + zone.getID() + "-" + locale.toString());
        this.algo = new DateTickAlgorithm(zone, locale);
    }

    @Override
    public boolean canSupport(TransformType txfType) {
        return txfType == TransformType.LINEAR;
    }

    @Override
    public TransformType getDefaultTransformType() {
        return TransformType.LINEAR;
    }

    @Override
    public Range getBoundary(TransformType txfType) {
        return DATE_BOUNDARY;
    }

    @Override
    public Range getDefaultWorldRange(TransformType txfType) {
        long now = System.currentTimeMillis();
        return new Range.Long(now, now + 1L);
    }

    @Override
    public TickAlgorithm getTickAlgorithm(TransformType txfType, AxisTickTransform tickTransform) {
        if (tickTransform != null) {
            return null;
        }
        return this.algo;
    }
}

