/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.axtick;

import java.lang.reflect.Array;
import java.util.Locale;
import org.jplot2d.axtick.AbstractLinearTickCalculator;
import org.jplot2d.axtick.TickUnitConverter;
import org.jplot2d.axtick.TimeHmsFormat;
import org.jplot2d.axtick.TimeHmsInterval;

public class TimeHmsTickCalculator
extends AbstractLinearTickCalculator {
    private final TickUnitConverter tuc;

    public TimeHmsTickCalculator(TickUnitConverter tuf) {
        this.tuc = tuf == null ? TickUnitConverter.IDENTITY : tuf;
    }

    protected TimeHmsInterval[] calcCandidateInterval(double rough) {
        TimeHmsInterval itvB;
        TimeHmsInterval itvA;
        double itv = this.tuc.convertD2T(rough);
        if (itv < (double)TimeHmsInterval.Unit.SECOND.time) {
            int expn = (int)Math.floor(Math.log10(itv));
            double scale = Math.pow(10.0, expn);
            double coeff = itv / scale;
            if (coeff < 2.0) {
                itvA = new TimeHmsInterval(this.tuc, 1, expn);
                itvB = new TimeHmsInterval(this.tuc, 2, expn);
            } else if (coeff < 5.0) {
                itvA = new TimeHmsInterval(this.tuc, 2, expn);
                itvB = new TimeHmsInterval(this.tuc, 5, expn);
            } else {
                itvA = new TimeHmsInterval(this.tuc, 5, expn);
                itvB = new TimeHmsInterval(this.tuc, 1, expn + 1);
            }
        } else if (itv < (double)(TimeHmsInterval.Unit.SECOND.time * 2)) {
            itvA = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.SECOND, 1);
            itvB = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.SECOND, 2);
        } else if (itv < (double)(TimeHmsInterval.Unit.SECOND.time * 5)) {
            itvA = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.SECOND, 2);
            itvB = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.SECOND, 5);
        } else if (itv < (double)(TimeHmsInterval.Unit.SECOND.time * 10)) {
            itvA = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.SECOND, 5);
            itvB = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.SECOND, 10);
        } else if (itv < (double)(TimeHmsInterval.Unit.SECOND.time * 15)) {
            itvA = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.SECOND, 10);
            itvB = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.SECOND, 15);
        } else if (itv < (double)(TimeHmsInterval.Unit.SECOND.time * 30)) {
            itvA = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.SECOND, 15);
            itvB = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.SECOND, 30);
        } else if (itv < (double)TimeHmsInterval.Unit.MINUTE.time) {
            itvA = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.SECOND, 30);
            itvB = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.MINUTE, 1);
        } else if (itv < (double)(TimeHmsInterval.Unit.MINUTE.time * 2)) {
            itvA = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.MINUTE, 1);
            itvB = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.MINUTE, 2);
        } else if (itv < (double)(TimeHmsInterval.Unit.MINUTE.time * 5)) {
            itvA = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.MINUTE, 2);
            itvB = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.MINUTE, 5);
        } else if (itv < (double)(TimeHmsInterval.Unit.MINUTE.time * 10)) {
            itvA = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.MINUTE, 5);
            itvB = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.MINUTE, 10);
        } else if (itv < (double)(TimeHmsInterval.Unit.MINUTE.time * 15)) {
            itvA = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.MINUTE, 10);
            itvB = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.MINUTE, 15);
        } else if (itv < (double)(TimeHmsInterval.Unit.MINUTE.time * 30)) {
            itvA = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.MINUTE, 15);
            itvB = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.MINUTE, 30);
        } else if (itv < (double)TimeHmsInterval.Unit.HOUR.time) {
            itvA = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.MINUTE, 30);
            itvB = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.HOUR, 1);
        } else if (itv < (double)(TimeHmsInterval.Unit.HOUR.time * 2)) {
            itvA = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.HOUR, 1);
            itvB = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.HOUR, 2);
        } else if (itv < (double)(TimeHmsInterval.Unit.HOUR.time * 3)) {
            itvA = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.HOUR, 2);
            itvB = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.HOUR, 3);
        } else if (itv < (double)(TimeHmsInterval.Unit.HOUR.time * 6)) {
            itvA = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.HOUR, 3);
            itvB = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.HOUR, 6);
        } else if (itv < (double)(TimeHmsInterval.Unit.HOUR.time * 12)) {
            itvA = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.HOUR, 6);
            itvB = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.HOUR, 12);
        } else if (itv < (double)(TimeHmsInterval.Unit.HOUR.time * 24)) {
            itvA = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.HOUR, 12);
            itvB = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.HOUR, 24);
        } else {
            itvA = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.HOUR, 24);
            itvB = new TimeHmsInterval(this.tuc, TimeHmsInterval.Unit.HOUR, 24);
        }
        return new TimeHmsInterval[]{itvA, itvB};
    }

    @Override
    public void calcValuesByTickNumber(int tickNumber, int minorTickNumber) {
        TimeHmsInterval intv = (TimeHmsInterval)this.calcInterval(tickNumber);
        this.minorNumber = minorTickNumber == -1 ? (intv.getCoefficient() == 1 && (intv.getUnit() == TimeHmsInterval.Unit.MINUTE || intv.getUnit() == TimeHmsInterval.Unit.HOUR) ? 0 : this.calcMinorNumber(intv.getCoefficient(), 3)) : minorTickNumber;
        this.calcValues(this.interval, 0.0, this.minorNumber);
    }

    @Override
    protected int calcMinorNumber(double interval) {
        double hours;
        double minutes;
        double secs;
        double s1dcoef;
        int mag;
        double coefficient;
        double s1dcoef2;
        double itv = this.tuc.convertD2T(interval);
        int s1dInterval = itv < (double)TimeHmsInterval.Unit.SECOND.time ? (Math.abs((s1dcoef2 = (double)Math.round(coefficient = itv / Math.pow(10.0, mag = (int)Math.floor(Math.log10(itv))))) / coefficient - 1.0) > 9.094947017729282E-13 ? 0 : (int)s1dcoef2) : (itv < (double)TimeHmsInterval.Unit.MINUTE.time ? (Math.abs((s1dcoef = (double)Math.round(secs = itv)) / secs - 1.0) > 9.094947017729282E-13 ? 0 : (int)s1dcoef) : (itv < (double)TimeHmsInterval.Unit.HOUR.time ? (Math.abs((s1dcoef = (double)Math.round(minutes = itv / (double)TimeHmsInterval.Unit.MINUTE.time)) / minutes - 1.0) > 9.094947017729282E-13 ? 0 : (int)s1dcoef) : (Math.abs((s1dcoef = (double)Math.round(hours = itv / (double)TimeHmsInterval.Unit.HOUR.time)) / hours - 1.0) > 9.094947017729282E-13 ? 0 : (int)s1dcoef)));
        if (s1dInterval == 0) {
            return 0;
        }
        return this.calcMinorNumber(s1dInterval, 3);
    }

    @Override
    public TimeHmsFormat calcLabelTextFormat(Object values) {
        return new TimeHmsFormat(this.tuc, this.calcSigFraDigits(values));
    }

    private int calcSigFraDigits(Object values) {
        int maxFractionDigits = 0;
        for (int i = 0; i < Array.getLength(values); ++i) {
            double vi = Array.getDouble(values, i);
            if (vi == 0.0) continue;
            double v = Math.abs(this.tuc.convertD2T(vi));
            int mag = (int)Math.floor(Math.log10(v));
            double scale = Math.pow(10.0, mag);
            double coefficient = v / scale;
            String s = String.format((Locale)null, "%.14f", coefficient);
            int pp1 = TimeHmsTickCalculator.lastNon0Idx(s);
            if (maxFractionDigits >= pp1 - mag - 1) continue;
            maxFractionDigits = pp1 - mag - 1;
        }
        return maxFractionDigits;
    }

    private static int lastNon0Idx(String s) {
        for (int i = s.length() - 1; i >= 0; --i) {
            if (s.charAt(i) == '0') continue;
            return i;
        }
        return -1;
    }

    @Override
    public String calcLabelFormatString(Object values) {
        return "";
    }

    @Override
    public String getLabelFormate() {
        return "";
    }
}

