/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.axtick;

import org.jplot2d.axtick.DoubleInterval;
import org.jplot2d.axtick.TickUnitConverter;

public final class TimeHmsInterval
implements DoubleInterval {
    private final TickUnitConverter tuc;
    private final int _c;
    private final int _e;
    private final Unit _unit;

    public TimeHmsInterval(TickUnitConverter tuc, int coefficient, int exponent) {
        this.tuc = tuc;
        this._unit = Unit.SECOND;
        this._c = coefficient;
        this._e = exponent;
    }

    public TimeHmsInterval(TickUnitConverter tuc, Unit unit, int value) {
        this.tuc = tuc;
        this._unit = unit;
        this._c = value;
        this._e = 0;
    }

    public Unit getUnit() {
        return this._unit;
    }

    public int getCoefficient() {
        return this._c;
    }

    public int getExponent() {
        return this._e;
    }

    @Override
    public double doubleValue() {
        return this.tuc.convertT2D(Math.pow(10.0, this._e) * (double)this._c * (double)this._unit.time);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TimeHmsInterval)) {
            return false;
        }
        TimeHmsInterval ien = (TimeHmsInterval)obj;
        return this._c == ien._c && this._e == ien._e;
    }

    public int hashCode() {
        return this._c ^ this._e << 16;
    }

    public String toString() {
        return this._c + "e" + this._e;
    }

    public static enum Unit {
        SECOND(1),
        MINUTE(60),
        HOUR(3600);

        public final int time;

        private Unit(int time) {
            this.time = time;
        }
    }
}

