/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.axtick;

import java.util.Locale;
import org.jplot2d.axtick.TickCalculator;
import org.jplot2d.util.Range;

public abstract class LongTickCalculator
extends TickCalculator {
    protected long lo;
    protected long hi;
    protected boolean inverted;

    @Override
    public Range getRange() {
        if (!this.inverted) {
            return new Range.Long(this.lo, this.hi);
        }
        return new Range.Long(this.hi, this.lo);
    }

    @Override
    public void setRange(Range range) {
        if (range instanceof Range.Long) {
            long start = ((Range.Long)range).start;
            long end = ((Range.Long)range).end;
            this.setRange(start, end);
        } else {
            double start = range.getStart();
            double end = range.getEnd();
            if (Double.isNaN(start) || Double.isInfinite(start) || Double.isNaN(end) || Double.isInfinite(end)) {
                throw new IllegalArgumentException("Range cannot start or end on NaN/Infinite value");
            }
            if (start < end) {
                this.setRange((long)Math.floor(start), (long)Math.ceil(end));
            } else {
                this.setRange((long)Math.ceil(start), (long)Math.floor(end));
            }
        }
    }

    protected void setRange(long start, long end) {
        boolean inverted;
        boolean bl = inverted = start > end;
        if (!inverted) {
            this.lo = start;
            this.hi = end;
        } else {
            this.lo = end;
            this.hi = start;
        }
    }

    public abstract long[] getValues();

    public abstract long[] getMinorValues();

    @Override
    public void calcValuesByTickInterval(double interval, double offset, int minorTickNumber) {
        this.calcValuesByTickInterval(Math.round(interval), Math.round(offset), minorTickNumber);
    }

    public abstract void calcValuesByTickInterval(long var1, long var3, int var5);

    @Override
    public int[] getInRangeValuesIdx(Object v) {
        if (v instanceof long[]) {
            return this.getInRangeValuesIdx((long[])v);
        }
        throw new IllegalArgumentException();
    }

    private int[] getInRangeValuesIdx(long[] v) {
        long expandLo = this.lo;
        long expandHi = this.hi;
        int[] m = new int[v.length];
        int j = 0;
        for (int i = 0; i < v.length; ++i) {
            if (expandLo > v[i] || v[i] > expandHi) continue;
            m[j++] = i;
        }
        if (j == v.length) {
            return m;
        }
        int[] result = new int[j];
        System.arraycopy(m, 0, result, 0, j);
        return result;
    }

    @Override
    public String calcLabelFormatString(Object valueArray) {
        long[] values = (long[])valueArray;
        int maxMag = Integer.MIN_VALUE;
        int maxPrec = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0L) continue;
            long v = Math.abs(values[i]);
            int mag = (int)Math.floor(Math.log10(v));
            if (maxMag < mag) {
                maxMag = mag;
            }
            String s = String.format((Locale)null, "%d", v);
            int pp1 = 0;
            for (int ci = s.length() - 1; ci >= 0; --ci) {
                if (s.charAt(ci) == '0') continue;
                pp1 = ci + 1;
                break;
            }
            if (maxPrec >= pp1) continue;
            maxPrec = pp1;
        }
        int n0 = maxMag - maxPrec + 1;
        if (n0 < 4 && maxMag < 6) {
            return "%d";
        }
        return "%." + (maxPrec - 1) + "m";
    }
}

