/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.axtick;

import java.util.Locale;
import org.jplot2d.axtick.TickCalculator;
import org.jplot2d.util.Range;

public abstract class DoubleTickCalculator
extends TickCalculator {
    protected double start;
    protected double end;

    @Override
    public final Range getRange() {
        return new Range.Double(this.start, this.end);
    }

    @Override
    public final void setRange(Range range) {
        this.setRange(range.getStart(), range.getEnd());
    }

    protected void setRange(double start, double end) {
        this.start = start;
        this.end = end;
    }

    public abstract double[] getValues();

    public abstract double[] getMinorValues();

    @Override
    public int[] getInRangeValuesIdx(Object v) {
        if (v instanceof double[]) {
            return this.getInRangeValuesIdx((double[])v);
        }
        throw new IllegalArgumentException();
    }

    private int[] getInRangeValuesIdx(double[] v) {
        double hi;
        double lo;
        boolean inverted;
        boolean bl = inverted = this.start > this.end;
        if (!inverted) {
            lo = this.start;
            hi = this.end;
        } else {
            lo = this.end;
            hi = this.start;
        }
        double expandLo = lo - Math.abs(lo) * 9.094947017729282E-13;
        double expandHi = hi + Math.abs(hi) * 9.094947017729282E-13;
        int[] m = new int[v.length];
        int j = 0;
        for (int i = 0; i < v.length; ++i) {
            if (!(expandLo <= v[i]) || !(v[i] <= expandHi)) continue;
            m[j++] = i;
        }
        if (j == v.length) {
            return m;
        }
        int[] result = new int[j];
        System.arraycopy(m, 0, result, 0, j);
        return result;
    }

    @Override
    public boolean isValidFormat(String format) {
        format = DoubleTickCalculator.convFCm2e(format);
        try {
            String.format(format, 1.0);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public String calcLabelFormatString(Object valueArray) {
        double[] values = (double[])valueArray;
        int minMag = Integer.MAX_VALUE;
        int maxMag = Integer.MIN_VALUE;
        int maxPrec = 0;
        int maxFractionDigits = 0;
        for (int i = 0; i < values.length; ++i) {
            int eidx;
            int ensi;
            if (values[i] == 0.0 || Double.isNaN(values[i]) || Double.isInfinite(values[i])) continue;
            double v = Math.abs(values[i]);
            String s = String.format((Locale)null, "%.14e", v);
            if (s.charAt(ensi = (eidx = s.lastIndexOf(101)) + 1) == '+') {
                ++ensi;
            }
            int mag = Integer.parseInt(s.substring(ensi));
            int pp1 = -1;
            for (int ci = eidx - 1; ci >= 0; --ci) {
                if (s.charAt(ci) == '0') continue;
                pp1 = ci;
                break;
            }
            if (minMag > mag) {
                minMag = mag;
            }
            if (maxMag < mag) {
                maxMag = mag;
            }
            if (maxPrec < pp1) {
                maxPrec = pp1;
            }
            if (maxFractionDigits >= pp1 - mag - 1) continue;
            maxFractionDigits = pp1 - mag - 1;
        }
        int n0 = minMag >= 0 ? maxMag - maxPrec + 1 : (maxMag <= 0 ? -minMag : maxMag - minMag);
        if (n0 < 4 && minMag >= -4 && maxMag < 6) {
            return "%." + maxFractionDigits + "f";
        }
        return "%." + (maxPrec - 1) + "m";
    }

    public static String convFCm2e(String format) {
        int mathConversionIdx = format.indexOf("m", 1);
        if (mathConversionIdx != -1) {
            StringBuffer newFormat = new StringBuffer(format);
            newFormat.setCharAt(mathConversionIdx, 'e');
            format = newFormat.toString();
        }
        return format;
    }
}

