/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.axtick;

import org.jplot2d.axtick.DoubleInterval;

public final class ArcDmsInterval
implements DoubleInterval {
    private final int _c;
    private final int _e;
    private final Unit _unit;

    public ArcDmsInterval(int coefficient, int exponent) {
        this._unit = Unit.SECOND;
        this._c = coefficient;
        this._e = exponent;
    }

    public ArcDmsInterval(Unit unit, int value) {
        this._unit = unit;
        this._c = value;
        this._e = 0;
    }

    public Unit getUnit() {
        return this._unit;
    }

    public int getCoefficient() {
        return this._c;
    }

    public int getExponent() {
        return this._e;
    }

    @Override
    public double doubleValue() {
        return Math.pow(10.0, this._e) * (double)this._c * this._unit.angle;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ArcDmsInterval)) {
            return false;
        }
        ArcDmsInterval ien = (ArcDmsInterval)obj;
        return this._c == ien._c && this._e == ien._e;
    }

    public int hashCode() {
        return this._c ^ this._e << 16;
    }

    public String toString() {
        return this._c + "e" + this._e;
    }

    public static enum Unit {
        SECOND(2.777777777777778E-4),
        MINUTE(0.016666666666666666),
        DEGREE(1.0);

        public final double angle;

        private Unit(double angle) {
            this.angle = angle;
        }
    }
}

