/*
 * Decompiled with CFR 0.152.
 */
package sharptools;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NumberField
extends JTextField {
    private boolean positiveOnly;
    private boolean integer;

    public NumberField(int columns) {
        super(columns);
        this.setDocument(new NumberFilterDocument());
    }

    public NumberField(int columns, boolean positive) {
        this(columns);
        this.positiveOnly = positive;
        this.setDocument(new NumberFilterDocument());
    }

    public NumberField(int columns, boolean positive, boolean integer) {
        this(columns);
        this.positiveOnly = positive;
        this.integer = integer;
        this.setDocument(new NumberFilterDocument());
    }

    public NumberField(boolean positive, boolean integer) {
        this.positiveOnly = positive;
        this.integer = integer;
        this.setDocument(new NumberFilterDocument());
    }

    public Float getNumber() {
        try {
            return new Float(Float.parseFloat(this.getText()));
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setNumber(Float f) {
        if (f == null) {
            this.setText(null);
        } else {
            this.setText(f.toString());
        }
    }

    public Integer getInteger() {
        try {
            return new Integer(Integer.parseInt(this.getText()));
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setInteger(Integer i) {
        if (i == null) {
            this.setText(null);
        } else {
            this.setText(i.toString());
        }
    }

    class NumberFilterDocument
    extends PlainDocument {
        private StringBuffer __scratchBuffer = new StringBuffer();

        @Override
        public void insertString(int offset, String text, AttributeSet aset) throws BadLocationException {
            float value;
            if (text == null) {
                return;
            }
            this.__scratchBuffer.setLength(0);
            try {
                this.__scratchBuffer.append(this.getText(0, this.getLength()));
                this.__scratchBuffer.insert(offset, text);
                this.__scratchBuffer.append('0');
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                return;
            }
            catch (StringIndexOutOfBoundsException sioobe) {
                sioobe.printStackTrace();
                return;
            }
            try {
                value = NumberField.this.integer ? (float)Integer.parseInt(this.__scratchBuffer.toString()) : Float.parseFloat(this.__scratchBuffer.toString());
            }
            catch (NumberFormatException nfe) {
                return;
            }
            if (NumberField.this.positiveOnly && value < 0.0f) {
                return;
            }
            super.insertString(offset, text, aset);
        }
    }
}

