/*
 * Decompiled with CFR 0.152.
 */
package sharptools;

import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import sharptools.Config;
import sharptools.NumberField;
import sharptools.SharpDialog;
import sharptools.SharpOptionPane;
import sharptools.SharpTools;

public class NewFileDialog
extends SharpDialog {
    private int rows;
    private int cols;
    private static final ImageIcon newFileIcon = SharpTools.getImageIcon("new32.gif");
    final NumberField rowField;
    final NumberField colField;
    final JCheckBox saveDefault;

    public NewFileDialog(JFrame aFrame, int initrows, int initcols) {
        super(aFrame, "New", true);
        JLabel msgString1 = new JLabel("Rows: ");
        JLabel msgString2 = new JLabel("Columns: ");
        this.rowField = new NumberField(5, true, true);
        this.colField = new NumberField(5, true, true);
        msgString1.setLabelFor(this.rowField);
        msgString2.setLabelFor(this.colField);
        msgString1.setDisplayedMnemonic(82);
        msgString2.setDisplayedMnemonic(67);
        this.saveDefault = new JCheckBox("Save as default", false);
        this.saveDefault.setMnemonic(83);
        this.rowField.setText(String.valueOf(initrows));
        this.colField.setText(String.valueOf(initcols));
        Object[] input = new Object[]{msgString1, this.rowField, msgString2, this.colField, this.saveDefault};
        this.setOptionPane(input, 3, 2, newFileIcon);
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.cols;
    }

    private void newFileError(String error, JTextField com) {
        SharpOptionPane.showMessageDialog(this, error, "Error", 0);
        com.selectAll();
        com.requestFocus();
    }

    @Override
    protected boolean onOK() {
        try {
            this.rows = this.rowField.getInteger();
        }
        catch (Exception e1) {
            this.rows = 0;
        }
        if (this.rows <= 0) {
            this.newFileError("Invalid row value", this.rowField);
            return false;
        }
        try {
            this.cols = this.colField.getInteger();
        }
        catch (Exception e2) {
            this.cols = 0;
        }
        if (this.cols <= 0) {
            this.newFileError("Invalid column value", this.colField);
            return false;
        }
        if (this.saveDefault.isSelected()) {
            Config config = SharpTools.getConfig();
            config.setInt("ROWS", this.rows);
            config.setInt("COLUMNS", this.cols);
        }
        return true;
    }

    @Override
    protected boolean onCancel() {
        this.cols = 0;
        this.rows = 0;
        return true;
    }

    @Override
    protected void onOpen() {
        this.rowField.selectAll();
        this.rowField.requestFocus();
    }

    @Override
    protected boolean onClose() {
        this.cols = 0;
        this.rows = 0;
        return true;
    }
}

