/*
 * Decompiled with CFR 0.152.
 */
package sharptools;

import sharptools.CellRange;
import sharptools.Debug;
import sharptools.SharpClipboard;
import sharptools.SharpTableModel;
import sharptools.SharpTools;

public class History {
    private SharpTools sharp;
    public static final int UNCHANGED = 0;
    public static final int INSERTROW = 1;
    public static final int INSERTCOLUMN = 2;
    public static final int REMOVEROW = 3;
    public static final int REMOVECOLUMN = 4;
    private ListNode current;

    History(SharpTools sharp) {
        this.sharp = sharp;
        this.current = new ListNode(null);
    }

    public void add(SharpTableModel model, CellRange range) {
        SharpClipboard clip = new SharpClipboard(model, range, false);
        this.add(model, clip);
    }

    public void add(SharpTableModel model, SharpClipboard clip) {
        ListNode node = new ListNode(clip);
        if (Debug.isDebug()) {
            Debug.println("Add history for range " + clip.getSource());
        }
        this.current.setNext(node);
        node.setPrev(this.current);
        this.current = node;
        model.setModified(true);
        this.sharp.checkUndoRedoState();
    }

    public void add(SharpTableModel model, CellRange range, int type) {
        ListNode node;
        if (type == 0) {
            this.add(model, range);
            return;
        }
        if (type == 3 || type == 4) {
            SharpClipboard clip = new SharpClipboard(model, range, false);
            node = new ListNode(clip);
        } else {
            node = new ListNode(range);
        }
        node.setType(type);
        this.current.setNext(node);
        node.setPrev(this.current);
        this.current = node;
        model.setModified(true);
        this.sharp.checkUndoRedoState();
    }

    public void undo(SharpTableModel model) {
        CellRange range;
        if (!this.isUndoable()) {
            return;
        }
        int type = this.current.getType();
        if (type == 0) {
            SharpClipboard oldClip = (SharpClipboard)this.current.getObject();
            range = oldClip.getSource();
            SharpClipboard newClip = new SharpClipboard(model, range, false);
            this.current.setObject(newClip);
            oldClip.paste(model, range.getminCorner());
        } else if (type == 3 || type == 4) {
            SharpClipboard clip = (SharpClipboard)this.current.getObject();
            range = clip.getSource();
            if (type == 3) {
                model.insertRow(range);
            } else {
                model.insertColumn(range);
            }
            clip.paste(model, range.getminCorner());
        } else {
            range = (CellRange)this.current.getObject();
            if (type == 1) {
                model.removeRow(range);
            } else {
                model.removeColumn(range);
            }
        }
        this.current = this.current.getPrev();
        model.setSelection(range);
        model.setModified(true);
        this.sharp.checkUndoRedoState();
    }

    public void redo(SharpTableModel model) {
        if (!this.isRedoable()) {
            return;
        }
        this.current = this.current.getNext();
        int type = this.current.getType();
        if (type == 0) {
            SharpClipboard oldClip = (SharpClipboard)this.current.getObject();
            CellRange range = oldClip.getSource();
            SharpClipboard newClip = new SharpClipboard(model, range, false);
            this.current.setObject(newClip);
            oldClip.paste(model, range.getminCorner());
            model.setSelection(range);
        } else if (type == 3 || type == 4) {
            SharpClipboard clip = (SharpClipboard)this.current.getObject();
            CellRange range = clip.getSource();
            if (type == 3) {
                model.removeRow(range);
            } else {
                model.removeColumn(range);
            }
        } else {
            CellRange range = (CellRange)this.current.getObject();
            if (type == 1) {
                model.insertRow(range);
            } else {
                model.insertColumn(range);
            }
        }
        model.setModified(true);
        this.sharp.checkUndoRedoState();
    }

    public boolean isUndoable() {
        return this.current.getPrev() != null;
    }

    public boolean isRedoable() {
        return this.current.getNext() != null;
    }

    class ListNode {
        private ListNode prev;
        private ListNode next;
        private int type;
        private Object obj;

        ListNode(Object obj) {
            this.setObject(obj);
        }

        Object getObject() {
            return this.obj;
        }

        ListNode getPrev() {
            return this.prev;
        }

        ListNode getNext() {
            return this.next;
        }

        void setObject(Object obj) {
            this.obj = obj;
        }

        void setPrev(ListNode prev) {
            this.prev = prev;
        }

        void setNext(ListNode next) {
            this.next = next;
        }

        int getType() {
            return this.type;
        }

        void setType(int type) {
            this.type = type;
        }
    }
}

