/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.Iterator;
import java.util.Set;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public abstract class AbstractDiffCallback {
    private SVNAdminArea myAdminArea;
    private File myBasePath;
    private Set myDeletedPaths;

    protected AbstractDiffCallback(SVNAdminArea adminArea) {
        this.myAdminArea = adminArea;
    }

    public void setBasePath(File path) {
        this.myBasePath = path;
    }

    public abstract boolean isDiffUnversioned();

    public abstract boolean isDiffCopiedAsAdded();

    public abstract File createTempDirectory() throws SVNException;

    public abstract SVNStatusType propertiesChanged(String var1, SVNProperties var2, SVNProperties var3, boolean[] var4) throws SVNException;

    public abstract SVNStatusType[] fileChanged(String var1, File var2, File var3, long var4, long var6, String var8, String var9, SVNProperties var10, SVNProperties var11, boolean[] var12) throws SVNException;

    public abstract SVNStatusType[] fileAdded(String var1, File var2, File var3, long var4, long var6, String var8, String var9, SVNProperties var10, SVNProperties var11, boolean[] var12) throws SVNException;

    public abstract SVNStatusType fileDeleted(String var1, File var2, File var3, String var4, String var5, SVNProperties var6, boolean[] var7) throws SVNException;

    public abstract SVNStatusType directoryAdded(String var1, long var2, boolean[] var4) throws SVNException;

    public abstract SVNStatusType directoryDeleted(String var1, boolean[] var2) throws SVNException;

    public abstract void directoryOpened(String var1, long var2, boolean[] var4) throws SVNException;

    public abstract SVNStatusType[] directoryClosed(String var1, boolean[] var2) throws SVNException;

    protected String getDisplayPath(String path) {
        if (this.myAdminArea == null) {
            if (this.myBasePath != null) {
                return new File(this.myBasePath, path).getAbsolutePath().replace(File.separatorChar, '/');
            }
            return path.replace(File.separatorChar, '/');
        }
        return this.myAdminArea.getFile(path).getAbsolutePath().replace(File.separatorChar, '/');
    }

    protected void categorizeProperties(SVNProperties original, SVNProperties regular, SVNProperties entry, SVNProperties wc) {
        if (original == null) {
            return;
        }
        Iterator propNames = original.nameSet().iterator();
        while (propNames.hasNext()) {
            String name = (String)propNames.next();
            if (regular != null && SVNProperty.isRegularProperty(name)) {
                regular.put(name, original.getSVNPropertyValue(name));
                continue;
            }
            if (entry != null && SVNProperty.isEntryProperty(name)) {
                entry.put(name, original.getSVNPropertyValue(name));
                continue;
            }
            if (wc == null || !SVNProperty.isWorkingCopyProperty(name)) continue;
            wc.put(name, original.getSVNPropertyValue(name));
        }
    }

    protected SVNAdminArea getAdminArea() {
        return this.myAdminArea;
    }

    protected SVNWCAccess getWCAccess() {
        return this.getAdminArea().getWCAccess();
    }

    protected void addDeletedPath(String path) {
        if (this.myDeletedPaths == null) {
            this.myDeletedPaths = new SVNHashSet();
        }
        this.myDeletedPaths.add(path);
    }

    protected boolean isPathDeleted(String path) {
        return this.myDeletedPaths != null && this.myDeletedPaths.contains(path);
    }

    protected void clearDeletedPaths() {
        this.myDeletedPaths = null;
    }
}

