/*
 * Decompiled with CFR 0.152.
 */
package tabclose;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;
import tabclose.CloseTabPaneUI;

public class CloseTabPaneEnhancedUI
extends CloseTabPaneUI {
    private static final Color whiteColor = Color.white;
    private static final Color transparent = new Color(1593014);
    private static final Color nearBlack = new Color(0, 0, 0, 80);
    private static final Color lightBlue = new Color(9218559);
    private static final Color lightWhite = new Color(150, 150, 150, 50);
    private static final Color selectedColor = new Color(15, 70, 180);

    public static ComponentUI createUI(JComponent c) {
        return new CloseTabPaneEnhancedUI();
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(this.shadow);
        g.drawLine(x, y + 2, x, y + h - 1);
        g.drawLine(x + 1, y + 1, x + 1, y + 1);
        g.drawLine(x + 2, y, x + w - 3, y);
        g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 1);
        g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
        if (isSelected) {
            g.setColor(this.lightHighlight);
            g.drawLine(x + 2, y + 2, x + 2, y + h - 1);
            g.drawLine(x + 3, y + 1, x + w - 3, y + 1);
            g.drawLine(x + w - 3, y + 2, x + w - 3, y + 2);
            g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 1);
        }
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (this.tabPane.getTabCount() < 1) {
            return;
        }
        g.setColor(this.shadow);
        g.drawLine(x, y, x + w - 2, y);
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (this.tabPane.getTabCount() < 1) {
            return;
        }
        g.setColor(this.shadow);
        g.drawLine(x, y, x, y + h - 3);
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (this.tabPane.getTabCount() < 1) {
            return;
        }
        g.setColor(this.shadow);
        g.drawLine(x + 1, y + h - 3, x + w - 2, y + h - 3);
        g.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
        g.setColor(this.shadow.brighter());
        g.drawLine(x + 2, y + h - 1, x + w - 1, y + h - 1);
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (this.tabPane.getTabCount() < 1) {
            return;
        }
        g.setColor(this.shadow);
        g.drawLine(x + w - 3, y + 1, x + w - 3, y + h - 3);
        g.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 3);
        g.setColor(this.shadow.brighter());
        g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 2);
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (isSelected) {
            GradientPaint rightGradient;
            GradientPaint leftGradient;
            int delta = 10;
            int delta2 = 8;
            if (this.isCloseEnabled()) {
                delta += 21;
                delta2 += 16;
            }
            if (this.tabPane.isEnabledAt(tabIndex)) {
                leftGradient = new GradientPaint(x, y, selectedColor, x + w / 2, y, lightBlue);
                rightGradient = new GradientPaint(x + w / 2, y, lightBlue, x + w + delta, y, transparent);
            } else {
                leftGradient = new GradientPaint(x, y, this.shadow, x + w / 2, y, lightWhite);
                rightGradient = new GradientPaint(x + w / 2, y, lightWhite, x + w + delta, y, transparent);
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(leftGradient);
            g2.fillRect(x + 2, y + 2, w / 2, h - 2);
            g2.setPaint(rightGradient);
            g2.fillRect(x + 2 + w / 2, y + 2, w / 2 - delta2, h - 2);
        }
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                if (isSelected) {
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setColor(nearBlack);
                    g2d.drawString(title, textRect.x + 1, textRect.y + metrics.getAscent() + 1);
                    g.setColor(whiteColor);
                } else {
                    g.setColor(this.tabPane.getForegroundAt(tabIndex));
                }
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            } else {
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x - 1, textRect.y + metrics.getAscent() - 1);
            }
        }
    }

    @Override
    protected CloseTabPaneUI.ScrollableTabButton createScrollableTabButton(int direction) {
        return new ScrollableTabButton(direction);
    }

    protected class ScrollableTabButton
    extends CloseTabPaneUI.ScrollableTabButton {
        public ScrollableTabButton(int direction) {
            super(CloseTabPaneEnhancedUI.this, direction);
            this.setRolloverEnabled(true);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(16, CloseTabPaneEnhancedUI.this.calculateMaxTabHeight(0));
        }

        @Override
        public void paint(Graphics g) {
            int w = this.getSize().width;
            int h = this.getSize().height;
            Color origColor = g.getColor();
            boolean isPressed = this.getModel().isPressed();
            boolean isRollOver = this.getModel().isRollover();
            boolean isEnabled = this.isEnabled();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, w, h);
            g.setColor(CloseTabPaneEnhancedUI.this.shadow);
            if (this.direction == 7) {
                g.drawLine(0, 0, 0, h - 1);
                g.drawLine(w - 1, 0, w - 1, 0);
            } else {
                g.drawLine(w - 2, h - 1, w - 2, 0);
            }
            g.drawLine(0, 0, w - 2, 0);
            if (isRollOver) {
                Color color1;
                Color color2;
                if (isPressed) {
                    color2 = whiteColor;
                    color1 = CloseTabPaneEnhancedUI.this.shadow;
                } else {
                    color1 = whiteColor;
                    color2 = CloseTabPaneEnhancedUI.this.shadow;
                }
                g.setColor(color1);
                if (this.direction == 7) {
                    g.drawLine(1, 1, 1, h - 1);
                    g.drawLine(1, 1, w - 2, 1);
                    g.setColor(color2);
                    g.drawLine(w - 1, h - 1, w - 1, 1);
                } else {
                    g.drawLine(0, 1, 0, h - 1);
                    g.drawLine(0, 1, w - 3, 1);
                    g.setColor(color2);
                    g.drawLine(w - 3, h - 1, w - 3, 1);
                }
            }
            if (h < 5 || w < 5) {
                g.setColor(origColor);
                return;
            }
            if (isPressed) {
                g.translate(1, 1);
            }
            int size = Math.min((h - 4) / 3, (w - 4) / 3);
            size = Math.max(size, 2);
            this.paintTriangle(g, (w - size) / 2, (h - size) / 2, size, this.direction, isEnabled);
            if (isPressed) {
                g.translate(-1, -1);
            }
            g.setColor(origColor);
        }
    }
}

