/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.finder;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class DocumentFixedCharSequence
implements CharSequence {
    private Document document;
    private int start;
    private int end;

    public DocumentFixedCharSequence(Document doc) {
        this(doc, 0, doc.getLength());
    }

    public DocumentFixedCharSequence(Document doc, int start, int end2) {
        this.document = doc;
        this.start = start;
        this.end = end2;
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public char charAt(int index) {
        try {
            return this.document.getText(this.start + index, 1).charAt(0);
        }
        catch (BadLocationException e) {
            throw new IndexOutOfBoundsException(e.getLocalizedMessage());
        }
    }

    @Override
    public CharSequence subSequence(int start, int end2) {
        return new DocumentFixedCharSequence(this.document, this.start + start, this.start + end2);
    }

    @Override
    public String toString() {
        try {
            return this.document.getText(this.start, this.length());
        }
        catch (BadLocationException e) {
            throw new IndexOutOfBoundsException(e.getLocalizedMessage());
        }
    }

    public Document getDocument() {
        return this.document;
    }
}

