/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.event;

import java.text.MessageFormat;
import org.dts.spell.event.SpellCheckAdapter;
import org.dts.spell.event.SpellCheckEvent;
import org.dts.spell.finder.Word;
import org.dts.spell.swing.JSpellDialog;
import org.dts.spell.swing.utils.ErrorMsgBox;
import org.dts.spell.swing.utils.Messages;

public class UISpellCheckListener
extends SpellCheckAdapter {
    private JSpellDialog spellDialog;

    public JSpellDialog getSpellDialog() {
        return this.spellDialog;
    }

    public void setSpellDialog(JSpellDialog spellDialog) {
        this.spellDialog = spellDialog;
    }

    public UISpellCheckListener() {
        this(null);
    }

    public UISpellCheckListener(JSpellDialog spellDialog) {
        this.setSpellDialog(spellDialog);
    }

    @Override
    public void beginChecking(SpellCheckEvent event) {
        if (this.getSpellDialog() == null) {
            this.setSpellDialog(new JSpellDialog());
        }
    }

    @Override
    public void spellingError(SpellCheckEvent event) {
        JSpellDialog dlg = this.getSpellDialog();
        if (!dlg.showDialog(event.getSpellChecker(), event.getWordFinder())) {
            event.cancel();
        }
    }

    @Override
    public void badCaseError(SpellCheckEvent event) {
        Word word = event.getCurrentWord();
        String newWord = word.getStartSentenceWordCase();
        String msg = MessageFormat.format(Messages.getString("ERROR_CAPITALIZATION_STRING"), word, newWord);
        int result = ErrorMsgBox.yesNoCancelMsg(Messages.getString("ERROR_CAPITALIZATION_TITLE_STRING"), msg);
        switch (result) {
            case 0: {
                event.getWordFinder().replace(newWord);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                event.cancel();
            }
        }
    }

    @Override
    public void repeatWordError(SpellCheckEvent event) {
        Word word = event.getCurrentWord();
        String msg = MessageFormat.format(Messages.getString("ERROR_REPEAT_WORD_STRING"), word);
        int result = ErrorMsgBox.yesNoCancelMsg(Messages.getString("ERROR_REPEAT_WORD_TITLE_STRING"), msg);
        switch (result) {
            case 0: {
                event.getWordFinder().replace("");
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                event.cancel();
            }
        }
    }
}

