/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.finder;

public class Word
implements CharSequence {
    private int start;
    private String text;
    private boolean isStart;

    public Word(String text, int start, boolean isStart) {
        this.text = text;
        this.start = start;
        this.isStart = isStart;
    }

    public Word(String text, int start) {
        this(text, start, false);
    }

    public int getEnd() {
        return this.getStart() + this.length();
    }

    public int getStart() {
        return this.start;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public int length() {
        return this.text.length();
    }

    @Override
    public String toString() {
        return this.text;
    }

    public boolean isStartOfSentence() {
        return this.isStart;
    }

    public void setStartStartOfSentence(boolean isStart) {
        this.isStart = isStart;
    }

    public boolean isCorrectFirstChar() {
        char c = this.text.charAt(0);
        if (Character.isLetter(c)) {
            if (this.isStartOfSentence()) {
                return Character.isUpperCase(c);
            }
            return Character.isLowerCase(c);
        }
        return true;
    }

    public boolean isUpperCase() {
        return this.text.toUpperCase().equals(this.text);
    }

    public boolean equals(Object o) {
        if (null != o && o instanceof Word) {
            Word ow = (Word)o;
            return ow.getStart() == this.getStart() && ow.getText().equals(this.getText());
        }
        return false;
    }

    @Override
    public char charAt(int index) {
        return this.text.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end2) {
        return this.text.subSequence(start, end2);
    }

    public String getStartSentenceWordCase() {
        return Word.getStartSentenceWordCase(this);
    }

    public static String getStartSentenceWordCase(CharSequence word) {
        StringBuilder str = new StringBuilder(word);
        str.setCharAt(0, Character.toUpperCase(word.charAt(0)));
        return str.toString();
    }
}

