/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.dictionary.myspell;

import org.dts.spell.dictionary.myspell.AffEntry;
import org.dts.spell.dictionary.myspell.AffixMgr;
import org.dts.spell.dictionary.myspell.HEntry;
import org.dts.spell.dictionary.myspell.PfxEntry;
import org.dts.spell.dictionary.myspell.Utils;

public class SfxEntry
extends AffEntry {
    AffixMgr pmyMgr;
    String rappnd;
    SfxEntry next;
    SfxEntry nexteq;
    SfxEntry nextne;
    SfxEntry flgnxt;

    public SfxEntry(AffixMgr pmgr, AffEntry dp) {
        this.pmyMgr = pmgr;
        this.achar = dp.achar;
        this.strip = dp.strip;
        this.appnd = dp.appnd;
        this.numconds = dp.numconds;
        this.xpflg = dp.xpflg;
        System.arraycopy(dp.conds, 0, this.conds, 0, Utils.SETSIZE);
        this.rappnd = Utils.myRevStrDup(this.appnd);
    }

    public HEntry check(String word, int optflags, AffEntry ppfx) {
        int len = word.length();
        int appndl = this.appnd.length();
        int stripl = this.strip.length();
        PfxEntry ep = (PfxEntry)ppfx;
        if ((optflags & Utils.XPRODUCT) != 0 && (this.xpflg & Utils.XPRODUCT) == 0) {
            return null;
        }
        int tmpl = len - appndl;
        if (tmpl > 0 && tmpl + stripl >= this.numconds) {
            HEntry he;
            int cp = tmpl + stripl;
            String tmpword = word.substring(0, tmpl) + this.strip;
            int cond = this.numconds;
            while (--cond >= 0 && (this.conds[tmpword.charAt(--cp)] & 1 << cond) != 0) {
            }
            if (cond < 0 && (he = this.pmyMgr.lookup(tmpword)) != null && Utils.TestAff(he.astr, this.achar, he.astr.length()) && ((optflags & Utils.XPRODUCT) == 0 || Utils.TestAff(he.astr, ep.getFlag(), he.astr.length()))) {
                return he;
            }
        }
        return null;
    }

    public boolean allowCross() {
        return (this.xpflg & Utils.XPRODUCT) != 0;
    }

    public char getFlag() {
        return this.achar;
    }

    public String getKey() {
        return this.rappnd;
    }

    public String add(String word) {
        int stripl;
        int len = word.length();
        if (len > (stripl = this.strip.length()) && len >= this.numconds) {
            int cp = len;
            int cond = this.numconds;
            while (--cond >= 0 && (this.conds[word.charAt(--cp)] & 1 << cond) != 0) {
            }
            if (cond < 0) {
                return word.substring(0, len - stripl) + this.appnd;
            }
        }
        return null;
    }

    public SfxEntry getNext() {
        return this.next;
    }

    public SfxEntry getNextNE() {
        return this.nextne;
    }

    public SfxEntry getNextEQ() {
        return this.nexteq;
    }

    public SfxEntry getFlgNxt() {
        return this.flgnxt;
    }

    public void setNext(SfxEntry ptr) {
        this.next = ptr;
    }

    public void setNextNE(SfxEntry ptr) {
        this.nextne = ptr;
    }

    public void setNextEQ(SfxEntry ptr) {
        this.nexteq = ptr;
    }

    public void setFlgNxt(SfxEntry ptr) {
        this.flgnxt = ptr;
    }
}

