/*
 * Decompiled with CFR 0.152.
 */
package net.hep.graphics.ObjectBrowser.Reflector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import net.hep.graphics.ObjectBrowser.Browser.BrowserBroker;
import net.hep.graphics.ObjectBrowser.Browser.DocBrowser;
import net.hep.graphics.ObjectBrowser.Browser.DocModelNode;
import net.hep.graphics.ObjectBrowser.Browser.HierarchyModelNode;
import net.hep.graphics.ObjectBrowser.Browser.ModelContext;
import net.hep.graphics.ObjectBrowser.Browser.ObjectRep;
import net.hep.graphics.ObjectBrowser.Browser.Property;
import net.hep.graphics.ObjectBrowser.Browser.PropertyBrowser;
import net.hep.graphics.ObjectBrowser.Browser.PropertyGroup;
import net.hep.graphics.ObjectBrowser.Browser.PropertyModelNode;
import net.hep.graphics.ObjectBrowser.Browser.SelectionEvent;
import net.hep.graphics.ObjectBrowser.Browser.StringPropertyValue;
import net.hep.graphics.ObjectBrowser.Browser.TreeBrowser;
import net.hep.graphics.ObjectBrowser.Reflector.ObjectPanelActionListener;

public class ObjectPanel
extends JPanel {
    private boolean _doesFields = true;
    private JButton _fields = new JButton("fields");
    private boolean _doesMethodsShow = true;
    private JButton _methodsShow = new JButton("methods show");
    private boolean _doesMethodsCall = false;
    private JButton _methodsCall = new JButton("methods call");
    private boolean _doesStatics = false;
    private JButton _statics = new JButton("statics");
    private boolean _doesProtected = false;
    private JButton _protected = new JButton("protected");
    private boolean _doesInherited = true;
    private JButton _inherited = new JButton("inherited");
    private JButton _update = new JButton("Update");
    private JSplitPane _splitPane = new JSplitPane(1);
    private JSplitPane _splitPane2 = new JSplitPane(0);
    private TreeBrowser _tbrowser;
    private DocModelNode _docModel = new DocModelNode("OB");
    private BrowserBroker _broker = new BrowserBroker();
    private HierarchyModelNode _hierarchy = new HierarchyModelNode("Top Level");
    private ArrayList _topObjects = new ArrayList();
    private static String _webPage = "http://hrivnac.home.cern.ch/hrivnac/Activities/Packages/ObjectBrowser";

    public ObjectPanel() {
        this.setup();
        this.init();
    }

    public ObjectPanel(boolean doesFields, boolean doesMethodsShow, boolean doesMethodsCall, boolean doesStatics, boolean doesProtected, boolean doesInherited) {
        this._doesFields = doesFields;
        this._doesMethodsShow = doesMethodsShow;
        this._doesMethodsCall = doesMethodsCall;
        this._doesStatics = doesStatics;
        this._doesProtected = doesProtected;
        this._doesInherited = doesInherited;
        this.setup();
        this.init();
    }

    private void setup() {
        JLabel name = new JLabel("Object Browser");
        name.setFont(new Font("SansSerif", 1, 15));
        name.setForeground(Color.red);
        JLabel about = new JLabel(_webPage);
        about.setFont(new Font("SansSerif", 0, 10));
        JToolBar north = new JToolBar();
        north.addSeparator(new Dimension(10, 0));
        north.add(name);
        north.addSeparator(new Dimension(10, 0));
        north.add(about);
        north.setFloatable(false);
        north.setLayout(new BoxLayout(north, 0));
        this._fields.setFont(new Font("SansSerif", 0, 10));
        this._methodsShow.setFont(new Font("SansSerif", 0, 10));
        this._methodsCall.setFont(new Font("SansSerif", 0, 10));
        this._statics.setFont(new Font("SansSerif", 0, 10));
        this._protected.setFont(new Font("SansSerif", 0, 10));
        this._inherited.setFont(new Font("SansSerif", 0, 10));
        this._fields.addActionListener(new ObjectPanelActionListener(this));
        this._methodsShow.addActionListener(new ObjectPanelActionListener(this));
        this._methodsCall.addActionListener(new ObjectPanelActionListener(this));
        this._statics.addActionListener(new ObjectPanelActionListener(this));
        this._protected.addActionListener(new ObjectPanelActionListener(this));
        this._inherited.addActionListener(new ObjectPanelActionListener(this));
        this._methodsShow.setMinimumSize(new Dimension(110, 13));
        this._methodsShow.setMaximumSize(new Dimension(110, 13));
        this._methodsCall.setMinimumSize(new Dimension(110, 13));
        this._methodsCall.setMaximumSize(new Dimension(110, 13));
        this._fields.setToolTipText("Show/Hide fields");
        this._methodsShow.setToolTipText("Show/Hide methods without calling");
        this._methodsCall.setToolTipText("Show/Hide methods after calling (may change object' state !)");
        this._statics.setToolTipText("Show/Hide static fields & methods");
        this._protected.setToolTipText("Show/Hide invisible fields & methods");
        this._inherited.setToolTipText("Show/Hide inherited fields & methods");
        JPanel methods = new JPanel();
        methods.setLayout(new BoxLayout(methods, 1));
        methods.add(this._methodsShow);
        methods.add(this._methodsCall);
        JButton exitButton = new JButton("Exit");
        exitButton.setHorizontalTextPosition(0);
        exitButton.setMinimumSize(new Dimension(50, 20));
        exitButton.setMaximumSize(new Dimension(50, 20));
        exitButton.setFont(new Font("SansSerif", 1, 10));
        exitButton.setToolTipText("Exit Object Browser");
        exitButton.addActionListener(new ObjectPanelActionListener(this));
        this._update.setHorizontalTextPosition(0);
        this._update.setMinimumSize(new Dimension(50, 20));
        this._update.setMaximumSize(new Dimension(50, 20));
        this._update.setFont(new Font("SansSerif", 1, 10));
        this._update.setToolTipText("Update view (red, if options have changed)");
        this._update.addActionListener(new ObjectPanelActionListener(this));
        JButton dump = new JButton("Dump");
        dump.setHorizontalTextPosition(0);
        dump.setMinimumSize(new Dimension(50, 20));
        dump.setMaximumSize(new Dimension(50, 20));
        dump.setFont(new Font("SansSerif", 1, 10));
        dump.setToolTipText("Dump whole tree into stdout");
        dump.addActionListener(new ObjectPanelActionListener(this));
        JToolBar south = new JToolBar();
        south.addSeparator(new Dimension(10, 0));
        south.add(this._fields);
        south.add(methods);
        south.add(this._statics);
        south.add(this._protected);
        south.add(this._inherited);
        south.addSeparator(new Dimension(10, 0));
        south.add(this._update);
        south.addSeparator(new Dimension(10, 0));
        south.add(dump);
        south.addSeparator(new Dimension(10, 0));
        south.add(exitButton);
        south.setFloatable(false);
        south.setLayout(new BoxLayout(south, 0));
        this.setLayout(new BorderLayout());
        this.add("North", north);
        this.add("South", south);
    }

    private void init() {
        DocBrowser dbrowser = new DocBrowser(this._broker, null);
        dbrowser.component().setFont(new Font("SansSerif", 1, 15));
        dbrowser.component().setToolTipText("DocBrowser shows the Object' documentation (usually obtained by toString())");
        PropertyBrowser pbrowser = new PropertyBrowser(this._broker, null);
        pbrowser.component().setPreferredSize(new Dimension(300, 300));
        pbrowser.component().setFont(new Font("SansSerif", 0, 10));
        pbrowser.component().setToolTipText("PropertyBrowser shows the Object' properties.");
        this._splitPane2.add(dbrowser.component());
        this._splitPane2.add(pbrowser.component());
        this.setStatus();
        this.update();
        this._splitPane.add(this._splitPane2);
        this.add("Center", this._splitPane);
        this._broker.sendSelectionEvent(new SelectionEvent(this._hierarchy.context()));
    }

    void update() {
        this._hierarchy = new HierarchyModelNode("Top Level");
        ObjectRep o = new ObjectRep();
        o.add(new ModelContext(this._hierarchy));
        o.add(new ModelContext(this._docModel));
        if (this._tbrowser != null) {
            this._splitPane.remove(this._tbrowser.component());
        }
        this._tbrowser = new TreeBrowser(this._broker, this._hierarchy);
        this._tbrowser.component().setMinimumSize(new Dimension(100, 50));
        this._tbrowser.component().setPreferredSize(new Dimension(100, 100));
        this._tbrowser.component().setFont(new Font("SansSerif", 0, 10));
        this._tbrowser.component().setToolTipText("TreeBrowser shows the Object' hierarchy.");
        this._splitPane.add(this._tbrowser.component());
        Object[] objects = this._topObjects.toArray();
        for (int i = 0; i < objects.length; ++i) {
            this.add0(objects[i]);
        }
        this._update.setBackground(Color.lightGray);
    }

    void dump() {
        Object[] objects = this._topObjects.toArray();
        for (int i = 0; i < objects.length; ++i) {
            System.out.println(objects[i].getClass().getName() + ": " + objects[i]);
        }
    }

    public void add(Object object) {
        this._topObjects.add(object);
        this.add0(object);
    }

    private void add0(Object object) {
        int i;
        if (this.testCollections(object, object.getClass().getName())) {
            return;
        }
        String oName = object.getClass().getName();
        oName = oName.substring(oName.lastIndexOf(".") + 1);
        ObjectRep o = new ObjectRep();
        HierarchyModelNode h = this._hierarchy;
        this._hierarchy = new HierarchyModelNode(oName);
        h.add(this._hierarchy);
        o.add(new ModelContext(this._hierarchy));
        DocModelNode d = new DocModelNode(object.toString());
        o.add(new ModelContext(d));
        PropertyModelNode pr = new PropertyModelNode();
        o.add(new ModelContext(pr));
        if (this._doesFields) {
            PropertyGroup gFields = new PropertyGroup("Fields");
            pr.addGroup(gFields);
            AccessibleObject[] fields = object.getClass().getFields();
            Field.setAccessible(fields, true);
            for (i = 0; i < Array.getLength(fields); ++i) {
                if (!(this._doesStatics | !Modifier.isStatic(((Field)fields[i]).getModifiers()))) continue;
                this.testCollections(fields[i], ((Field)fields[i]).getName());
                try {
                    gFields.addProperty(new Property(gFields, "(" + Modifier.toString(((Field)fields[i]).getModifiers()) + " " + ((Field)fields[i]).getType().getName() + ") " + ((Field)fields[i]).getDeclaringClass().getName() + "." + ((Field)fields[i]).getName(), new StringPropertyValue(((Field)fields[i]).get(object).toString())));
                    continue;
                }
                catch (IllegalAccessException e) {
                    System.err.println("ERROR(ObjectPanel): can't get " + oName + "." + ((Field)fields[i]).getName());
                }
            }
            fields = object.getClass().getDeclaredFields();
            Field.setAccessible(fields, true);
            for (int i2 = 0; i2 < Array.getLength(fields); ++i2) {
                if (!((this._doesProtected | ((Field)fields[i2]).getDeclaringClass() != object.getClass()) & (this._doesStatics | !Modifier.isStatic(((Field)fields[i2]).getModifiers())) & (this._doesInherited | ((Field)fields[i2]).getDeclaringClass() == object.getClass()))) continue;
                try {
                    Object fieldsObject = ((Field)fields[i2]).get(object);
                    if (fieldsObject == null) continue;
                    this.testCollections(fieldsObject, ((Field)fields[i2]).getName());
                    gFields.addProperty(new Property(gFields, "(" + Modifier.toString(((Field)fields[i2]).getModifiers()) + " " + ((Field)fields[i2]).getType().getName() + ") " + ((Field)fields[i2]).getName(), new StringPropertyValue(fieldsObject.toString())));
                    continue;
                }
                catch (IllegalAccessException e) {
                    System.err.println("ERROR(ObjectPanel): can't get " + oName + "." + ((Field)fields[i2]).getName());
                }
            }
        }
        if (this._doesMethodsShow | this._doesMethodsCall) {
            PropertyGroup gMethods = new PropertyGroup("Methods()");
            pr.addGroup(gMethods);
            AccessibleObject[] methods = object.getClass().getMethods();
            Method.setAccessible(methods, true);
            for (i = 0; i < Array.getLength(methods); ++i) {
                if (!((this._doesStatics | !Modifier.isStatic(((Method)methods[i]).getModifiers())) & !((Method)methods[i]).getName().equals("toString"))) continue;
                if (Array.getLength(((Method)methods[i]).getParameterTypes()) == 0 & !((Method)methods[i]).getReturnType().getName().equals("void")) {
                    this.testCollections(methods[i], ((Method)methods[i]).getName());
                    try {
                        if (this._doesMethodsCall) {
                            gMethods.addProperty(new Property(gMethods, "(" + Modifier.toString(((Method)methods[i]).getModifiers()) + " " + ((Method)methods[i]).getReturnType().getName() + ") " + ((Method)methods[i]).getDeclaringClass().getName() + "." + ((Method)methods[i]).getName(), new StringPropertyValue(((Method)methods[i]).invoke(object, new Object[0]).toString())));
                            continue;
                        }
                        gMethods.addProperty(new Property(gMethods, "(" + Modifier.toString(((Method)methods[i]).getModifiers()) + " " + ((Method)methods[i]).getReturnType().getName() + ") " + ((Method)methods[i]).getDeclaringClass().getName() + "." + ((Method)methods[i]).getName(), new StringPropertyValue("???")));
                    }
                    catch (IllegalAccessException e) {
                        System.err.println("ERROR(ObjectPanel): can't invoke " + oName + "." + ((Method)methods[i]).getName() + "()");
                    }
                    catch (InvocationTargetException e) {
                        System.err.println("ERROR(ObjectPanel): can't invoke " + oName + "." + ((Method)methods[i]).getName() + "()");
                    }
                    continue;
                }
                gMethods.addProperty(new Property(gMethods, "(" + Modifier.toString(((Method)methods[i]).getModifiers()) + " " + ((Method)methods[i]).getReturnType().getName() + ") " + ((Method)methods[i]).getName(), new StringPropertyValue("NA")));
            }
            methods = object.getClass().getDeclaredMethods();
            Method.setAccessible(methods, true);
            for (int i3 = 0; i3 < Array.getLength(methods); ++i3) {
                if (!((this._doesProtected | ((Method)methods[i3]).getDeclaringClass() != object.getClass()) & (this._doesStatics | !Modifier.isStatic(((Method)methods[i3]).getModifiers())) & (this._doesInherited | ((Method)methods[i3]).getDeclaringClass() == object.getClass()) & !((Method)methods[i3]).getName().equals("toString"))) continue;
                if (Array.getLength(((Method)methods[i3]).getParameterTypes()) == 0 & !((Method)methods[i3]).getReturnType().getName().equals("void")) {
                    try {
                        Object methodsObject = this._doesMethodsCall ? ((Method)methods[i3]).invoke(object, new Object[0]) : "???";
                        if (methodsObject == null) continue;
                        this.testCollections(methodsObject, ((Method)methods[i3]).getName());
                        gMethods.addProperty(new Property(gMethods, "(" + Modifier.toString(((Method)methods[i3]).getModifiers()) + " " + Modifier.toString(((Method)methods[i3]).getModifiers()) + " " + ((Method)methods[i3]).getReturnType().getName() + ") " + ((Method)methods[i3]).getName(), new StringPropertyValue(methodsObject.toString())));
                    }
                    catch (IllegalAccessException e) {
                        System.err.println("ERROR(ObjectPanel): can't invoke " + oName + "." + ((Method)methods[i3]).getName() + "()");
                    }
                    catch (InvocationTargetException e) {
                        System.err.println("ERROR(ObjectPanel): can't invoke " + oName + "." + ((Method)methods[i3]).getName() + "()");
                    }
                    continue;
                }
                gMethods.addProperty(new Property(gMethods, "(" + ((Method)methods[i3]).getReturnType().getName() + ") " + ((Method)methods[i3]).getName(), new StringPropertyValue("NA")));
            }
        }
        this._hierarchy = h;
    }

    private boolean testCollections(Object object, String name) {
        if (object instanceof Object[]) {
            this.addArray((Object[])object, name);
            return true;
        }
        if (object instanceof Collection) {
            this.addCollection((Collection)object, name);
            return true;
        }
        if (object instanceof ArrayList) {
            this.addArrayList((ArrayList)object, name);
            return true;
        }
        if (object instanceof Map) {
            this.addMap((Map)object, name);
            return true;
        }
        return false;
    }

    private void addArray(Object[] array, String name) {
        HierarchyModelNode hTemp = this._hierarchy;
        this._hierarchy = new HierarchyModelNode(name);
        hTemp.add(this._hierarchy);
        ObjectRep o = new ObjectRep();
        o.add(new ModelContext(this._hierarchy));
        String ts = "[";
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                ts = ts + "; ";
            }
            ts = ts + array[i];
        }
        ts = ts + "]";
        DocModelNode d = new DocModelNode(ts);
        o.add(new ModelContext(d));
        for (int i = 0; i < array.length; ++i) {
            this.add0(array[i]);
        }
        this._hierarchy = hTemp;
    }

    private void addCollection(Collection collection, String name) {
        HierarchyModelNode hTemp = this._hierarchy;
        this._hierarchy = new HierarchyModelNode(name);
        hTemp.add(this._hierarchy);
        ObjectRep o = new ObjectRep();
        o.add(new ModelContext(this._hierarchy));
        DocModelNode d = new DocModelNode(collection.toString());
        o.add(new ModelContext(d));
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.add0(it.next());
        }
        this._hierarchy = hTemp;
    }

    private void addArrayList(ArrayList arrayList, String name) {
        HierarchyModelNode hTemp = this._hierarchy;
        this._hierarchy = new HierarchyModelNode(name);
        hTemp.add(this._hierarchy);
        ObjectRep o = new ObjectRep();
        o.add(new ModelContext(this._hierarchy));
        DocModelNode d = new DocModelNode(arrayList.toString());
        o.add(new ModelContext(d));
        Iterator it = arrayList.iterator();
        while (it.hasNext()) {
            this.add0(it.next());
        }
        this._hierarchy = hTemp;
    }

    private void addMap(Map map, String name) {
        HierarchyModelNode hTemp = this._hierarchy;
        this._hierarchy = new HierarchyModelNode(name);
        hTemp.add(this._hierarchy);
        ObjectRep o = new ObjectRep();
        o.add(new ModelContext(this._hierarchy));
        DocModelNode d = new DocModelNode(map.toString());
        o.add(new ModelContext(d));
        Set set = map.keySet();
        Iterator it = set.iterator();
        Object[] obj = new Object[2];
        while (it.hasNext()) {
            obj[0] = it.next();
            obj[1] = map.get(obj[0]);
            this.add0(obj);
        }
        this._hierarchy = hTemp;
    }

    public void doesFields(boolean doesFields) {
        this._doesFields = doesFields;
        this.setStatus();
    }

    boolean doesFields() {
        return this._doesFields;
    }

    public void doesMethodsShow(boolean doesMethodsShow) {
        this._doesMethodsShow = doesMethodsShow;
        this.setStatus();
    }

    boolean doesMethodsShow() {
        return this._doesMethodsShow;
    }

    public void doesMethodsCall(boolean doesMethodsCall) {
        this._doesMethodsCall = doesMethodsCall;
        this.setStatus();
    }

    boolean doesMethodsCall() {
        return this._doesMethodsCall;
    }

    public void doesStatics(boolean doesStatics) {
        this._doesStatics = doesStatics;
        this.setStatus();
    }

    boolean doesStatics() {
        return this._doesStatics;
    }

    public void doesProtected(boolean doesProtected) {
        this._doesProtected = doesProtected;
        this.setStatus();
    }

    boolean doesProtected() {
        return this._doesProtected;
    }

    public void doesInherited(boolean doesInherited) {
        this._doesInherited = doesInherited;
        this.setStatus();
    }

    boolean doesInherited() {
        return this._doesInherited;
    }

    private void setStatus() {
        if (this._doesFields) {
            this._fields.setBackground(Color.green);
        } else {
            this._fields.setBackground(Color.lightGray);
        }
        if (this._doesMethodsShow) {
            this._methodsShow.setBackground(Color.green);
        } else {
            this._methodsShow.setBackground(Color.lightGray);
        }
        if (this._doesMethodsCall) {
            this._methodsCall.setBackground(Color.green);
        } else {
            this._methodsCall.setBackground(Color.lightGray);
        }
        if (this._doesStatics) {
            this._statics.setBackground(Color.green);
        } else {
            this._statics.setBackground(Color.lightGray);
        }
        if (this._doesProtected) {
            this._protected.setBackground(Color.green);
        } else {
            this._protected.setBackground(Color.lightGray);
        }
        if (this._doesInherited) {
            this._inherited.setBackground(Color.green);
        } else {
            this._inherited.setBackground(Color.lightGray);
        }
        this._update.setBackground(Color.red);
    }
}

